/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.common.services.jsp.include;

import oracle.eclipse.tools.xml.model.emfbinding.dom.INodeReader;
import oracle.eclipse.tools.xml.model.metadata.TagMetadata;
import oracle.eclipse.tools.xml.model.metadata.tlei.InclusionUriType;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IncludeElement {
    private final Element _element;
    private final String _uriAttrName;
    private final boolean _isRuntimeInclude;

    private IncludeElement(Element element, String uriAttrName, boolean isRuntimeInclude) {
        this._element = element;
        this._uriAttrName = uriAttrName;
        this._isRuntimeInclude = isRuntimeInclude;
    }

    public String getIncludeURI() {
        INodeReader reader = INodeReader.INSTANCE;
        String attrValue = reader.getAttributeValue((Node)this._element, this._uriAttrName);
        if (attrValue != null && attrValue.length() > 0) {
            return attrValue;
        }
        return null;
    }

    public Attr getURIAttribute() {
        INodeReader reader = INodeReader.INSTANCE;
        return reader.getAttribute((Node)this._element, this._uriAttrName);
    }

    public boolean isRuntimeInclude() {
        return this._isRuntimeInclude;
    }

    public static IncludeElement checkForIncludeElement(TagMetadata tagMetadata, Element element) {
        IncludeElement includeElem = null;
        if (tagMetadata != null && element != null && element instanceof IDOMElement) {
            INodeReader reader;
            String attrValue;
            String includeURI = null;
            IDOMElement domElem = (IDOMElement)element;
            String attrName = tagMetadata.getIncludeUriAttribute(domElem);
            if (attrName != null && attrName.length() > 0 && (attrValue = (reader = INodeReader.INSTANCE).getAttributeValue((Node)element, attrName)) != null && attrValue.length() > 0) {
                includeURI = attrValue;
            }
            if (includeURI != null) {
                InclusionUriType inclusionUriType = tagMetadata.getInclusionUriType(domElem, attrName);
                boolean isRuntimeInclude = inclusionUriType == null || inclusionUriType == InclusionUriType.RUNTIME;
                includeElem = new IncludeElement(element, attrName, isRuntimeInclude);
            }
        }
        return includeElem;
    }

    public static IncludeElement checkForJSPIncludeElement(IDOMElement element) {
        IncludeElement includeElem = null;
        if (element != null) {
            String attrValue;
            String includeURI = null;
            String attrName = null;
            boolean isRuntimeInclude = true;
            INodeReader reader = INodeReader.INSTANCE;
            if ("jsp:include".equals(element.getNodeName())) {
                attrName = "page";
                String attrValue2 = reader.getAttributeValue((Node)element, attrName);
                if (attrValue2 != null && attrValue2.length() > 0) {
                    includeURI = attrValue2;
                }
            } else if ("jsp:directive.include".equals(element.getNodeName()) && (attrValue = reader.getAttributeValue((Node)element, attrName = "file")) != null && attrValue.length() > 0) {
                includeURI = attrValue;
                isRuntimeInclude = false;
            }
            if (includeURI != null) {
                includeElem = new IncludeElement((Element)element, attrName, isRuntimeInclude);
            }
        }
        return includeElem;
    }
}

