/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.common.services.facet.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.common.services.facet.FacetTemplatesHelper;
import oracle.eclipse.tools.webtier.common.services.facet.ui.ConfirmFileActionDialog;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class ConfirmFileOverwriteDialog
extends ConfirmFileActionDialog {
    public ConfirmFileOverwriteDialog(IProject project, IProjectFacetVersion fv, IProgressMonitor monitor, FacetTemplatesHelper facetTemplatesHelper) {
        super(project, fv, monitor, facetTemplatesHelper);
    }

    @Override
    protected void executeFileAction(ListSelectionDialog dialog) {
        Object[] objectArray = dialog.getResult();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object selectedIfile = objectArray[n2];
            if (!(selectedIfile instanceof IFile)) {
                throw new IllegalArgumentException("Dialog is expected to accept only IFiles");
            }
            IFile ifileToOverwrite = (IFile)selectedIfile;
            if (ifileToOverwrite.isAccessible()) {
                try {
                    this.overwriteFile(this.project, this.monitor, ifileToOverwrite);
                }
                catch (Exception e) {
                    LoggingService.logError((String)"oracle.eclipse.tools.webtier.common.services", (String)e.getLocalizedMessage());
                }
            }
            ++n2;
        }
    }

    private void overwriteFile(IProject project1, IProgressMonitor monitor1, IFile ifileToOverwrite) throws IOException, URISyntaxException, CoreException, FileNotFoundException {
        File templateFile = this.facetTemplatesHelper.getTemplateFile(ifileToOverwrite);
        IFile destinationFile = project1.getFile(ifileToOverwrite.getProjectRelativePath());
        ifileToOverwrite.delete(true, monitor1);
        destinationFile.create((InputStream)new FileInputStream(templateFile), 1, monitor1);
    }
}

