/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.creation.core.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.ws.internal.cxf.core.CXFCorePlugin;
import org.eclipse.jst.ws.internal.cxf.core.context.Java2WSPersistentContext;
import org.eclipse.jst.ws.internal.cxf.core.model.CXFDataModel;
import org.eclipse.jst.ws.internal.cxf.core.model.Java2WSDataModel;
import org.eclipse.jst.ws.internal.cxf.core.utils.CXFModelUtils;
import org.eclipse.jst.ws.internal.cxf.creation.core.CXFCreationCorePlugin;
import org.eclipse.jst.ws.jaxws.core.utils.JDTUtils;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class Java2WSDefaultingCommand
extends AbstractDataModelOperation {
    private Java2WSDataModel model;

    public Java2WSDefaultingCommand(Java2WSDataModel model) {
        this.model = model;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        try {
            Java2WSPersistentContext context = CXFCorePlugin.getDefault().getJava2WSContext();
            this.model.setDefaultRuntimeVersion(context.getDefaultRuntimeVersion());
            this.model.setDefaultRuntimeType(context.getDefaultRuntimeType());
            IType startingPointType = this.getJavaStartingPointType();
            this.model.setUseServiceEndpointInterface(startingPointType.isInterface());
            this.model.setExtractInterface(false);
            String packageName = startingPointType.getPackageFragment().getElementName();
            this.model.setTargetNamespace(JDTUtils.getTargetNamespaceFromPackageName((String)packageName));
            this.model.setAnnotationProcessingEnabled(context.isAnnotationProcessingEnabled());
            this.model.setGenerateWebMethodAnnotation(context.isGenerateWebMethodAnnotation());
            this.model.setGenerateWebParamAnnotation(context.isGenerateWebParamAnnotation());
            this.model.setGenerateRequestWrapperAnnotation(context.isGenerateRequestWrapperAnnotation());
            this.model.setGenerateResponseWrapperAnnotation(context.isGenerateResponseWrapperAnnotation());
            this.model.setGenerateWebResultAnnotation(context.isGenerateWebResultAnnotation());
            this.model.setAnnotationMap(CXFModelUtils.getAnnotationMap((Java2WSDataModel)this.model));
            this.model.setMethodMap(CXFModelUtils.getMethodMap((IType)startingPointType, (Java2WSDataModel)this.model));
            this.model.setGenerateXSDImports(context.isGenerateXSDImports());
            this.model.setDatabinding(context.getDatabinding());
            this.model.setFrontend(context.getFrontend());
            this.model.setGenerateClient(context.isGenerateClient());
            this.model.setGenerateServer(context.isGenerateServer());
            this.model.setSoap12Binding(context.isSoap12Binding());
            this.model.setGenerateWrapperFaultBeans(context.isGenerateWrapperFaultBeans());
            this.model.setGenerateWSDL(context.isGenerateWSDL());
            this.model.setUseSpringApplicationContext(context.isUseSpringApplicationContext());
            this.model.setVerbose(context.isVerbose());
            String className = this.getClassName(this.model.getProjectName(), this.model.getJavaStartingPoint());
            this.model.setWsdlFileName(String.valueOf(className.toLowerCase()) + ".wsdl");
        }
        catch (JavaModelException jme) {
            status = jme.getStatus();
            CXFCreationCorePlugin.log(status);
        }
        return status;
    }

    public CXFDataModel getJava2WSDataModel() {
        return this.model;
    }

    public IType getJavaStartingPointType() {
        String projectName = this.model.getProjectName();
        String javaStartingPoint = this.model.getJavaStartingPoint();
        IJavaProject javaProject = JDTUtils.getJavaProject((String)projectName);
        IType startingPointType = JDTUtils.findType((IJavaProject)javaProject, (String)javaStartingPoint);
        return startingPointType;
    }

    public String getClassName(String projectName, String fullyQualifiedClassName) {
        return JDTUtils.findType((IJavaProject)JDTUtils.getJavaProject((String)projectName), (String)fullyQualifiedClassName).getElementName();
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        return status;
    }
}

