/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.changes;

import com.python.pydev.refactoring.changes.PyChange;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.python.pydev.shared_core.string.StringUtils;

public final class PyRenameResourceChange
extends PyChange {
    private final String fComment;
    private final String fNewName;
    private final IPath fResourcePath;
    private final long fStampToRestore;

    public static IPath renamedResourcePath(IPath path, String newName) {
        return path.removeLastSegments(1).append(newName);
    }

    private PyRenameResourceChange(IPath resourcePath, String newName, String comment, long stampToRestore) {
        this.fResourcePath = resourcePath;
        this.fNewName = newName;
        this.fComment = comment;
        this.fStampToRestore = stampToRestore;
    }

    public PyRenameResourceChange(IResource resource, String newName, String comment) {
        this(resource.getFullPath(), newName, comment, -1L);
    }

    public Object getModifiedElement() {
        return this.getResource();
    }

    public String getName() {
        return StringUtils.format((String)"Rename %s to %s", (Object[])new Object[]{this.fResourcePath, this.fNewName});
    }

    public String getNewName() {
        return this.fNewName;
    }

    private IResource getResource() {
        return ResourcesPlugin.getWorkspace().getRoot().findMember(this.fResourcePath);
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        IResource resource = this.getResource();
        if (resource == null || !resource.exists()) {
            return RefactoringStatus.createFatalErrorStatus((String)StringUtils.format((String)"Resource %s does not exist", (Object[])new Object[]{this.fResourcePath}));
        }
        return super.isValid(pm, 2);
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask(this.getName(), 1);
            IResource resource = this.getResource();
            long currentStamp = resource.getModificationStamp();
            IPath newPath = PyRenameResourceChange.renamedResourcePath(this.fResourcePath, this.fNewName);
            resource.move(newPath, 32, pm);
            if (this.fStampToRestore != -1L) {
                IResource newResource = ResourcesPlugin.getWorkspace().getRoot().findMember(newPath);
                newResource.revertModificationStamp(this.fStampToRestore);
            }
            String oldName = this.fResourcePath.lastSegment();
            PyRenameResourceChange pyRenameResourceChange = new PyRenameResourceChange(newPath, oldName, this.fComment, currentStamp);
            return pyRenameResourceChange;
        }
        finally {
            pm.done();
        }
    }
}

