/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TaskKeyComparator
implements Comparator<String[]> {
    private static final String MODULE_TASK_PATTERN = "(?:([A-Za-z]*[:_\\-]?)(\\d+))?";
    private static final Pattern ID_PATTERN = Pattern.compile("(?:([A-Za-z]*[:_\\-]?)(\\d+))?");
    public static final Pattern PATTERN = Pattern.compile("(?:([A-Za-z]*[:_\\-]?)(\\d+))?(.*)");

    public int compare2(String o1, String o2) {
        String[] a1 = this.split(o1);
        String[] a2 = this.split(o2);
        return this.compare(a1, a2);
    }

    @Override
    public int compare(String[] a1, String[] a2) {
        if (a1[0] == null && a1[1] == null) {
            a1 = this.split(a1[2]);
        } else if ((a1[0] == null || a1[0].length() == 0) && a1[1] != null && a1[1].length() > 0) {
            String[] b1 = TaskKeyComparator.splitTask(a1[1]);
            a1[0] = b1[0];
            a1[1] = b1[1];
        }
        if (a2[0] == null && a2[1] == null) {
            a2 = this.split(a2[2]);
        } else if ((a2[0] == null || a2[0].length() == 0) && a2[1] != null && a2[1].length() > 0) {
            String[] b2 = TaskKeyComparator.splitTask(a2[1]);
            a2[0] = b2[0];
            a2[1] = b2[1];
        }
        return TaskKeyComparator.compare(a1[0], a1[1], a1[2], a2[0], a2[1], a2[2]);
    }

    private static int compare(String component1, String key1, String value1, String component2, String key2, String value2) {
        if (component1 == null && component2 != null) {
            return -1;
        }
        if (component1 != null && component2 == null) {
            return 1;
        }
        if (component1 != null && component2 != null) {
            int n = component1.compareToIgnoreCase(component2);
            if (n != 0) {
                return n;
            }
            if (key1 == null && key2 != null) {
                return -1;
            }
            if (key1 != null && key2 == null) {
                return 1;
            }
            if (key1 != null && key2 != null) {
                if (key1.length() == key2.length() || key1.length() == 0 || key2.length() == 0) {
                    n = key1.compareTo(key2);
                } else {
                    try {
                        n = Long.valueOf(key1).compareTo(Long.valueOf(key2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        n = key1.compareTo(key2);
                    }
                }
                if (n != 0) {
                    return n;
                }
            }
        }
        return value1.compareToIgnoreCase(value2);
    }

    public String[] split(String s) {
        Matcher matcher = PATTERN.matcher(s);
        if (!matcher.find()) {
            String[] stringArray = new String[3];
            stringArray[2] = s;
            return stringArray;
        }
        int n = matcher.groupCount();
        String[] res = new String[n];
        int i = 1;
        while (i < n + 1) {
            res[i - 1] = matcher.group(i);
            ++i;
        }
        return res;
    }

    private static String[] splitTask(String s) {
        Matcher matcher = ID_PATTERN.matcher(s);
        if (!matcher.find()) {
            String[] stringArray = new String[2];
            stringArray[1] = s;
            return stringArray;
        }
        int n = matcher.groupCount();
        String[] res = new String[n];
        int i = 1;
        while (i < n + 1) {
            res[i - 1] = matcher.group(i);
            ++i;
        }
        return res;
    }
}

