/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.ui.properties.sections;

import java.util.HashMap;
import oracle.eclipse.tools.jaxrs.properties.AnnotationType;
import oracle.eclipse.tools.jaxrs.properties.IAnnotationType;
import oracle.eclipse.tools.jaxrs.properties.elements.IAnnotationElement;
import oracle.eclipse.tools.jaxrs.properties.model.IApplicationPath;
import oracle.eclipse.tools.jaxrs.properties.model.IConsumes;
import oracle.eclipse.tools.jaxrs.properties.model.ICookieParam;
import oracle.eclipse.tools.jaxrs.properties.model.IDefaultValue;
import oracle.eclipse.tools.jaxrs.properties.model.IDelete;
import oracle.eclipse.tools.jaxrs.properties.model.IEncoded;
import oracle.eclipse.tools.jaxrs.properties.model.IFormParam;
import oracle.eclipse.tools.jaxrs.properties.model.IGet;
import oracle.eclipse.tools.jaxrs.properties.model.IHead;
import oracle.eclipse.tools.jaxrs.properties.model.IHeaderParam;
import oracle.eclipse.tools.jaxrs.properties.model.IJwsAnnotation;
import oracle.eclipse.tools.jaxrs.properties.model.IMatrixParam;
import oracle.eclipse.tools.jaxrs.properties.model.IPath;
import oracle.eclipse.tools.jaxrs.properties.model.IPathParam;
import oracle.eclipse.tools.jaxrs.properties.model.IPost;
import oracle.eclipse.tools.jaxrs.properties.model.IProduces;
import oracle.eclipse.tools.jaxrs.properties.model.IProvider;
import oracle.eclipse.tools.jaxrs.properties.model.IPut;
import oracle.eclipse.tools.jaxrs.properties.model.IQueryParam;
import oracle.eclipse.tools.jaxrs.properties.model.internal.ApplicationPathResource;
import oracle.eclipse.tools.jaxrs.properties.model.internal.ConsumesResource;
import oracle.eclipse.tools.jaxrs.properties.model.internal.CookieParamResource;
import oracle.eclipse.tools.jaxrs.properties.model.internal.DefaultValueResource;
import oracle.eclipse.tools.jaxrs.properties.model.internal.DeleteResource;
import oracle.eclipse.tools.jaxrs.properties.model.internal.EncodedResource;
import oracle.eclipse.tools.jaxrs.properties.model.internal.FormParamResource;
import oracle.eclipse.tools.jaxrs.properties.model.internal.GetResource;
import oracle.eclipse.tools.jaxrs.properties.model.internal.HeadResource;
import oracle.eclipse.tools.jaxrs.properties.model.internal.HeaderParamResource;
import oracle.eclipse.tools.jaxrs.properties.model.internal.MatrixParamResource;
import oracle.eclipse.tools.jaxrs.properties.model.internal.PathParamResource;
import oracle.eclipse.tools.jaxrs.properties.model.internal.PathResource;
import oracle.eclipse.tools.jaxrs.properties.model.internal.PostResource;
import oracle.eclipse.tools.jaxrs.properties.model.internal.ProducesResource;
import oracle.eclipse.tools.jaxrs.properties.model.internal.ProviderResource;
import oracle.eclipse.tools.jaxrs.properties.model.internal.PutResource;
import oracle.eclipse.tools.jaxrs.properties.model.internal.QueryParamResource;
import org.eclipse.sapphire.Resource;

public class AnnotationFactory {
    private static HashMap<IAnnotationElement, IJwsAnnotation> annotationMap = new HashMap();

    public static IJwsAnnotation getAnnotation(IAnnotationElement annotationElement) {
        IJwsAnnotation annotation = annotationMap.get(annotationElement);
        if (annotation == null) {
            IAnnotationType iType = annotationElement.getAnnotationType();
            if (iType instanceof AnnotationType) {
                AnnotationType annotationType = (AnnotationType)iType;
                switch (annotationType) {
                    case Path: {
                        annotation = (IJwsAnnotation)IPath.TYPE.instantiate((Resource)new PathResource(null, annotationElement));
                        break;
                    }
                    case ApplicationPath: {
                        annotation = (IJwsAnnotation)IApplicationPath.TYPE.instantiate((Resource)new ApplicationPathResource(null, annotationElement));
                        break;
                    }
                    case Produces: {
                        annotation = (IJwsAnnotation)IProduces.TYPE.instantiate((Resource)new ProducesResource(null, annotationElement));
                        break;
                    }
                    case Consumes: {
                        annotation = (IJwsAnnotation)IConsumes.TYPE.instantiate((Resource)new ConsumesResource(null, annotationElement));
                        break;
                    }
                    case Encoded: {
                        annotation = (IJwsAnnotation)IEncoded.TYPE.instantiate((Resource)new EncodedResource(null, annotationElement));
                        break;
                    }
                    case Provider: {
                        annotation = (IJwsAnnotation)IProvider.TYPE.instantiate((Resource)new ProviderResource(null, annotationElement));
                        break;
                    }
                    case Get: {
                        annotation = (IJwsAnnotation)IGet.TYPE.instantiate((Resource)new GetResource(null, annotationElement));
                        break;
                    }
                    case Delete: {
                        annotation = (IJwsAnnotation)IDelete.TYPE.instantiate((Resource)new DeleteResource(null, annotationElement));
                        break;
                    }
                    case Head: {
                        annotation = (IJwsAnnotation)IHead.TYPE.instantiate((Resource)new HeadResource(null, annotationElement));
                        break;
                    }
                    case Post: {
                        annotation = (IJwsAnnotation)IPost.TYPE.instantiate((Resource)new PostResource(null, annotationElement));
                        break;
                    }
                    case Put: {
                        annotation = (IJwsAnnotation)IPut.TYPE.instantiate((Resource)new PutResource(null, annotationElement));
                        break;
                    }
                    case PathParam: {
                        annotation = (IJwsAnnotation)IPathParam.TYPE.instantiate((Resource)new PathParamResource(null, annotationElement));
                        break;
                    }
                    case FormParam: {
                        annotation = (IJwsAnnotation)IFormParam.TYPE.instantiate((Resource)new FormParamResource(null, annotationElement));
                        break;
                    }
                    case MatrixParam: {
                        annotation = (IJwsAnnotation)IMatrixParam.TYPE.instantiate((Resource)new MatrixParamResource(null, annotationElement));
                        break;
                    }
                    case CookieParam: {
                        annotation = (IJwsAnnotation)ICookieParam.TYPE.instantiate((Resource)new CookieParamResource(null, annotationElement));
                        break;
                    }
                    case HeaderParam: {
                        annotation = (IJwsAnnotation)IHeaderParam.TYPE.instantiate((Resource)new HeaderParamResource(null, annotationElement));
                        break;
                    }
                    case QueryParam: {
                        annotation = (IJwsAnnotation)IQueryParam.TYPE.instantiate((Resource)new QueryParamResource(null, annotationElement));
                        break;
                    }
                    case DefaultValue: {
                        annotation = (IJwsAnnotation)IDefaultValue.TYPE.instantiate((Resource)new DefaultValueResource(null, annotationElement));
                    }
                }
            }
            annotationMap.put(annotationElement, annotation);
        }
        return annotation;
    }
}

