/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.ui.properties.elements;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.jaxrs.properties.IAnnotationType;
import oracle.eclipse.tools.jaxrs.properties.elements.IAnnotationElement;
import oracle.eclipse.tools.jaxrs.properties.elements.IJavaElement;
import oracle.eclipse.tools.jaxrs.ui.properties.context.RestPropertyContentProvider;
import oracle.eclipse.tools.jaxrs.ui.properties.elements.AnnotationElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jface.viewers.IStructuredSelection;

public abstract class JavaElement
implements IStructuredSelection,
IJavaElement {
    private final RestPropertyContentProvider restPropertyData;
    private final List<IAnnotationElement> annotations = new ArrayList<IAnnotationElement>();
    private ASTNode astNode;

    public JavaElement(RestPropertyContentProvider webServicePropertyData) {
        this.restPropertyData = webServicePropertyData;
    }

    protected abstract void generateAnnotationElements();

    public List<IAnnotationElement> getAnnotations() {
        return this.annotations;
    }

    public void addAnnotationElement(IAnnotationElement e) {
        this.annotations.add(e);
    }

    public void removeAnnotationElement(IAnnotationType type) {
        IAnnotationElement ae = this.getAnnotation(type);
        if (ae != null) {
            this.annotations.remove(ae);
        }
    }

    public IAnnotationElement getAnnotation(IAnnotationType type) {
        for (IAnnotationElement element : this.annotations) {
            if (!element.getAnnotationType().equals(type)) continue;
            return element;
        }
        return null;
    }

    public void refresh(ASTNode node) {
        if (this.isElementTypeNode(node)) {
            this.astNode = node;
            for (IAnnotationElement element : this.annotations) {
                element.refresh();
            }
        }
    }

    public void update(ASTNode node) {
        if (this.isElementTypeNode(node)) {
            this.astNode = node;
            for (IAnnotationElement element : this.annotations) {
                element.update();
            }
        }
    }

    public RestPropertyContentProvider getRestPropertyData() {
        return this.restPropertyData;
    }

    public ASTNode getASTNode() {
        return this.astNode;
    }

    public boolean isEmpty() {
        return this.annotations == null || this.annotations.size() == 0;
    }

    public Object getFirstElement() {
        return this.isEmpty() ? null : this.annotations.get(0);
    }

    public Iterator<IAnnotationElement> iterator() {
        return this.annotations.iterator();
    }

    public int size() {
        return this.annotations == null ? 0 : this.annotations.size();
    }

    public Object[] toArray() {
        return this.annotations == null ? new Object[]{} : this.annotations.toArray(new AnnotationElement[this.annotations.size()]);
    }

    public List<IAnnotationElement> toList() {
        return this.annotations;
    }

    public IJavaProject getJavaProject() {
        if (this.restPropertyData.getIcompilationUnit() != null) {
            return this.restPropertyData.getIcompilationUnit().getJavaProject();
        }
        return null;
    }

    public IResource getResource() {
        if (this.restPropertyData.getIcompilationUnit() != null) {
            return this.restPropertyData.getIcompilationUnit().getResource();
        }
        return null;
    }

    public void rewriteAnnotation(Annotation annotation, String attrName, Object value) {
        if (this.getRestPropertyData() != null) {
            this.getRestPropertyData().rewriteAnnotation(annotation, attrName, value);
        }
    }

    public void rewriteAnnotationAsArrayAttributes(Annotation annotation, String attrName, List<Object> value) {
        if (this.getRestPropertyData() != null) {
            this.getRestPropertyData().rewriteAnnotationAsArrayAttributes(annotation, attrName, value);
        }
    }

    public void addAnnotation(BodyDeclaration parent, String fullyQualifiedName, Map<String, String> attrs) {
        if (this.getRestPropertyData() != null) {
            this.getRestPropertyData().addAnnotation(parent, fullyQualifiedName, attrs);
        }
    }

    public void addAnnotationAsArrayAttributes(BodyDeclaration parent, String fullyQualifiedName, Map<String, List<Object>> attrs) {
        if (this.getRestPropertyData() != null) {
            this.getRestPropertyData().addAnnotationAsArrayAttributes(parent, fullyQualifiedName, attrs);
        }
    }

    public void addAnnotation(SingleVariableDeclaration parent, String fullyQualifiedName, Map<String, String> attrs) {
        if (this.getRestPropertyData() != null) {
            this.getRestPropertyData().addAnnotation(parent, fullyQualifiedName, attrs);
        }
    }

    public void addAnnotationAsArrayAttributes(SingleVariableDeclaration parent, String fullyQualifiedName, Map<String, List<Object>> attrs) {
        if (this.getRestPropertyData() != null) {
            this.getRestPropertyData().addAnnotationAsArrayAttributes(parent, fullyQualifiedName, attrs);
        }
    }

    public void removeAnnotation(ASTNode node) {
        if (this.getRestPropertyData() != null) {
            this.getRestPropertyData().removeAnnotation(node);
        }
    }

    public void refresh() {
        if (this.getRestPropertyData() != null) {
            this.getRestPropertyData().refresh();
        }
    }
}

