/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.ui.properties.elements;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.jaxrs.properties.IPropertyType;
import oracle.eclipse.tools.jaxrs.properties.context.AnnotationVisitor;
import oracle.eclipse.tools.jaxrs.properties.elements.IAnnotationElement;
import oracle.eclipse.tools.jaxrs.properties.elements.IJavaElement;
import oracle.eclipse.tools.jaxrs.ui.properties.elements.JavaElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;

public abstract class AnnotationElement
implements IAnnotationElement,
IWorkbenchAdapter {
    private static final char DOT = '.';
    private final JavaElement parent;
    private Annotation node;
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    protected static final HashMap<IPropertyType, String> DEFAULT_VALUES = new HashMap();

    public AnnotationElement(IJavaElement parent) {
        this.parent = (JavaElement)parent;
        this.createElement();
    }

    public String getFullyQualifiedName() {
        return this.getAnnotationType().getFullyQualifiedName();
    }

    public void setNode(Annotation node) {
        this.node = node;
    }

    public Annotation getNode() {
        return this.node;
    }

    public ASTNode getParentNode() {
        return this.parent.getASTNode();
    }

    public boolean isEqual(String name) {
        return this.getSimpleName().equals(name) || this.getFullyQualifiedName().equals(name);
    }

    public boolean contains(String name) {
        return false;
    }

    private String getSimpleName() {
        return this.getAnnotationType().getSimpleName();
    }

    protected void createElement() {
        this.setNode(null);
        this.clearAttributeValues();
        if (this.getParentNode() != null) {
            this.getParentNode().accept((ASTVisitor)new AnnotationVisitor((IAnnotationElement)this, (IJavaElement)this.parent));
        }
    }

    public void parseNormalAnnotationMemberPairs(NormalAnnotation normalAnnotation) {
        List memberValuePairs = normalAnnotation.values();
        if (memberValuePairs.size() == 0) {
            this.clearAttributeValues();
        }
        for (MemberValuePair mvPair : memberValuePairs) {
            this.setAttributeValue(mvPair.getName().getIdentifier(), mvPair.getValue());
        }
    }

    public void parseSingleMemberAnnotation(SingleMemberAnnotation smAnnotation) {
        this.setAttributeValue("value", smAnnotation.getValue());
    }

    public IJavaElement getJavaElement() {
        return this.parent;
    }

    protected void clearAttributeValues() {
        IPropertyType[] iPropertyTypeArray = this.getPropertyTypes();
        int n = iPropertyTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyType type = iPropertyTypeArray[n2];
            this.setAttributeValue(type.getIdentifier(), null);
            ++n2;
        }
    }

    protected abstract void setAttributeValue(String var1, Expression var2);

    protected abstract Expression getAttribute(String var1);

    public void update() {
        this.createElement();
        this.updateChildren();
    }

    public void refresh() {
        this.createElement();
        this.updateChildren();
        this.refreshChildren();
        this.firePropertyChange(null, null, null);
    }

    protected void updateChildren() {
    }

    protected void refreshChildren() {
    }

    public String getAttributeValue(String identifier) {
        Expression expression = this.getAttribute(identifier);
        if (expression instanceof StringLiteral) {
            return ((StringLiteral)expression).getLiteralValue();
        }
        if (expression instanceof TypeLiteral) {
            Type type = ((TypeLiteral)expression).getType();
            if (type.isSimpleType()) {
                return ((SimpleType)type).getName().getFullyQualifiedName();
            }
        } else {
            if (expression instanceof QualifiedName) {
                return this.getQualifiedIdentifier((Name)((QualifiedName)expression));
            }
            if (expression instanceof BooleanLiteral) {
                return Boolean.toString(((BooleanLiteral)expression).booleanValue());
            }
        }
        return null;
    }

    public List<Object> getAttributeValueArray(String identifier) {
        Expression expression = this.getAttribute(identifier);
        ArrayList<Object> values = new ArrayList<Object>();
        if (expression instanceof ArrayInitializer) {
            List expressions = ((ArrayInitializer)expression).expressions();
            for (Object expr : expressions) {
                if (expr == null) continue;
                values.add(this.getExpressionValue((Expression)expr));
            }
        } else {
            String value = this.getExpressionValue(expression);
            if (value != null) {
                values.add(this.getExpressionValue(expression));
            }
        }
        return values;
    }

    private String getExpressionValue(Expression expression) {
        if (expression instanceof StringLiteral) {
            return ((StringLiteral)expression).getLiteralValue();
        }
        if (expression instanceof TypeLiteral) {
            Type type = ((TypeLiteral)expression).getType();
            if (type.isSimpleType()) {
                return ((SimpleType)type).getName().getFullyQualifiedName();
            }
        } else {
            if (expression instanceof QualifiedName) {
                return this.getQualifiedIdentifier((Name)((QualifiedName)expression));
            }
            if (expression instanceof BooleanLiteral) {
                return Boolean.toString(((BooleanLiteral)expression).booleanValue());
            }
        }
        return null;
    }

    public void writeAttributeValue(String identifier, String value) {
        if (value != null && !this.isAnnotationSet()) {
            HashMap<String, String> attr = new HashMap<String, String>();
            attr.put(identifier, value);
            this.addAnnotation(this.getAnnotationType().getFullyQualifiedName(), attr);
        } else if ((value == null || value.equals("")) && this.isAnnotationEmpty(identifier) && this.removeOnEmpty()) {
            this.clearAnnotation();
        } else {
            this.parent.rewriteAnnotation(this.getNode(), identifier, value);
        }
    }

    public void writeAttributeValueArray(String identifier, List<Object> value) {
        if (value != null && !this.isAnnotationSet()) {
            HashMap<String, List<Object>> attr = new HashMap<String, List<Object>>();
            attr.put(identifier, value);
            this.addAnnotationAsArrayAttributes(this.getAnnotationType().getFullyQualifiedName(), attr);
        } else if ((value == null || value.isEmpty()) && this.isAnnotationEmpty(identifier) && this.removeOnEmpty()) {
            this.clearAnnotation();
        } else {
            this.parent.rewriteAnnotationAsArrayAttributes(this.getNode(), identifier, value);
        }
    }

    public boolean isAnnotationSet() {
        return this.getNode() != null;
    }

    public void setAnnotation() {
        if (!this.isAnnotationSet()) {
            this.addAnnotation(this.getAnnotationType().getFullyQualifiedName(), null);
        }
    }

    public void clearAnnotation() {
        if (this.isAnnotationSet()) {
            this.setRemoveAsChild(true);
            this.clearAttributeValues();
            this.parent.removeAnnotation((ASTNode)this.getNode());
        }
    }

    boolean isRemoveAsChild() {
        return false;
    }

    void setRemoveAsChild(boolean removeAsChild) {
    }

    boolean removeOnEmpty() {
        return !this.getAnnotationType().isMarker();
    }

    public String getDefaultElementValue(String identifier) {
        return DEFAULT_VALUES.get(this.getPropertyType(identifier));
    }

    public String getElementValue(String identifier) {
        return this.getAttributeValue(identifier);
    }

    public void setElementValue(String identifier, String value) {
        if (value == null || value.length() != 1 || value.charAt(0) != '.') {
            this.writeAttributeValue(identifier, value);
        }
    }

    public List<Object> getElementValueList(String identifier) {
        return this.getAttributeValueArray(identifier);
    }

    public void setElementValueList(String identifier, List<Object> values) {
        if (values == null) {
            this.writeAttributeValue(identifier, null);
        } else if (values.size() == 1) {
            String value = (String)values.get(0);
            if (value == null || value.length() != 1 || value.charAt(0) != '.') {
                this.writeAttributeValue(identifier, value);
            }
        } else {
            ArrayList<Object> filterValue = new ArrayList<Object>();
            for (Object oVal : values) {
                if (oVal instanceof String) {
                    String value = (String)oVal;
                    if (value != null && value.length() == 1 && value.charAt(0) == '.') continue;
                    filterValue.add(value);
                    continue;
                }
                filterValue.add(oVal);
            }
            this.writeAttributeValueArray(identifier, filterValue);
        }
    }

    public IStatus validateElementValue(String identifier, String value) {
        return Status.OK_STATUS;
    }

    public boolean isElementSet(String identifier) {
        return this.getNode() != null && this.getAttribute(identifier) != null;
    }

    public void clearElement(String identifier) {
        this.setElementValue(identifier, null);
    }

    public IFile getSourceFile() {
        IResource resource = this.parent.getResource();
        if (resource instanceof IFile) {
            return (IFile)resource;
        }
        return null;
    }

    private boolean isAnnotationEmpty(String identifierToExclude) {
        IPropertyType[] iPropertyTypeArray = this.getPropertyTypes();
        int n = iPropertyTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyType propertyType = iPropertyTypeArray[n2];
            if (!propertyType.getIdentifier().equals(identifierToExclude) && this.isElementSet(propertyType.getIdentifier())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void addAnnotation(String identifier, Map<String, String> attrs) {
        if (this.getNode() == null) {
            if (this.parent.getASTNode() instanceof BodyDeclaration) {
                this.parent.addAnnotation((BodyDeclaration)this.parent.getASTNode(), identifier, attrs);
            } else if (this.parent.getASTNode() instanceof SingleVariableDeclaration) {
                this.parent.addAnnotation((SingleVariableDeclaration)this.parent.getASTNode(), identifier, attrs);
            }
        }
    }

    public void addAnnotationAsArrayAttributes(String identifier, Map<String, List<Object>> attrs) {
        if (this.getNode() == null) {
            if (this.parent.getASTNode() instanceof BodyDeclaration) {
                this.parent.addAnnotationAsArrayAttributes((BodyDeclaration)this.parent.getASTNode(), identifier, attrs);
            } else if (this.parent.getASTNode() instanceof SingleVariableDeclaration) {
                this.parent.addAnnotationAsArrayAttributes((SingleVariableDeclaration)this.parent.getASTNode(), identifier, attrs);
            }
        }
    }

    public AnnotationElement addChildElement(String identifier, Map<String, String> attrs) {
        return null;
    }

    public Object getParent(Object o) {
        return this.parent;
    }

    public Object[] getChildren(Object o) {
        return new Object[0];
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object o) {
        return this.getAnnotationType().getLabel();
    }

    public void setInput() {
        if (this.parent != null) {
            this.parent.refresh();
        }
    }

    public boolean isSet() {
        return this.node != null;
    }

    protected abstract IPropertyType[] getPropertyTypes();

    public abstract IPropertyType getPropertyType(String var1);

    public String getID() {
        return this.getAnnotationType().getFullyQualifiedName();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listeners.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listeners.removePropertyChangeListener(l);
    }

    protected void firePropertyChange(String prop, Object old, Object newValue) {
        this.listeners.firePropertyChange(prop, old, newValue);
    }

    public String getTabIdentifier() {
        return String.valueOf(this.parent.getType().getIdentifier()) + this.getAnnotationType().getLabel();
    }

    public String getQualifiedIdentifier(Name name) {
        String typeName = "";
        while (name.isQualifiedName()) {
            QualifiedName qualifiedName = (QualifiedName)name;
            typeName = "." + qualifiedName.getName().getIdentifier() + typeName;
            name = qualifiedName.getQualifier();
        }
        if (!name.isSimpleName()) {
            return null;
        }
        typeName = String.valueOf(((SimpleName)name).getIdentifier()) + typeName;
        return typeName;
    }
}

