/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.ui.launcher;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.jaxrs.launcher.model.IJaxrsMethod;
import oracle.eclipse.tools.jaxrs.launcher.model.IJaxrsModel;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.DelayedTasksExecutor;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.ListSelectionService;
import org.eclipse.sapphire.ui.PartValidationEvent;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.def.PartDef;
import org.eclipse.sapphire.ui.forms.DialogDef;
import org.eclipse.sapphire.ui.forms.DialogPart;
import org.eclipse.sapphire.ui.forms.FormPart;
import org.eclipse.sapphire.ui.forms.PropertyEditorPart;
import org.eclipse.sapphire.ui.forms.swt.FormComponentPresentation;
import org.eclipse.sapphire.ui.forms.swt.GridLayoutUtil;
import org.eclipse.sapphire.util.IdentityHashSet;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class MethodDialog
extends Dialog {
    private Element element;
    private DefinitionLoader.Reference<DialogDef> definition = DefinitionLoader.context(MethodDialog.class).sdef("JaxrsResource").dialog("methodDialog");
    private DialogPart part;
    private Button okButton;
    private String pathUrl;

    public MethodDialog(Shell shell, Element element) {
        super(shell);
        if (element == null) {
            throw new IllegalArgumentException();
        }
        if (this.definition == null) {
            throw new IllegalArgumentException();
        }
        this.element = element;
        this.part = new DialogPart();
        this.part.init(null, this.element, (PartDef)this.definition.resolve(), Collections.emptyMap());
        this.part.initialize();
    }

    public final Element element() {
        return this.element;
    }

    public final DialogDef definition() {
        return (DialogDef)this.definition.resolve();
    }

    protected Control createDialogArea(Composite parent) {
        Shell shell = this.getShell();
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                MethodDialog.this.element = null;
                MethodDialog.this.part.dispose();
                MethodDialog.this.part = null;
                MethodDialog.this.definition.dispose();
                MethodDialog.this.definition = null;
            }
        });
        shell.setText(this.part.getLabel());
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setBackground(this.part.getSwtResourceCache().color(this.part.getBackgroundColor()));
        Composite innerComposite = new Composite(composite, 0);
        innerComposite.setLayout((Layout)GridLayoutUtil.glayout((int)2, (int)0, (int)0));
        innerComposite.setLayoutData((Object)GridLayoutUtil.gdfill());
        FormComponentPresentation presentation = this.part.createPresentation(null, innerComposite);
        presentation.render();
        String initialFocusProperty = (String)this.part.definition().getInitialFocus().content();
        if (initialFocusProperty != null) {
            this.part.setFocus(initialFocusProperty);
        }
        return composite;
    }

    protected Control createContents(Composite parent) {
        Composite composite = (Composite)super.createContents(parent);
        composite.setBackground(this.part.getSwtResourceCache().color(this.part.getBackgroundColor()));
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = (Composite)super.createButtonBar(parent);
        composite.setBackground(this.part.getSwtResourceCache().color(this.part.getBackgroundColor()));
        this.okButton = this.getButton(0);
        this.part.attach((Listener)new FilteredListener<PartValidationEvent>(){

            protected void handleTypedEvent(PartValidationEvent event) {
                MethodDialog.this.updateOkButtonEnablement();
            }
        });
        this.updateOkButtonEnablement();
        return composite;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        button.setBackground(this.part.getSwtResourceCache().color(this.part.getBackgroundColor()));
        return button;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        DelayedTasksExecutor.sweep();
        PropertyEditorPart propPart = this.findPropertyEditor((ISapphirePart)this.part, this.element, (PropertyDef)IJaxrsModel.PROP_METHODS);
        ListSelectionService selectionService = (ListSelectionService)propPart.service(ListSelectionService.class);
        List list = selectionService.selection();
        IJaxrsMethod element = (IJaxrsMethod)list.get(0);
        this.pathUrl = element.getPath().text();
        super.okPressed();
    }

    private void updateOkButtonEnablement() {
        boolean actual;
        boolean expected;
        if (!this.okButton.isDisposed() && (expected = this.part.validation().severity() != Status.Severity.ERROR) != (actual = this.okButton.isEnabled())) {
            this.okButton.setEnabled(expected);
        }
    }

    private PropertyEditorPart findPropertyEditor(ISapphirePart part, Element element, PropertyDef property) {
        return this.findPropertyEditor(part, element, property, (Set<ISapphirePart>)new IdentityHashSet());
    }

    private PropertyEditorPart findPropertyEditor(ISapphirePart part, Element element, PropertyDef property, Set<ISapphirePart> searchedParts) {
        ISapphirePart parent;
        PropertyEditorPart propertyEditorPart;
        if (searchedParts.contains(part)) {
            return null;
        }
        if (part instanceof PropertyEditorPart && (propertyEditorPart = (PropertyEditorPart)part).getLocalModelElement() == element && propertyEditorPart.property().definition() == property) {
            return propertyEditorPart;
        }
        searchedParts.add(part);
        if (part instanceof FormPart) {
            FormPart partContainerPart = (FormPart)part;
            for (SapphirePart child : partContainerPart.children().all()) {
                PropertyEditorPart propertyEditorPart2 = this.findPropertyEditor((ISapphirePart)child, element, property, searchedParts);
                if (propertyEditorPart2 == null) continue;
                return propertyEditorPart2;
            }
        }
        if ((parent = part.parent()) != null) {
            return this.findPropertyEditor(parent, element, property, searchedParts);
        }
        return null;
    }

    public String getPathUrl() {
        return this.pathUrl;
    }
}

