/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.ui.launcher;

import oracle.eclipse.tools.common.ui.util.SwtUtil;
import oracle.eclipse.tools.jaxrs.launcher.model.IJaxrsModel;
import oracle.eclipse.tools.jaxrs.launcher.model.internal.JaxrsModelResource;
import oracle.eclipse.tools.jaxrs.ui.Activator;
import oracle.eclipse.tools.jaxrs.ui.launcher.LauncherMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaLaunchTab;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyEvent;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.swt.SapphireForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class JaxrsResourceUrlTab
extends JavaLaunchTab {
    public static final String PANEL_SDEF = "jaxrs.url.tab";
    protected static final String EMPTY_STRING = "";
    private IJaxrsModel model;

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)SwtUtil.gdfill());
        composite.setLayout((Layout)SwtUtil.glayout((int)1));
        this.model = (IJaxrsModel)IJaxrsModel.TYPE.instantiate((Resource)new JaxrsModelResource());
        this.model.refresh();
        GridData gd = SwtUtil.gdfill();
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = 640;
        gd.heightHint = 360;
        SapphireForm jaxrsResourcePanel = new SapphireForm(composite, (Element)this.model, DefinitionLoader.context(((Object)((Object)this)).getClass()).sdef("JaxrsResource").form(this.getSdefName()));
        jaxrsResourcePanel.setLayoutData((Object)gd);
        this.setControl((Control)composite);
        FilteredListener<PropertyEvent> listener = new FilteredListener<PropertyEvent>(){

            protected void handleTypedEvent(PropertyEvent event) {
                JaxrsResourceUrlTab.this.updateLaunchConfigurationDialog();
            }
        };
        this.model.property(IJaxrsModel.PROP_HOST_NAME).attach((Listener)listener);
        this.model.property(IJaxrsModel.PROP_METHODS).attach((Listener)listener);
        this.model.property(IJaxrsModel.PROP_PORT).attach((Listener)listener);
        this.model.property(IJaxrsModel.PROP_ENABLE_WADL).attach((Listener)listener);
        this.model.property(IJaxrsModel.PROP_CONTEXT_ROOT).attach((Listener)listener);
        this.model.property(IJaxrsModel.PROP_REQUEST_URL).attach((Listener)listener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IJavaDebugHelpContextIds.LAUNCH_CONFIGURATION_DIALOG_MAIN_TAB);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        String NULL_STRING = null;
        if (config != null) {
            String value = EMPTY_STRING;
            try {
                value = config.getAttribute("oracle.eclipse.tools.jaxrs.HOST_NAME", NULL_STRING);
            }
            catch (CoreException ce) {
                this.setErrorMessage(ce.getStatus().getMessage());
            }
            if (value != null) {
                this.model.setHostname(value);
            }
            try {
                value = config.getAttribute("oracle.eclipse.tools.jaxrs.SERVER_PORT", NULL_STRING);
            }
            catch (CoreException ce) {
                this.setErrorMessage(ce.getStatus().getMessage());
            }
            if (value != null) {
                this.model.setPort(value);
            }
            try {
                value = config.getAttribute("oracle.eclipse.tools.jaxrs.CONTEXT_ROOT", NULL_STRING);
            }
            catch (CoreException ce) {
                this.setErrorMessage(ce.getStatus().getMessage());
            }
            if (value != null) {
                this.model.setContextRoot(value);
            }
            try {
                value = config.getAttribute("oracle.eclipse.tools.jaxrs.WADL_ENABLE", NULL_STRING);
            }
            catch (CoreException ce) {
                this.setErrorMessage(ce.getStatus().getMessage());
            }
            if (value != null) {
                this.model.setEnableWadl(value);
            }
            try {
                value = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, NULL_STRING);
            }
            catch (CoreException ce) {
                this.setErrorMessage(ce.getStatus().getMessage());
            }
            if (value != null) {
                this.model.setProject(value);
            }
            try {
                value = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, NULL_STRING);
            }
            catch (CoreException ce) {
                this.setErrorMessage(ce.getStatus().getMessage());
            }
            if (value != null) {
                this.model.setType(value);
            }
            try {
                value = config.getAttribute("oracle.eclipse.tools.jaxrs.REQUEST_URL", NULL_STRING);
            }
            catch (CoreException ce) {
                this.setErrorMessage(ce.getStatus().getMessage());
            }
            if (value != null) {
                this.model.setRequestUrl(value);
            }
            this.model.refresh();
        }
        super.initializeFrom(config);
    }

    private String getSdefName() {
        return PANEL_SDEF;
    }

    public Image getImage() {
        return Activator.Images.JAX_RS.getImage();
    }

    public String getName() {
        return LauncherMessages.jaxrsResourceUrlTab_Name;
    }

    public String getId() {
        return "oracle.eclipse.tools.jaxrs.ui.jaxrsResourceUrlTab";
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("oracle.eclipse.tools.jaxrs.HOST_NAME", this.model.getHostname().text().trim());
        config.setAttribute("oracle.eclipse.tools.jaxrs.SERVER_PORT", this.model.getPort().text());
        config.setAttribute("oracle.eclipse.tools.jaxrs.CONTEXT_ROOT", this.model.getContextRoot().text());
        config.setAttribute("oracle.eclipse.tools.jaxrs.WADL_ENABLE", this.model.isEnableWadl().text());
        config.setAttribute("oracle.eclipse.tools.jaxrs.REQUEST_URL", this.model.getRequestUrl().text());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        this.updateLaunchConfigurationDialog();
    }
}

