/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.ui.launcher;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.jaxrs.launcher.JaxrsResourceModuleArtifactAdapter;
import oracle.eclipse.tools.jaxrs.ui.Activator;
import oracle.eclipse.tools.jaxrs.ui.launcher.JaxrsResourceSearchEngine;
import oracle.eclipse.tools.jaxrs.ui.launcher.LauncherMessages;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaLaunchShortcut;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Shell;

public class JaxrsApplicationLaunchShortcut
extends JavaLaunchShortcut {
    public static final String ID_JAXRS_CONFIG_TYPE = "oracle.eclipse.tools.jaxrs.application.launchConfigurationType";

    protected void launch(IType type, String mode) {
        List<ILaunchConfiguration> configs = this.getLaunchCandidates(type, this.getConfigurationType());
        if (configs != null) {
            ILaunchConfiguration config = null;
            int count = configs.size();
            if (count == 1) {
                config = configs.get(0);
            } else if (count > 1 && (config = this.chooseConfiguration(configs)) == null) {
                return;
            }
            if (config == null) {
                config = this.createConfiguration(type);
            }
            if (config != null) {
                DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
            }
        }
    }

    protected List<ILaunchConfiguration> getLaunchCandidates(IType type, ILaunchConfigurationType ctype) {
        List<ILaunchConfiguration> candidateConfigs = Collections.emptyList();
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(ctype);
            candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
            int i = 0;
            while (i < configs.length) {
                ILaunchConfiguration config = configs[i];
                if (config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "").equals(type.getFullyQualifiedName()) && config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "").equals(type.getJavaProject().getElementName())) {
                    candidateConfigs.add(config);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.jaxrs.ui", (CoreException)e);
        }
        return candidateConfigs;
    }

    protected ILaunchConfiguration createConfiguration(IType type) {
        ILaunchConfiguration config = null;
        try {
            ILaunchConfigurationType configType = this.getConfigurationType();
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, DebugPlugin.getDefault().getLaunchManager().generateLaunchConfigurationName(type.getElementName()));
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, type.getFullyQualifiedName());
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, type.getJavaProject().getElementName());
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_NAME, "");
            wc.setMappedResources(new IResource[]{type.getUnderlyingResource()});
            config = wc.doSave();
        }
        catch (CoreException ce) {
            MessageDialog.openError((Shell)Activator.getActiveWorkbenchShell(), (String)LauncherMessages.JaxrsLaunchShortcut_3, (String)ce.getStatus().getMessage());
        }
        return config;
    }

    protected ILaunchConfigurationType getConfigurationType() {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        return lm.getLaunchConfigurationType(ID_JAXRS_CONFIG_TYPE);
    }

    protected IType[] findTypes(Object[] elements, IRunnableContext context) throws InterruptedException, CoreException {
        try {
            IJavaElement[] javaElements = this.getJavaElements(elements);
            IJavaProject jProject = null;
            if (javaElements != null) {
                int i = 0;
                while (i < javaElements.length) {
                    jProject = javaElements[i].getJavaProject();
                    ++i;
                }
            } else {
                return new IType[0];
            }
            HashSet<IType> result = new HashSet<IType>(javaElements.length);
            IJavaElement[] iJavaElementArray = javaElements;
            int n = javaElements.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement elem = iJavaElementArray[n2];
                ICompilationUnit unit = null;
                if (!(elem instanceof ICompilationUnit)) break;
                unit = (ICompilationUnit)elem;
                try {
                    IType[] types = unit.getAllTypes();
                    List<IType> typeList = Arrays.asList(types);
                    Iterator<IType> iterator = typeList.iterator();
                    IType type = null;
                    ITypeHierarchy hierarchy = null;
                    IType[] supertypes = null;
                    block6: while (iterator.hasNext()) {
                        type = iterator.next();
                        hierarchy = type.newTypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                        supertypes = hierarchy.getAllInterfaces();
                        int i = 0;
                        while (i < supertypes.length) {
                            if (JaxrsResourceModuleArtifactAdapter.hasJaxrsResourceTypeInterface((IType)supertypes[i])) {
                                result.add(type);
                                continue block6;
                            }
                            ++i;
                        }
                    }
                }
                catch (JavaModelException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.jaxrs.ui", (CoreException)((Object)e));
                }
                ++n2;
            }
            JaxrsResourceSearchEngine engine = new JaxrsResourceSearchEngine();
            int constraints = 1;
            IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])javaElements, (int)(constraints |= 2));
            IType[] resources = engine.searchAnnotatedResource(context, jProject, scope, true);
            if (resources != null) {
                IType[] iTypeArray = resources;
                int n3 = resources.length;
                int n4 = 0;
                while (n4 < n3) {
                    IType type = iTypeArray[n4];
                    if (!Flags.isAbstract((int)type.getFlags()) && !Flags.isInterface((int)type.getFlags())) {
                        result.add(type);
                    }
                    ++n4;
                }
            }
            return result.toArray(new IType[result.size()]);
        }
        catch (InvocationTargetException e) {
            throw (CoreException)e.getTargetException();
        }
    }

    protected IJavaElement[] getJavaElements(Object[] objects) {
        ArrayList<IJavaElement> list = new ArrayList<IJavaElement>(objects.length);
        int i = 0;
        while (i < objects.length) {
            IJavaElement element;
            Object object = objects[i];
            if (object instanceof IAdaptable && (element = (IJavaElement)((IAdaptable)object).getAdapter(IJavaElement.class)) != null) {
                IType type;
                if (element instanceof IMember && (type = ((IMember)element).getDeclaringType()) != null) {
                    element = type;
                }
                list.add(element);
            }
            ++i;
        }
        return list.toArray(new IJavaElement[list.size()]);
    }

    protected String getTypeSelectionTitle() {
        return LauncherMessages.JaxrsApplicationLaunchShortcut_0;
    }

    protected String getEditorEmptyMessage() {
        return LauncherMessages.JaxrsApplicationLaunchShortcut_1;
    }

    protected String getSelectionEmptyMessage() {
        return LauncherMessages.JaxrsApplicationLaunchShortcut_2;
    }
}

