/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.ui.jdt;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import oracle.eclipse.tools.common.util.StatusCollector;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.jaxrs.jdt.ProjectPathUtil;
import oracle.eclipse.tools.jaxrs.ui.jdt.JaxrsKeyClassesValidator;
import oracle.eclipse.tools.jaxrs.ui.jdt.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.UserLibraryClasspathContainer;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPageExtension;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jst.common.project.facet.core.libprov.IPropertyChangeListener;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderOperationConfig;
import org.eclipse.jst.common.project.facet.core.libprov.user.UserLibraryProviderInstallOperationConfig;
import org.eclipse.jst.common.project.facet.ui.libprov.user.UserLibraryProviderInstallPanel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class RuntimeUserLibClasspathContainerPage
extends WizardPage
implements IClasspathContainerPage,
IClasspathContainerPageExtension {
    private IClasspathEntry[] realEntries;
    private TableViewer viewer;
    private Composite rootComposite;
    private Image projectImage;
    private Image libraryImage;
    private Image slibraryImage;
    private IClasspathEntry entry;
    private IJavaProject javaProject;
    private IClasspathEntry[] currentEntries;
    private UserLibraryProviderInstallOperationConfig libConfig;
    private IStatus status = Status.OK_STATUS;
    private boolean isValidating = false;

    public RuntimeUserLibClasspathContainerPage() {
        super("Runtime Classpath Container");
        this.projectImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
        this.libraryImage = JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.jar_l_obj.gif");
        this.slibraryImage = JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.jar_lsrc_obj.gif");
        this.setTitle(Messages.USER_LIB_PAGE_TITLE);
        this.setDescription(Messages.USER_LIB_PAGE_DESCRIPTION);
    }

    public boolean finish() {
        try {
            List libraryNames = this.libConfig.getLibraryNames();
            for (String libraryName : libraryNames) {
                UserLibraryClasspathContainer container = new UserLibraryClasspathContainer(libraryName);
                this.entry = JavaCore.newContainerEntry((IPath)container.getPath(), (boolean)false);
                JavaCore.setClasspathContainer((IPath)this.entry.getPath(), (IJavaProject[])new IJavaProject[]{this.javaProject}, (IClasspathContainer[])new IClasspathContainer[]{container}, null);
            }
        }
        catch (CoreException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.jaxrs.ui", (CoreException)e);
        }
        return true;
    }

    public IClasspathEntry getSelection() {
        return this.entry;
    }

    public void setSelection(IClasspathEntry containerEntry) {
        this.entry = containerEntry;
        this.createRealEntries();
        if (this.viewer != null) {
            this.initializeView();
        }
    }

    private void createRealEntries() {
        this.realEntries = ProjectPathUtil.getRuntimeClasspathEntries((IJavaProject)this.javaProject);
        if (this.realEntries == null) {
            this.realEntries = new IClasspathEntry[0];
        }
    }

    public void createControl(Composite parent) {
        try {
            this.rootComposite = parent;
            UserLibraryProviderInstallPanel installPanel = new UserLibraryProviderInstallPanel();
            LibraryInstallDelegate delegate = this.createLibraryInstallDelegate(this.javaProject.getProject());
            this.libConfig = (UserLibraryProviderInstallOperationConfig)delegate.getLibraryProviderOperationConfig();
            IPropertyChangeListener listener = new IPropertyChangeListener(){

                public void propertyChanged(String property, Object oldValue, Object newValue) {
                    RuntimeUserLibClasspathContainerPage.this.handleLibraryNamesChanged();
                }
            };
            this.libConfig.addListener(listener, new String[]{UserLibraryProviderInstallOperationConfig.PROP_LIBRARY_NAMES});
            installPanel.setOperationConfig((LibraryProviderOperationConfig)this.libConfig);
            Composite container = (Composite)installPanel.createControl(parent);
            this.setControl((Control)container);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void handleLibraryNamesChanged() {
        if (this.rootComposite.getDisplay().getThread() != Thread.currentThread()) {
            this.rootComposite.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    RuntimeUserLibClasspathContainerPage.this.handleLibraryNamesChanged();
                }
            });
            return;
        }
        UserLibraryProviderInstallOperationConfig cfg = this.getOperationConfig();
        JaxrsKeyClassesValidator libraryValidator = new JaxrsKeyClassesValidator();
        libraryValidator.init(ProjectPathUtil.getExpectedJerseyClassList());
        IStatus status = libraryValidator.validate(cfg);
        this.setErrorMessage(null);
        if (status.getSeverity() == 4) {
            this.setErrorMessage(status.getMessage());
        } else if (status.getSeverity() == 1) {
            this.setMessage(status.getMessage(), 1);
        } else {
            this.setErrorMessage(null);
        }
    }

    protected UserLibraryProviderInstallOperationConfig getOperationConfig() {
        return this.libConfig;
    }

    protected LibraryInstallDelegate createLibraryInstallDelegate(IProject project) throws CoreException {
        IFacetedProjectWorkingCopy fprojwc = FacetedProjectFramework.createNewProject();
        IProjectFacet FACET = ProjectFacetsManager.getProjectFacet((String)"jst.jaxrs");
        IProjectFacetVersion fv = FACET.getVersion("1.1");
        return new LibraryInstallDelegate((IFacetedProjectBase)fprojwc, fv);
    }

    private void initializeView() {
        this.viewer.setInput((Object)this.currentEntries);
    }

    public void initialize(IJavaProject project, IClasspathEntry[] currentEntries) {
        this.javaProject = project;
        this.currentEntries = currentEntries;
    }

    protected void setErrorMessage() {
    }

    protected void validatePage(boolean showMessage) {
        if (!this.isValidating) {
            this.isValidating = true;
            try {
                if (showMessage) {
                    this.setErrorMessage();
                }
                this.setPageComplete(this.status.isOK());
            }
            finally {
                this.isValidating = false;
            }
        }
    }

    protected IStatus validate(Iterable<IPath> libraryPaths, Set<String> classNames) {
        HashSet<Object> classFileNames = new HashSet<Object>();
        HashMap<Object, String> classFileNameToClassName = new HashMap<Object, String>();
        for (String className : classNames) {
            String classFileName = String.valueOf(className.replace('.', '/')) + ".class";
            classFileNames.add(classFileName);
            classFileNameToClassName.put(classFileName, className);
        }
        HashMap<String, Integer> classAppearanceCounts = new HashMap<String, Integer>();
        for (String string : classFileNames) {
            classAppearanceCounts.put(string, 0);
        }
        for (IPath iPath : libraryPaths) {
            File file = iPath.toFile();
            if (!file.exists()) continue;
            ZipFile zip = null;
            try {
                try {
                    zip = new ZipFile(file);
                    Enumeration<? extends ZipEntry> itr = zip.entries();
                    while (itr.hasMoreElements()) {
                        ZipEntry zipEntry = itr.nextElement();
                        String name = zipEntry.getName();
                        Integer count = (Integer)classAppearanceCounts.get(name);
                        if (count == null) continue;
                        classAppearanceCounts.put(name, count + 1);
                    }
                }
                catch (IOException iOException) {
                    if (zip == null) continue;
                    try {
                        zip.close();
                    }
                    catch (IOException iOException2) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (zip != null) {
                    try {
                        zip.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (zip == null) continue;
            try {
                zip.close();
            }
            catch (IOException iOException) {}
        }
        StatusCollector statusCollector = new StatusCollector("oracle.eclipse.tools.jaxrs.ui");
        for (Map.Entry entry : classAppearanceCounts.entrySet()) {
            int count = (Integer)entry.getValue();
            if (count != 0) continue;
            String classFileName = (String)entry.getKey();
            String className = (String)classFileNameToClassName.get(classFileName);
            String message = NLS.bind((String)Messages.USER_LIBRARY_VALIDATOR_CLASS_NOT_FOUND, (Object)className);
            statusCollector.add((IStatus)new Status(4, "oracle.eclipse.tools.jaxrs.ui", message));
        }
        return statusCollector.getStatus();
    }

    class EntryContentProvider
    implements IStructuredContentProvider {
        EntryContentProvider() {
        }

        public Object[] getElements(Object parent) {
            if (RuntimeUserLibClasspathContainerPage.this.realEntries != null) {
                return RuntimeUserLibClasspathContainerPage.this.realEntries;
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class EntryLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        EntryLabelProvider() {
        }

        public String getText(Object obj) {
            IClasspathEntry entry = (IClasspathEntry)obj;
            int kind = entry.getEntryKind();
            if (kind == 2) {
                return entry.getPath().segment(0);
            }
            IPath path = entry.getPath();
            String name = path.lastSegment();
            return String.valueOf(name) + " - " + path.uptoSegment(path.segmentCount() - 1).toOSString();
        }

        public Image getImage(Object obj) {
            IClasspathEntry entry = (IClasspathEntry)obj;
            int kind = entry.getEntryKind();
            if (kind == 2) {
                return RuntimeUserLibClasspathContainerPage.this.projectImage;
            }
            if (kind == 1) {
                IPath sourceAtt = entry.getSourceAttachmentPath();
                return sourceAtt != null ? RuntimeUserLibClasspathContainerPage.this.slibraryImage : RuntimeUserLibClasspathContainerPage.this.libraryImage;
            }
            return null;
        }

        public String getColumnText(Object obj, int col) {
            return this.getText(obj);
        }

        public Image getColumnImage(Object obj, int col) {
            return this.getImage(obj);
        }
    }
}

