/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.ui.jdt;

import java.util.ArrayList;
import oracle.eclipse.tools.jaxrs.ui.jdt.Messages;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.dialogs.PreferencesUtil;

class ClasspathQuickFix
implements IMarkerResolution {
    private static final String JAVA_BUILD_PATH = "org.eclipse.jdt.ui.propertyPages.BuildPathsPropertyPage";
    private final Shell shell;
    String label;

    ClasspathQuickFix(Shell shell, String label) {
        this.shell = shell;
        this.label = label;
    }

    public String getLabel() {
        return NLS.bind((String)Messages.CLASSPATH_QUICK_FIX_LABEL, (Object)this.label);
    }

    public void run(IMarker marker) {
        this.showPropertiesOn(marker.getResource().getProject(), (IProgressMonitor)new NullProgressMonitor());
    }

    private void showPropertiesOn(final IProject project, IProgressMonitor monitor) {
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui.propertyPages").getExtensions();
        final ArrayList<String> pageIds = new ArrayList<String>(8);
        pageIds.add(JAVA_BUILD_PATH);
        int i = 0;
        while (i < extensions.length) {
            if (extensions[i].getNamespaceIdentifier().startsWith("org.eclipse.jdt.ui.")) {
                IConfigurationElement[] configurationElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configurationElements.length) {
                    if ("page".equals(configurationElements[j].getName())) {
                        pageIds.add(configurationElements[j].getAttribute("id"));
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (this.shell != null) {
            this.shell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PreferenceDialog dialog = PreferencesUtil.createPropertyDialogOn((Shell)ClasspathQuickFix.this.shell, (IAdaptable)project, (String)ClasspathQuickFix.JAVA_BUILD_PATH, (String[])pageIds.toArray(new String[pageIds.size()]), null);
                    dialog.open();
                }
            });
        }
    }
}

