/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.ui.internal.wizards;

import java.util.HashSet;
import java.util.StringTokenizer;
import oracle.eclipse.tools.jaxrs.ui.Activator;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.Messages;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.RESTServiceClassWizard;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.RESTServiceDataModelProvider;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class WizardUtils {
    static String getUnqualifiedDataTypeStr(String qualifiedDataTypeName) {
        int index = qualifiedDataTypeName.lastIndexOf(46);
        return index != -1 && qualifiedDataTypeName.length() > index + 1 ? qualifiedDataTypeName.substring(index + 1) : qualifiedDataTypeName;
    }

    static IPackageFragmentRoot getPkgFragRoot(IProject project, String srcFolderName) {
        IFolder sourceFolder;
        IJavaProject aJavaProject;
        if (project != null && (aJavaProject = JavaCore.create((IProject)project)) != null && (sourceFolder = project.getFolder(srcFolderName)) != null) {
            return aJavaProject.getPackageFragmentRoot((IResource)sourceFolder);
        }
        return null;
    }

    static String getPkgNameFromPkgDialog(Shell shell, IDataModel model) {
        IPackageFragment fragment;
        String projectName = WizardUtils.getProjectName(model);
        if (projectName == null || projectName.length() == 0) {
            return "";
        }
        String srcFolderName = (String)model.getProperty("RestService.javasrcFolder");
        if (srcFolderName == null) {
            return "";
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project == null) {
            return "";
        }
        IFolder folder = project.getFolder(srcFolderName);
        if (folder == null || !folder.exists()) {
            return "";
        }
        IJavaElement javaElem = WizardUtils.getJavaElement(folder);
        if (!(javaElem instanceof IPackageFragmentRoot)) {
            return "";
        }
        IPackageFragmentRoot packRoot = (IPackageFragmentRoot)javaElem;
        Object[] packages = null;
        try {
            packages = packRoot.getChildren();
        }
        catch (JavaModelException javaModelException) {}
        if (packages == null) {
            packages = new IJavaElement[]{};
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT));
        dialog.setTitle(Messages.RESTServiceClassDetailsPage_packageSelectionTitle);
        dialog.setMessage(Messages.RESTServiceClassDetailsPage_chooseAPackageMsg);
        dialog.setEmptyListMessage(Messages.RESTServiceClassDetailsPage_emptyListMsg);
        dialog.setElements(packages);
        if (dialog.open() == 0 && (fragment = (IPackageFragment)dialog.getFirstResult()) != null) {
            return fragment.getElementName();
        }
        return "";
    }

    static IJavaElement getJavaElement(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof IJavaElement) {
            return (IJavaElement)obj;
        }
        if (obj instanceof IAdaptable) {
            return (IJavaElement)((IAdaptable)obj).getAdapter(IJavaElement.class);
        }
        return (IJavaElement)Platform.getAdapterManager().getAdapter(obj, IJavaElement.class);
    }

    static IStatus validateTypeName(String projectName, String value, String errorMessageKeyMissing, String errorMessageKeyInvalid) {
        if (value == null || value.trim().length() == 0) {
            return Activator.createErrorStatus(errorMessageKeyMissing);
        }
        String className = value;
        int index = value.lastIndexOf(".");
        if (index == -1) {
            return null;
        }
        className = value.substring(index + 1);
        IStatus javaStatus = JavaConventions.validateJavaTypeName((String)className, (String)"1.3", (String)"1.3");
        if (javaStatus.getSeverity() != 4) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (project == null) {
                return Activator.createErrorStatus(String.valueOf(Messages.WizardUtils_invalidProjectMsg) + projectName);
            }
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IType type = null;
            try {
                type = javaProject.findType(value);
            }
            catch (Exception exception) {}
            if (type == null) {
                return Activator.createErrorStatus(errorMessageKeyInvalid);
            }
            return Status.OK_STATUS;
        }
        return javaStatus;
    }

    static IStatus validatePath(String path, boolean checkForEmptyPath) {
        if (checkForEmptyPath && (path == null || path.trim().length() == 0)) {
            return Activator.createErrorStatus(Messages.WizardUtils_pathCannotBeEmpty, null);
        }
        StringTokenizer segments = new StringTokenizer(path, "/");
        HashSet<String> pathParts = new HashSet<String>();
        while (segments.hasMoreTokens()) {
            String segment = segments.nextToken();
            if ((segment = segment.trim()).startsWith("{")) {
                if (segment.length() > 2 && segment.endsWith("}")) {
                    String pathPart = segment.substring(1, segment.length() - 1);
                    int index = pathPart.indexOf(58);
                    if (index == -1) {
                        IStatus javaStatus = JavaConventions.validateIdentifier((String)pathPart, (String)"1.3", (String)"1.3");
                        if (javaStatus.getSeverity() == 4 || javaStatus.getSeverity() == 2) {
                            String msg = javaStatus.getMessage();
                            return Activator.createWarningStatus(msg);
                        }
                    } else {
                        pathPart = pathPart.substring(0, index);
                    }
                    if (pathParts.contains(pathPart)) {
                        return Activator.createWarningStatus(Messages.WizardUtils_invalidPath);
                    }
                    pathParts.add(pathPart);
                    continue;
                }
                return Activator.createWarningStatus(Messages.WizardUtils_invalidPath);
            }
            if (!segment.contains("{") && !segment.contains("}")) continue;
            return Activator.createWarningStatus(Messages.WizardUtils_invalidPath);
        }
        return Status.OK_STATUS;
    }

    static String getUniqueClassName(IDataModel dataModel, RESTServiceClassWizard wizard, String classNameTemplate) {
        RESTServiceDataModelProvider provider = (RESTServiceDataModelProvider)wizard.getDefaultProvider();
        String pkgName = dataModel.getStringProperty("NewJavaClassDataModel.JAVA_PACKAGE");
        boolean dataModelNull = false;
        if (provider.getDataModel() == null) {
            dataModelNull = true;
            provider.setDataModel(dataModel);
        }
        String className = classNameTemplate;
        try {
            int i = 1;
            while (i < 1000) {
                IStatus status = provider.checkIfClassExists(pkgName, className);
                if (status == null || status.isOK()) {
                    String string = className;
                    return string;
                }
                className = String.valueOf(classNameTemplate) + i;
                ++i;
            }
            String string = classNameTemplate;
            return string;
        }
        finally {
            if (dataModelNull) {
                provider.setDataModel(null);
            }
        }
    }

    static String getProjectName(IDataModel model) {
        String projectName = model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
        if (model.getBooleanProperty("RestService.entityType")) {
            projectName = model.getStringProperty("RestService.jpaProject");
        }
        return projectName;
    }
}

