/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.ui.internal.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import oracle.eclipse.tools.common.services.util.JPAUtils;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.INode;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.IRESTServiceConstants;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.Node;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jst.j2ee.internal.common.operations.CreateJavaEEArtifactTemplateModel;
import org.eclipse.jst.j2ee.internal.common.operations.ImportsCollection;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class RESTServiceTemplateModel
extends CreateJavaEEArtifactTemplateModel
implements IRESTServiceConstants {
    public static final String QUALIFIED_URI_INFO = "javax.ws.rs.core.UriInfo";
    public static final String QUALIFIED_RESPONSE = "javax.ws.rs.core.Response";
    private Node.EntityClassNode entityClassNode = null;

    public RESTServiceTemplateModel(IDataModel dataModel) {
        super(dataModel);
    }

    public String getClassName() {
        Node.ClassNode node = this.getClassNode();
        return node != null ? node.getName() : null;
    }

    public Collection<String> getImports() {
        ImportsCollection collection = new ImportsCollection((CreateJavaEEArtifactTemplateModel)this);
        collection.add("javax.ws.rs.Consumes");
        collection.add("javax.ws.rs.GET");
        collection.add("javax.ws.rs.Produces");
        boolean isContainerClass = this.isContainerClass();
        if (this.isContainerResourceType()) {
            if (isContainerClass) {
                collection.add("javax.ws.rs.core.Context");
                collection.add(QUALIFIED_URI_INFO);
            } else {
                collection.add("javax.ws.rs.DELETE");
            }
        }
        if (this.isRootResourceType() || isContainerClass) {
            collection.add("javax.ws.rs.Path");
        }
        boolean isClientPattern = this.isClientContainerPatternType();
        if (isContainerClass) {
            if (!isClientPattern) {
                collection.add("javax.ws.rs.POST");
                collection.add(QUALIFIED_RESPONSE);
            } else {
                collection.remove("javax.ws.rs.Consumes");
            }
            if (this.getParamListForItemConstructor() != null) {
                collection.add("javax.ws.rs.PathParam");
            }
        } else {
            collection.add("javax.ws.rs.PUT");
        }
        if (this.isEntityType()) {
            collection.add("javax.ws.rs.DELETE");
            collection.add("javax.ws.rs.Path");
            collection.add("javax.ws.rs.POST");
            collection.add("javax.ws.rs.PathParam");
            collection.add("javax.ws.rs.PUT");
            collection.add("javax.persistence.EntityManager");
            collection.add("javax.persistence.criteria.CriteriaQuery");
            collection.add("java.util.List");
            collection.add("javax.ejb.Stateless");
            collection.add("javax.persistence.PersistenceContext");
        }
        Node.ClassNode classNode = null;
        classNode = isContainerClass ? this.getContainerClassNode() : this.getClassNode();
        if (classNode != null) {
            List<Node.MethodNode> methodNodes = classNode.getMethodNodes();
            TreeSet<String> javaLangNextPkgStrs = new TreeSet<String>();
            for (Node.MethodNode methodNode : methodNodes) {
                String returnType = methodNode.getReturnType();
                RESTServiceTemplateModel.processReturnOrParamType(returnType, (Collection<String>)collection, javaLangNextPkgStrs);
                for (INode iNode : methodNode.getChildren()) {
                    if (!(iNode instanceof Node.ParamNode)) continue;
                    Node.ParamNode paramNode = (Node.ParamNode)iNode;
                    String dataType = paramNode.getDataType();
                    RESTServiceTemplateModel.processReturnOrParamType(dataType, (Collection<String>)collection, javaLangNextPkgStrs);
                }
            }
            if (javaLangNextPkgStrs.size() > 0) {
                TreeSet<String> fullImports = new TreeSet<String>();
                fullImports.addAll((Collection<String>)collection);
                fullImports.addAll(javaLangNextPkgStrs);
                return fullImports;
            }
        }
        return collection;
    }

    boolean isRootResourceType() {
        return this.dataModel.getBooleanProperty("RestService.rootResourceType");
    }

    boolean isContainerResourceType() {
        return this.dataModel.getBooleanProperty("RestService.resourceSubResourceType");
    }

    boolean isEntityType() {
        return this.dataModel.getBooleanProperty("RestService.entityType");
    }

    String getEntityName() {
        Node.ClassNode classNode;
        if (this.isEntityType() && (classNode = this.getClassNode()) instanceof Node.EntityClassNode) {
            String entityName = ((Node.EntityClassNode)classNode).getEntityName();
            return RESTServiceTemplateModel.getUnqualifiedClassName(entityName);
        }
        return null;
    }

    String getPersistanceUnitName() {
        Node.ClassNode classNode;
        if (this.isEntityType() && (classNode = this.getClassNode()) instanceof Node.EntityClassNode) {
            String entityName = ((Node.EntityClassNode)classNode).getEntityName();
            String jpaProjectName = this.dataModel.getStringProperty("RestService.jpaProject");
            if (jpaProjectName != null && !jpaProjectName.isEmpty()) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(jpaProjectName);
                return JPAUtils.getPersistanceUnitName((IProject)project, (String)entityName);
            }
        }
        return null;
    }

    Node.ClassNode getClassNode() {
        if (this.isRootResourceType()) {
            return this.getRootClassNode();
        }
        if (this.isContainerResourceType()) {
            return this.getItemNode();
        }
        if (this.isEntityType()) {
            return this.entityClassNode;
        }
        return null;
    }

    Node.ClassNode getContainerClassNode() {
        if (this.isContainerResourceType()) {
            return this.getRootClassNode();
        }
        return null;
    }

    String getApplicationClassName() {
        return this.dataModel.getStringProperty("RestService.applicationClass");
    }

    String getApplicationClassPackage() {
        return this.dataModel.getStringProperty("RestService.applicationClassPkg");
    }

    boolean isClientContainerPatternType() {
        if (this.isContainerResourceType()) {
            return this.dataModel.getBooleanProperty("RestService.clientURIType");
        }
        return false;
    }

    boolean shouldGenerateMethodNode(Node.MethodNode methodNode) {
        if (this.isClientContainerPatternType()) {
            return !(methodNode instanceof Node.ContainerOnlyMethodNode);
        }
        return true;
    }

    String[] getParamListForItemConstructor() {
        if (this.isContainerResourceType()) {
            List<Node.MethodNode> methodNodes;
            Node.ClassNode classNode = this.getContainerClassNode();
            Node subResourceMethod = null;
            if (classNode != null && (methodNodes = classNode.getMethodNodes()) != null && methodNodes.size() > 0) {
                for (Node.MethodNode methodNode : methodNodes) {
                    if (!methodNode.isSubResourceMethod()) continue;
                    subResourceMethod = methodNode;
                    break;
                }
            }
            if (subResourceMethod == null) {
                return null;
            }
            List<? extends INode> children = subResourceMethod.getChildren();
            if (children != null) {
                ArrayList<String> paramNames = new ArrayList<String>();
                for (INode iNode : children) {
                    if (!(iNode instanceof Node.ParamNode)) continue;
                    paramNames.add(iNode.getName());
                }
                return paramNames.isEmpty() ? null : paramNames.toArray(new String[0]);
            }
        }
        return null;
    }

    String getCommaSeperatedParamsForItemConstructor() {
        return this.paramsForItemConstructor(null);
    }

    String getCommaSeperatedParamsForItemConstructorWithType() {
        return this.paramsForItemConstructor("String");
    }

    List<? extends INode> getRootNodeChildren() {
        Node.RootNode rootNode = (Node.RootNode)this.dataModel.getProperty("RestService.treeRootObject");
        List emptyList = Collections.emptyList();
        return rootNode != null ? rootNode.getChildren() : emptyList;
    }

    void setIsContainerClass() {
        this.dataModel.setBooleanProperty("RestService.isResourceClass", Boolean.TRUE.booleanValue());
    }

    void setEntityClassNode(Node.EntityClassNode entityClassNode) {
        this.entityClassNode = entityClassNode;
    }

    private String paramsForItemConstructor(String str) {
        String[] paramList = this.getParamListForItemConstructor();
        StringBuffer buffer = new StringBuffer();
        if (paramList != null) {
            int count = paramList.length;
            int i = 0;
            while (i < count) {
                String string = paramList[i];
                if (str != null) {
                    buffer.append(str);
                    buffer.append(" ");
                }
                buffer.append(string);
                if (i < count - 1) {
                    buffer.append(", ");
                }
                ++i;
            }
            return buffer.toString();
        }
        return null;
    }

    private boolean isContainerClass() {
        return this.dataModel.getBooleanProperty("RestService.isResourceClass");
    }

    private Node.ClassNode getRootClassNode() {
        Node.RootNode rootNode = (Node.RootNode)this.dataModel.getProperty("RestService.treeRootObject");
        List<? extends INode> children = rootNode.getChildren();
        if (children != null) {
            for (INode iNode : children) {
                if (!(iNode instanceof Node.ClassNode)) continue;
                return (Node.ClassNode)iNode;
            }
        }
        return null;
    }

    private Node.ClassNode getItemNode() {
        List<? extends INode> children;
        Node.ClassNode containerNode = this.getContainerClassNode();
        if (containerNode != null && (children = containerNode.getChildren()) != null) {
            for (INode iNode : children) {
                Node.ClassNode childClassNode;
                if (!(iNode instanceof Node.ClassNode) || !(childClassNode = (Node.ClassNode)iNode).isSubResource()) continue;
                return childClassNode;
            }
        }
        return null;
    }

    private static void processReturnOrParamType(String type, Collection<String> importsCollection, Collection<String> javaLangNextPkgStrs) {
        int index = type.lastIndexOf(".");
        if (type.indexOf(46) == -1) {
            return;
        }
        String packageName = type.substring(0, index);
        if (packageName.equals("java.lang")) {
            return;
        }
        importsCollection.add(type);
        if (type.startsWith("java.lang.") && !packageName.equals("java.lang")) {
            javaLangNextPkgStrs.add(type);
        }
    }

    private static String getUnqualifiedClassName(String name) {
        if (name != null) {
            int index = name.lastIndexOf(".");
            if (index != -1) {
                return name.substring(index + 1);
            }
            return name;
        }
        return null;
    }
}

