/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.ui.internal.wizards;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import oracle.eclipse.tools.jaxrs.ui.Activator;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.AbstractNodeDetailsComposite;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.ClassNodeDetailsComposite;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.INode;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.IRESTServiceConstants;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.Messages;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.MethodNodeDetailsComposite;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.Node;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.ParamNodeDetailsComposite;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.RESTServiceClassWizard;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.WizardUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;

public class RESTServiceDetailsPage
extends DataModelWizardPage
implements IRESTServiceConstants,
PropertyChangeListener {
    private TreeViewer classTreeViewer;
    private StackLayout stackLayout;
    private ClassNodeDetailsComposite classNodeComposite;
    private MethodNodeDetailsComposite methodNodeDetailsComposite;
    private Composite detailsComposite;
    private ParamNodeDetailsComposite paramNodeDetailsComposite;
    private boolean isPageComplete = false;
    private INode lastSuccessfulNode = null;
    private INode rootResourceInput = null;
    private INode containerResourceInput = null;
    private INode entityInput = null;
    private ClassTreeViewerFilter viewerFilter = null;
    private ISelectionChangedListener treeSelectionListener = null;
    private boolean uiCreated = false;

    RESTServiceDetailsPage(IDataModel dataModel, String pageName) {
        super(dataModel, pageName);
        this.setDescription(Messages.RESTServiceDetailsPage_pageDescription);
        this.setTitle(Messages.RESTServiceDetailsPage_pageTitle);
    }

    protected String[] getValidationPropertyNames() {
        return null;
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite topLevelComp = new Composite(parent, 0);
        this.setControl((Control)topLevelComp);
        GridData data = new GridData(1808);
        topLevelComp.setLayoutData((Object)data);
        FormLayout layout = new FormLayout();
        topLevelComp.setLayout((Layout)layout);
        this.rootResourceInput = null;
        this.containerResourceInput = null;
        this.entityInput = null;
        this.createTreeControl(topLevelComp);
        this.createDetailsComposite(topLevelComp);
        this.setInitialSelection();
        this.uiCreated = true;
        return topLevelComp;
    }

    public boolean isPageComplete() {
        return this.isPageComplete;
    }

    public void dispose() {
        if (this.classNodeComposite != null) {
            this.classNodeComposite.removeRESTValidationEventListener(this);
        }
        if (this.methodNodeDetailsComposite != null) {
            this.methodNodeDetailsComposite.removeRESTValidationEventListener(this);
        }
        if (this.paramNodeDetailsComposite != null) {
            this.paramNodeDetailsComposite.removeRESTValidationEventListener(this);
        }
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        INode node;
        if (evt.getPropertyName().equals("ValidateRestServiceDetailsPage")) {
            this.updateStatus();
        }
        if (evt.getPropertyName().equals("RESTServiceNodeName") && (node = this.getSingleSelection(this.classTreeViewer.getSelection())) != null) {
            this.classTreeViewer.update((Object)node, null);
        }
    }

    protected void validatePage(boolean showMessage) {
        AbstractNodeDetailsComposite nodeDetailsComposite = (AbstractNodeDetailsComposite)this.stackLayout.topControl;
        if (nodeDetailsComposite != null) {
            nodeDetailsComposite.validate();
        }
    }

    void initializeFromFirstPage(RESTServiceClassWizard wizard) {
        if (this.uiCreated) {
            return;
        }
        this.rootResourceInput = null;
        this.containerResourceInput = null;
        this.entityInput = null;
        INode node = this.getInput();
        if (node != null) {
            wizard.getDataModel().setProperty("RestService.treeRootObject", (Object)node);
            this.isPageComplete = true;
        }
    }

    IDataModel getWizardDataModel() {
        return ((RESTServiceClassWizard)this.getWizard()).getDataModel();
    }

    private IStatus getStatus() {
        AbstractNodeDetailsComposite nodeDetailsComposite = (AbstractNodeDetailsComposite)this.stackLayout.topControl;
        IStatus status = null;
        if (nodeDetailsComposite != null) {
            status = nodeDetailsComposite.validate();
        }
        this.isPageComplete = status == null || status.getSeverity() != 4;
        return status;
    }

    private void createTreeControl(Composite topLevelComp) {
        Label titleLabel = new Label(topLevelComp, 16384);
        titleLabel.setText(Messages.RESTServiceDetailsPage_webServicesTitle);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 5);
        formData.top = new FormAttachment(0, 5);
        titleLabel.setLayoutData((Object)formData);
        this.classTreeViewer = new TreeViewer(topLevelComp, 2816);
        formData = new FormData();
        formData.top = new FormAttachment((Control)titleLabel, 5);
        formData.left = new FormAttachment((Control)titleLabel, 0, 16384);
        formData.bottom = new FormAttachment(100, -5);
        formData.right = new FormAttachment(35, -5);
        formData.height = 200;
        this.classTreeViewer.getControl().setLayoutData((Object)formData);
        this.classTreeViewer.setContentProvider((IContentProvider)new RESTServiceClassContentProvider(this.getDataModel()));
        this.classTreeViewer.setLabelProvider((IBaseLabelProvider)new RESTServiceLabelProvider());
        this.viewerFilter = new ClassTreeViewerFilter();
        this.viewerFilter.setShowContainerOnlyMethods(!this.getDataModel().getBooleanProperty("RestService.clientURIType"));
        this.classTreeViewer.addFilter((ViewerFilter)this.viewerFilter);
        INode input = this.getInput();
        this.classTreeViewer.setAutoExpandLevel(2);
        this.classTreeViewer.setInput(input != null ? input : new Object());
        this.addTreeListener();
        this.getDataModel().addListener((IDataModelListener)new ContainerTypeDataModelListener());
    }

    private void createDetailsComposite(Composite topLevelComp) {
        this.detailsComposite = new Composite(topLevelComp, 0);
        FormData formData = new FormData();
        formData.left = new FormAttachment(this.classTreeViewer.getControl(), 5);
        formData.right = new FormAttachment(100, -5);
        formData.top = new FormAttachment(this.classTreeViewer.getControl(), 0, 128);
        formData.bottom = new FormAttachment(100, -5);
        this.detailsComposite.setLayoutData((Object)formData);
        this.stackLayout = new StackLayout();
        this.detailsComposite.setLayout((Layout)this.stackLayout);
        this.classNodeComposite = new ClassNodeDetailsComposite(this, this.detailsComposite);
        this.classNodeComposite.addRESTValidationEventListener(this);
        this.methodNodeDetailsComposite = new MethodNodeDetailsComposite(this, this.detailsComposite);
        this.methodNodeDetailsComposite.addRESTValidationEventListener(this);
        this.paramNodeDetailsComposite = new ParamNodeDetailsComposite(this, this.detailsComposite);
        this.paramNodeDetailsComposite.addRESTValidationEventListener(this);
        this.stackLayout.topControl = this.classNodeComposite;
    }

    private INode getInput() {
        IDataModel dataModel = this.getDataModel();
        if (dataModel.getBooleanProperty("RestService.rootResourceType")) {
            if (this.rootResourceInput == null) {
                try {
                    this.rootResourceInput = this.createNewRootResourceRootInitialInput();
                }
                catch (Node.InvalidChildException e) {
                    Activator.log(e);
                    return null;
                }
            }
            return this.rootResourceInput;
        }
        if (dataModel.getBooleanProperty("RestService.resourceSubResourceType")) {
            if (this.containerResourceInput == null) {
                try {
                    this.containerResourceInput = this.createNewContainerItemInitialInput();
                }
                catch (Node.InvalidChildException e) {
                    Activator.log(e);
                    return null;
                }
            }
            return this.containerResourceInput;
        }
        if (dataModel.getBooleanProperty("RestService.entityType")) {
            if (this.entityInput == null) {
                try {
                    this.entityInput = this.createEntityInput();
                }
                catch (Node.InvalidChildException e) {
                    Activator.log(e);
                    return null;
                }
            }
            return this.entityInput;
        }
        return null;
    }

    private INode createNewRootResourceRootInitialInput() throws Node.InvalidChildException {
        IDataModel dataModel = this.getDataModel();
        String className = dataModel.getStringProperty("NewJavaClassDataModel.CLASS_NAME");
        if (className == null) {
            return null;
        }
        Node.RootNode rootNode = new Node.RootNode("rootResource");
        Node.ClassNode classNode = new Node.ClassNode(className);
        this.getDataModel().addListener((IDataModelListener)new ClassNodeDataModelListener(classNode, "NewJavaClassDataModel.CLASS_NAME"));
        rootNode.addNode(classNode);
        classNode.setPath(className);
        Node.MethodNode getMethodNode = new Node.MethodNode("resourceMethodGET");
        getMethodNode.setHttpMethodType("GET");
        getMethodNode.setReturnType("String");
        getMethodNode.addProduceMimeType("text/plain");
        classNode.addNode(getMethodNode);
        Node.MethodNode putMethodNode = new Node.MethodNode("resourceMethodPUT");
        putMethodNode.setHttpMethodType("PUT");
        putMethodNode.setReturnType("void");
        putMethodNode.addConsumeMimeType("text/plain");
        classNode.addNode(putMethodNode);
        Node.ParamNode putParamNode = new Node.ParamNode("content");
        putMethodNode.addNode(putParamNode);
        putParamNode.setDataType("String");
        return rootNode;
    }

    private INode createNewContainerItemInitialInput() throws Node.InvalidChildException {
        IDataModel dataModel = this.getDataModel();
        String containerClassName = dataModel.getStringProperty("RestService.ResourceClassName");
        if (containerClassName == null) {
            return null;
        }
        String itemClassName = dataModel.getStringProperty("RestService.SubResourceClassName");
        if (itemClassName == null) {
            return null;
        }
        Node.RootNode rootNode = new Node.RootNode("containerItemRoot");
        Node.ClassNode containerClassNode = new Node.ClassNode(containerClassName);
        rootNode.addNode(containerClassNode);
        containerClassNode.setPath("/subresources");
        this.getDataModel().addListener((IDataModelListener)new ClassNodeDataModelListener(containerClassNode, "RestService.ResourceClassName"));
        Node.ClassNode itemClassNode = new Node.ClassNode(itemClassName);
        containerClassNode.addNode(itemClassNode);
        itemClassNode.setIsSubResource(true);
        itemClassNode.setPathEnabled(false);
        itemClassNode.setConsumedMimeTypesEnabled(false);
        itemClassNode.setProducedMimeTypesEnabled(false);
        this.getDataModel().addListener((IDataModelListener)new ClassNodeDataModelListener(itemClassNode, "RestService.SubResourceClassName"));
        Node.MethodNode getMethod = new Node.MethodNode("resourceMethodGET");
        getMethod.setHttpMethodType("GET");
        getMethod.addProduceMimeType("application/xml");
        getMethod.setReturnType("java.lang.String");
        containerClassNode.addNode(getMethod);
        Node.ContainerOnlyMethodNode postMethod = new Node.ContainerOnlyMethodNode("resourceMethodPOST");
        postMethod.setHttpMethodType("POST");
        postMethod.addConsumeMimeType("application/xml");
        postMethod.addProduceMimeType("application/xml");
        postMethod.setReturnType("javax.ws.rs.core.Response");
        postMethod.setDefaultReturnValue("Response.created(context.getAbsolutePath()).build()");
        postMethod.setReturnTypeEnabled(false);
        containerClassNode.addNode(postMethod);
        Node.ParamNode paramNode = new Node.ParamNode("content");
        postMethod.addNode(paramNode);
        paramNode.setDataType("String");
        Node.MethodNode subResourceLocatorMethod = new Node.MethodNode("get" + itemClassName);
        containerClassNode.addNode(subResourceLocatorMethod);
        this.getDataModel().addListener((IDataModelListener)new SubResourceLocatorMethodNodeListener(subResourceLocatorMethod));
        subResourceLocatorMethod.setNameEnabled(false);
        subResourceLocatorMethod.setReturnType(itemClassName);
        subResourceLocatorMethod.setReturnTypeEnabled(false);
        subResourceLocatorMethod.setIsSubResourceMethod(true);
        subResourceLocatorMethod.setPath("{id}");
        subResourceLocatorMethod.setPathEnabled(false);
        subResourceLocatorMethod.setConsumedMimeTypesEnabled(false);
        subResourceLocatorMethod.setProducedMimeTypesEnabled(false);
        paramNode = new Node.ParamNode("id");
        paramNode.setDataType("String");
        paramNode.setPathParamValue("id");
        paramNode.setPathParamValueEnable(false);
        subResourceLocatorMethod.addNode(paramNode);
        Node.MethodNode getMethodNode = new Node.MethodNode("resourceMethodGET");
        getMethodNode.setHttpMethodType("GET");
        getMethodNode.addProduceMimeType("application/xml");
        getMethodNode.setReturnType("String");
        itemClassNode.addNode(getMethodNode);
        Node.MethodNode putMethodNode = new Node.MethodNode("resourceMethodPUT");
        putMethodNode.setHttpMethodType("PUT");
        putMethodNode.addConsumeMimeType("application/xml");
        putMethodNode.setReturnType("void");
        putMethodNode.setReturnTypeEnabled(false);
        itemClassNode.addNode(putMethodNode);
        Node.MethodNode deleteMethodNode = new Node.MethodNode("resourceMethodDELETE");
        deleteMethodNode.setHttpMethodType("DELETE");
        deleteMethodNode.setReturnType("void");
        deleteMethodNode.setReturnTypeEnabled(false);
        itemClassNode.addNode(deleteMethodNode);
        return rootNode;
    }

    private INode createEntityInput() throws Node.InvalidChildException {
        Node.RootNode rootNode = new Node.RootNode("entityRoot");
        IDataModel dataModel = this.getDataModel();
        String entityNames = dataModel.getStringProperty("RestService.entityNames");
        if (entityNames == null || entityNames.length() == 0) {
            return rootNode;
        }
        Set<String> entityNameList = this.getEntityNames(entityNames);
        for (String entityName : entityNameList) {
            rootNode.addNode(RESTServiceDetailsPage.createEntityClassNode(dataModel, (RESTServiceClassWizard)this.getWizard(), entityName));
        }
        return rootNode;
    }

    private static Node.EntityClassNode createEntityClassNode(IDataModel dataModel, RESTServiceClassWizard wizard, String entityName) throws Node.InvalidChildException {
        String primaryKeyTypeName;
        IProject project;
        String unqualifiedEntityName = RESTServiceDetailsPage.getUnqualifiedName(entityName);
        String className = WizardUtils.getUniqueClassName(dataModel, wizard, String.valueOf(unqualifiedEntityName) + "EntityREST");
        String jpaProjectName = dataModel.getStringProperty("RestService.jpaProject");
        JpaProject jpaProject = null;
        if (jpaProjectName != null && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(jpaProjectName)) != null) {
            jpaProject = (JpaProject)project.getAdapter(JpaProject.class);
        }
        String packageName = dataModel.getStringProperty("NewJavaClassDataModel.JAVA_PACKAGE");
        Node.EntityClassNode entityClassNode = new Node.EntityClassNode(className, entityName);
        entityClassNode.setPath(String.valueOf(packageName) + "." + className);
        Node.EntityMethodNode createMethodNode = new Node.EntityMethodNode("create" + unqualifiedEntityName, Node.EntityMethodType.PERSIST);
        entityClassNode.addNode(createMethodNode);
        createMethodNode.setReturnType("void");
        createMethodNode.setReturnTypeEnabled(false);
        createMethodNode.setHttpMethodType("POST");
        createMethodNode.addConsumeMimeType("application/xml");
        createMethodNode.addConsumeMimeType("application/json");
        Node.ParamNode createParamNode = new Node.ParamNode("entity");
        createMethodNode.addNode(createParamNode);
        createParamNode.setDataType(entityName);
        createParamNode.setDataTypeEnabled(false);
        Node.EntityMethodNode editMethodNode = new Node.EntityMethodNode("edit" + unqualifiedEntityName, Node.EntityMethodType.MERGE);
        entityClassNode.addNode(editMethodNode);
        editMethodNode.setReturnType("void");
        editMethodNode.setReturnTypeEnabled(false);
        editMethodNode.setHttpMethodType("PUT");
        editMethodNode.addConsumeMimeType("application/xml");
        editMethodNode.addConsumeMimeType("application/json");
        Node.ParamNode editParamNode = new Node.ParamNode("entity");
        editMethodNode.addNode(editParamNode);
        editParamNode.setDataType(entityName);
        editParamNode.setDataTypeEnabled(false);
        String manyEntitiesStr = "";
        manyEntitiesStr = unqualifiedEntityName.endsWith("y") && unqualifiedEntityName.length() > 1 ? String.valueOf(unqualifiedEntityName.substring(0, unqualifiedEntityName.length() - 1)) + "ies" : String.valueOf(unqualifiedEntityName) + "s";
        Node.EntityMethodNode findAllMethodNode = new Node.EntityMethodNode("findAll" + manyEntitiesStr, Node.EntityMethodType.FINDALL);
        entityClassNode.addNode(findAllMethodNode);
        findAllMethodNode.setReturnType("List<" + unqualifiedEntityName + ">");
        findAllMethodNode.setReturnTypeEnabled(false);
        findAllMethodNode.setHttpMethodType("GET");
        findAllMethodNode.addProduceMimeType("application/xml");
        findAllMethodNode.addProduceMimeType("application/json");
        if (jpaProject != null && (primaryKeyTypeName = wizard.getPrimaryKeyTypeName(jpaProject, entityName)) != null) {
            Node.EntityMethodNode removeMethodNode = new Node.EntityMethodNode("remove" + unqualifiedEntityName, Node.EntityMethodType.REMOVE);
            entityClassNode.addNode(removeMethodNode);
            removeMethodNode.setReturnType("void");
            removeMethodNode.setReturnTypeEnabled(false);
            removeMethodNode.setPath("{id}");
            removeMethodNode.setPathEnabled(false);
            removeMethodNode.setHttpMethodType("DELETE");
            Node.ParamNode removeParamNode = new Node.ParamNode("id");
            removeMethodNode.addNode(removeParamNode);
            removeParamNode.setNameEnabled(false);
            removeParamNode.setDataType(primaryKeyTypeName);
            removeParamNode.setDataTypeEnabled(false);
            removeParamNode.setPathParamValue("id");
            removeParamNode.setPathParamValueEnable(false);
            Node.EntityMethodNode findMethodNode = new Node.EntityMethodNode("find" + unqualifiedEntityName, Node.EntityMethodType.FIND);
            entityClassNode.addNode(findMethodNode);
            findMethodNode.setReturnType("void");
            findMethodNode.setReturnTypeEnabled(false);
            findMethodNode.setPath("{id}");
            findMethodNode.setPathEnabled(false);
            findMethodNode.setHttpMethodType("GET");
            findMethodNode.setReturnType(unqualifiedEntityName);
            findMethodNode.addProduceMimeType("application/xml");
            findMethodNode.addProduceMimeType("application/json");
            Node.ParamNode findParamNode = new Node.ParamNode("id");
            findMethodNode.addNode(removeParamNode);
            findParamNode.setNameEnabled(false);
            findParamNode.setDataType(primaryKeyTypeName);
            findParamNode.setDataTypeEnabled(false);
            findParamNode.setPathParamValue("id");
            findParamNode.setPathParamValueEnable(false);
        }
        return entityClassNode;
    }

    private static String getUnqualifiedName(String name) {
        int index = name.lastIndexOf(46);
        if (index != -1 && name.length() > index + 1) {
            return name.substring(index + 1);
        }
        return name;
    }

    private Set<String> getEntityNames(String entityNames) {
        StringTokenizer tokenizer = new StringTokenizer(entityNames, ", ");
        LinkedHashSet<String> entityNameList = new LinkedHashSet<String>();
        while (tokenizer.hasMoreTokens()) {
            entityNameList.add(tokenizer.nextToken());
        }
        return entityNameList;
    }

    private void setInitialSelection() {
        List<? extends INode> children;
        INode node = null;
        Object input = this.classTreeViewer.getInput();
        if (input instanceof INode && (children = ((INode)input).getChildren()) != null && children.size() > 0) {
            node = children.get(0);
        }
        if (node != null) {
            this.removeTreeListener();
            this.classTreeViewer.setSelection((ISelection)new StructuredSelection(node));
            this.showNodeDetails(node);
            this.addTreeListener();
        }
    }

    private boolean showNodeDetails(INode node) {
        this.stackLayout.topControl = node instanceof Node.ClassNode ? this.classNodeComposite : (node instanceof Node.MethodNode ? this.methodNodeDetailsComposite : (node instanceof Node.ParamNode ? this.paramNodeDetailsComposite : null));
        AbstractNodeDetailsComposite nodeDetailsComposite = (AbstractNodeDetailsComposite)this.stackLayout.topControl;
        if (nodeDetailsComposite != null) {
            nodeDetailsComposite.initializeFromModel(node);
            this.detailsComposite.layout();
            this.updateStatus();
            return true;
        }
        return false;
    }

    private void applyToStatusLine(IStatus status) {
        if (status == null) {
            this.setErrorMessage(null);
            this.setMessage(null);
            return;
        }
        String message = status.getMessage();
        if (status.isMultiStatus()) {
            int severity = status.getSeverity();
            MultiStatus multiStatus = (MultiStatus)status;
            IStatus[] stats = multiStatus.getChildren();
            if (stats != null) {
                IStatus[] iStatusArray = stats;
                int n = stats.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus stat = iStatusArray[n2];
                    if (stat.getSeverity() == severity) {
                        message = stat.getMessage();
                        break;
                    }
                    ++n2;
                }
            }
        }
        if (message.length() == 0) {
            message = null;
        }
        switch (status.getSeverity()) {
            case 0: {
                this.setErrorMessage(null);
                this.setMessage(null);
                break;
            }
            case 2: {
                this.setErrorMessage(null);
                this.setMessage(message, 2);
                break;
            }
            case 1: {
                this.setErrorMessage(null);
                this.setMessage(message, 1);
                break;
            }
            default: {
                this.setErrorMessage(message);
                this.setMessage(null);
            }
        }
    }

    private void updateStatus() {
        this.applyToStatusLine(this.getStatus());
        this.getWizard().getContainer().updateButtons();
    }

    private void addTreeListener() {
        if (this.treeSelectionListener == null) {
            this.treeSelectionListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    final INode selection = RESTServiceDetailsPage.this.getSingleSelection(event.getSelection());
                    if (selection instanceof INode) {
                        BusyIndicator.showWhile((Display)RESTServiceDetailsPage.this.getShell().getDisplay(), (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (!RESTServiceDetailsPage.this.isCurrentPageValid()) {
                                    this.handleError();
                                } else if (!RESTServiceDetailsPage.this.showNodeDetails((INode)selection)) {
                                    this.handleError();
                                } else {
                                    RESTServiceDetailsPage.this.lastSuccessfulNode = (INode)selection;
                                }
                            }
                        });
                    }
                }

                private void handleError() {
                    try {
                        RESTServiceDetailsPage.this.classTreeViewer.removePostSelectionChangedListener((ISelectionChangedListener)this);
                        RESTServiceDetailsPage.this.showNodeChangeAbortDialog();
                        RESTServiceDetailsPage.this.selectSuccessfulNodeAgain();
                    }
                    finally {
                        RESTServiceDetailsPage.this.classTreeViewer.addPostSelectionChangedListener((ISelectionChangedListener)this);
                    }
                }
            };
        }
        this.classTreeViewer.addPostSelectionChangedListener(this.treeSelectionListener);
    }

    private void removeTreeListener() {
        this.classTreeViewer.removePostSelectionChangedListener(this.treeSelectionListener);
    }

    private void showNodeChangeAbortDialog() {
        if (this.getControl().isVisible()) {
            MessageDialog.open((int)1, (Shell)this.getShell(), (String)Messages.RESTServiceDetailsPage_cannotChangeSelectionTitle, (String)Messages.RESTServiceDetailsPage_pageHasInvalidValuesMsg, (int)0x10000000);
        }
    }

    private void selectSuccessfulNodeAgain() {
        if (this.lastSuccessfulNode == null) {
            return;
        }
        this.classTreeViewer.setSelection((ISelection)new StructuredSelection((Object)this.lastSuccessfulNode));
        this.showNodeDetails(this.lastSuccessfulNode);
    }

    private INode getSingleSelection(ISelection selection) {
        IStructuredSelection structured;
        if (!selection.isEmpty() && (structured = (IStructuredSelection)selection).getFirstElement() instanceof INode) {
            return (INode)structured.getFirstElement();
        }
        return null;
    }

    private boolean isCurrentPageValid() {
        return this.getErrorMessage() == null;
    }

    private class ClassNodeDataModelListener
    implements IDataModelListener {
        private Node.ClassNode classNode;
        private String dataModelPropertyName;

        ClassNodeDataModelListener(Node.ClassNode classNode, String dataModelPropertyName) {
            this.classNode = classNode;
            this.dataModelPropertyName = dataModelPropertyName;
        }

        public void propertyChanged(DataModelEvent event) {
            String propName = event.getPropertyName();
            if (propName != null && propName.equals(this.dataModelPropertyName)) {
                String className = event.getDataModel().getStringProperty(propName);
                this.classNode.setName(className);
                if (RESTServiceDetailsPage.this.classTreeViewer != null) {
                    RESTServiceDetailsPage.this.classTreeViewer.update((Object)this.classNode, null);
                    RESTServiceDetailsPage.this.classNodeComposite.initializeFromModel(this.classNode);
                    RESTServiceDetailsPage.this.updateStatus();
                }
            }
        }
    }

    private static class ClassTreeViewerFilter
    extends ViewerFilter {
        private boolean showContainerOnlyMethods = true;

        private ClassTreeViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof Node.ContainerOnlyMethodNode) {
                return this.showContainerOnlyMethods;
            }
            return true;
        }

        public boolean getShowContainerOnlyMethods() {
            return this.showContainerOnlyMethods;
        }

        public void setShowContainerOnlyMethods(boolean show) {
            this.showContainerOnlyMethods = show;
        }
    }

    private class ContainerTypeDataModelListener
    implements IDataModelListener {
        private ContainerTypeDataModelListener() {
        }

        public void propertyChanged(DataModelEvent event) {
            String propName = event.getPropertyName();
            if (propName.equals("RestService.treeRootObject")) {
                return;
            }
            INode input = null;
            Object oldInput = RESTServiceDetailsPage.this.classTreeViewer.getInput();
            boolean refreshViewer = false;
            boolean resetPatternData = true;
            if (propName.equals("NewJavaClassDataModel.CLASS_NAME")) {
                boolean isRootResouceType = RESTServiceDetailsPage.this.getDataModel().getBooleanProperty("RestService.rootResourceType");
                if (isRootResouceType) {
                    Node.RootNode rootNode;
                    List<? extends INode> children;
                    input = RESTServiceDetailsPage.this.getInput();
                    if (RESTServiceDetailsPage.this.rootResourceInput instanceof Node.RootNode && (children = (rootNode = (Node.RootNode)RESTServiceDetailsPage.this.rootResourceInput).getChildren()) != null && children.size() > 0 && children.get(0) instanceof Node.ClassNode) {
                        ((Node.ClassNode)children.get(0)).setPath(RESTServiceDetailsPage.this.getDataModel().getStringProperty(propName));
                    }
                }
            } else if (propName.equals("RestService.resourceURIType") || propName.equals("RestService.rootResourceType") || propName.equals("RestService.clientURIType") || propName.equals("RestService.resourceSubResourceType")) {
                if (RESTServiceDetailsPage.this.getDataModel().getBooleanProperty("RestService.rootResourceType")) {
                    if (resetPatternData) {
                        RESTServiceDetailsPage.this.rootResourceInput = null;
                        input = RESTServiceDetailsPage.this.getInput();
                    } else {
                        input = RESTServiceDetailsPage.this.rootResourceInput == null ? RESTServiceDetailsPage.this.getInput() : RESTServiceDetailsPage.this.rootResourceInput;
                    }
                } else if (RESTServiceDetailsPage.this.getDataModel().getBooleanProperty("RestService.resourceSubResourceType")) {
                    if (resetPatternData) {
                        RESTServiceDetailsPage.this.containerResourceInput = null;
                        input = RESTServiceDetailsPage.this.getInput();
                    } else {
                        input = RESTServiceDetailsPage.this.containerResourceInput == null ? RESTServiceDetailsPage.this.getInput() : RESTServiceDetailsPage.this.containerResourceInput;
                    }
                    boolean showContainerOnlyMethods = RESTServiceDetailsPage.this.viewerFilter.getShowContainerOnlyMethods();
                    if (RESTServiceDetailsPage.this.getDataModel().getBooleanProperty("RestService.resourceURIType")) {
                        if (!showContainerOnlyMethods) {
                            refreshViewer = true;
                            RESTServiceDetailsPage.this.viewerFilter.setShowContainerOnlyMethods(true);
                        }
                    } else if (showContainerOnlyMethods && RESTServiceDetailsPage.this.getDataModel().getBooleanProperty("RestService.clientURIType")) {
                        refreshViewer = true;
                        RESTServiceDetailsPage.this.viewerFilter.setShowContainerOnlyMethods(false);
                    }
                }
            } else if (propName.equals("RestService.entityType")) {
                if (resetPatternData) {
                    RESTServiceDetailsPage.this.entityInput = null;
                }
                input = RESTServiceDetailsPage.this.getInput();
            } else if (propName.equals("RestService.entityNames")) {
                if (RESTServiceDetailsPage.this.entityInput == null) {
                    input = RESTServiceDetailsPage.this.getInput();
                } else {
                    input = RESTServiceDetailsPage.this.entityInput;
                    if (input instanceof Node.RootNode) {
                        Node.RootNode rootNode = (Node.RootNode)input;
                        Set entityNames = RESTServiceDetailsPage.this.getEntityNames(RESTServiceDetailsPage.this.getDataModel().getStringProperty("RestService.entityNames"));
                        List<? extends INode> children = rootNode.getChildren();
                        HashMap<String, Node.EntityClassNode> entityNodes = new HashMap<String, Node.EntityClassNode>();
                        boolean refreshRoot = false;
                        if (children != null) {
                            for (INode iNode : children) {
                                if (!(iNode instanceof Node.EntityClassNode)) continue;
                                Node.EntityClassNode entityClassNode = (Node.EntityClassNode)iNode;
                                String entityName = entityClassNode.getEntityName();
                                if (entityNames.contains(entityName)) {
                                    entityNodes.put(entityName, entityClassNode);
                                    continue;
                                }
                                refreshRoot = true;
                            }
                        }
                        ArrayList<Node.EntityClassNode> arrayList = new ArrayList<Node.EntityClassNode>();
                        for (String entityName : entityNames) {
                            Node.EntityClassNode classNode = (Node.EntityClassNode)entityNodes.get(entityName);
                            if (classNode == null) {
                                try {
                                    arrayList.add(RESTServiceDetailsPage.createEntityClassNode(RESTServiceDetailsPage.this.getDataModel(), (RESTServiceClassWizard)RESTServiceDetailsPage.this.getWizard(), entityName));
                                    refreshRoot = true;
                                }
                                catch (Node.InvalidChildException e) {
                                    Activator.log(e);
                                }
                                continue;
                            }
                            arrayList.add(classNode);
                        }
                        if (refreshRoot) {
                            rootNode.removeAllChildren();
                            rootNode = new Node.RootNode("entityRoot");
                            RESTServiceDetailsPage.this.entityInput = rootNode;
                            for (Node.EntityClassNode classNode : arrayList) {
                                try {
                                    rootNode.addNode(classNode);
                                }
                                catch (Node.InvalidChildException e) {
                                    Activator.log(e);
                                }
                            }
                            input = rootNode;
                        }
                    }
                }
            }
            if (input != null) {
                if (oldInput != input) {
                    RESTServiceDetailsPage.this.classTreeViewer.setInput((Object)input);
                    ISelection selection = RESTServiceDetailsPage.this.classTreeViewer.getSelection();
                    if (selection == null || selection.isEmpty()) {
                        RESTServiceDetailsPage.this.setInitialSelection();
                    }
                } else if (refreshViewer) {
                    RESTServiceDetailsPage.this.classTreeViewer.refresh();
                }
            }
        }
    }

    private static class RESTServiceClassContentProvider
    implements ITreeContentProvider {
        private IDataModel dataModel;

        RESTServiceClassContentProvider(IDataModel dataModel) {
            this.dataModel = dataModel;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.dataModel.setProperty("RestService.treeRootObject", newInput);
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof INode) {
                List<? extends INode> children = ((INode)parentElement).getChildren();
                return children != null ? children.toArray() : null;
            }
            return null;
        }

        public Object getParent(Object element) {
            return element instanceof INode ? ((INode)element).getParent() : null;
        }

        public boolean hasChildren(Object element) {
            Object[] children = this.getChildren(element);
            return children != null && children.length > 0;
        }
    }

    private static class RESTServiceLabelProvider
    implements ILabelProvider {
        private RESTServiceLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            if (element instanceof INode) {
                return ((INode)element).getImage();
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof INode) {
                return ((INode)element).getName();
            }
            return "";
        }
    }

    private class SubResourceLocatorMethodNodeListener
    implements IDataModelListener {
        private Node.MethodNode methodNode;

        SubResourceLocatorMethodNodeListener(Node.MethodNode methodNode) {
            this.methodNode = methodNode;
        }

        public void propertyChanged(DataModelEvent event) {
            String propName = event.getPropertyName();
            if (propName != null && propName.equals("RestService.SubResourceClassName")) {
                String className = event.getDataModel().getStringProperty(propName);
                this.methodNode.setName("get" + className);
                this.methodNode.setReturnType(className);
                if (RESTServiceDetailsPage.this.classTreeViewer != null) {
                    RESTServiceDetailsPage.this.classTreeViewer.update((Object)this.methodNode, null);
                    INode selectedNode = RESTServiceDetailsPage.this.getSingleSelection(RESTServiceDetailsPage.this.classTreeViewer.getSelection());
                    if (selectedNode == this.methodNode) {
                        RESTServiceDetailsPage.this.classTreeViewer.setSelection((ISelection)new StructuredSelection((Object)this.methodNode));
                    }
                }
            }
        }
    }
}

