/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.ui.internal.wizards;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.util.ast.EditUtil;
import oracle.eclipse.tools.common.util.ast.IBodyDeclarationInserter;
import oracle.eclipse.tools.common.util.ast.ReaderUtil;
import oracle.eclipse.tools.common.util.ast.WriterContext;
import oracle.eclipse.tools.common.util.ast.WriterUtil;
import oracle.eclipse.tools.common.util.jdt.ClassUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.jaxrs.ui.Activator;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.ApplicationClassTemplate;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.ContainerClassTemplate;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.EntityFacadeRESTTemplate;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.INode;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.Messages;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.Node;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.RESTServiceTemplateModel;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.RestResourceTemplate;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.WizardUtils;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class RESTServiceClassOperation
extends AbstractDataModelOperation {
    public RESTServiceClassOperation(IDataModel dataModel) {
        super(dataModel);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        String fqnClass;
        ICompilationUnit icu;
        this.createJavaSourceContainer();
        String packageName = this.model.getStringProperty("NewJavaClassDataModel.JAVA_PACKAGE");
        IPackageFragment pkg = this.createJavaPackage(packageName);
        String appClassPackageName = this.model.getStringProperty("RestService.applicationClassPkg");
        String appClassName = this.model.getStringProperty("RestService.applicationClassPkg");
        IPackageFragment appClassPkgFragment = this.createJavaPackage(appClassPackageName);
        boolean createAppClass = false;
        if (!(appClassName == null || appClassPackageName == null || (icu = appClassPkgFragment.getCompilationUnit(fqnClass = String.valueOf(appClassPackageName) + "." + appClassName + ".java")) != null && icu.exists())) {
            createAppClass = true;
        }
        try {
            this.generate(monitor, pkg, appClassPkgFragment, createAppClass);
        }
        catch (Exception e) {
            Activator.log(e);
            return Activator.createErrorStatus("", e);
        }
        return OK_STATUS;
    }

    private void generate(IProgressMonitor progressMonitor, IPackageFragment pkg, IPackageFragment appClassPkgFragment, boolean genAppClass) throws JavaModelException, Exception {
        RESTServiceTemplateModel templateModel = new RESTServiceTemplateModel(this.getDataModel());
        this.model.setProperty("RestService.entityFileNames", null);
        String[] restClassNames = null;
        if (pkg != null) {
            if (templateModel.isEntityType()) {
                List<? extends INode> children = templateModel.getRootNodeChildren();
                if (children != null) {
                    restClassNames = new String[children.size()];
                    ArrayList<IFile> entityFacadeFiles = new ArrayList<IFile>();
                    int i = 0;
                    int len = children.size();
                    while (i < len) {
                        INode child = children.get(i);
                        if (!(child instanceof Node.EntityClassNode)) continue;
                        Node.EntityClassNode entityClassNode = (Node.EntityClassNode)child;
                        templateModel.setEntityClassNode(entityClassNode);
                        restClassNames[i] = String.valueOf(pkg.getElementName()) + "." + templateModel.getClassName();
                        IFile file = this.generate(progressMonitor, pkg, EntityFacadeRESTTemplate.create(null), templateModel, templateModel.getClassName());
                        if (file != null) {
                            entityFacadeFiles.add(file);
                        }
                        ++i;
                    }
                    if (entityFacadeFiles.size() > 0) {
                        this.model.setProperty("RestService.entityFileNames", entityFacadeFiles);
                    }
                }
            } else {
                restClassNames = templateModel.isContainerResourceType() ? new String[2] : new String[1];
                restClassNames[0] = String.valueOf(pkg.getElementName()) + "." + templateModel.getClassName();
                this.generate(progressMonitor, pkg, RestResourceTemplate.create(null), templateModel, templateModel.getClassName());
                if (templateModel.isContainerResourceType()) {
                    restClassNames[1] = String.valueOf(pkg.getElementName()) + "." + templateModel.getContainerClassNode().getName();
                    templateModel.setIsContainerClass();
                    this.generate(progressMonitor, pkg, ContainerClassTemplate.create(null), templateModel, templateModel.getContainerClassNode().getName());
                }
            }
        }
        if (genAppClass && appClassPkgFragment != null && restClassNames != null) {
            this.generate(progressMonitor, appClassPkgFragment, ApplicationClassTemplate.create(null), templateModel, templateModel.getApplicationClassName());
            IStatus status = this.updateAppClass(templateModel, appClassPkgFragment, restClassNames);
            if (status.getSeverity() != 0) {
                Activator.getDefault().getLog().log(status);
            }
        }
    }

    private IFile generate(IProgressMonitor monitor, IPackageFragment fragment, Object templateImpl, RESTServiceTemplateModel templateModel, String className) throws Exception {
        try {
            Method method = templateImpl.getClass().getMethod("generate", Object.class);
            String javaSource = (String)method.invoke(templateImpl, templateModel);
            String javaFileName = String.valueOf(className) + ".java";
            return this.createJavaFile(monitor, fragment, javaSource, javaFileName);
        }
        catch (Exception e) {
            Activator.log(e);
            throw e;
        }
    }

    private void createJavaSourceContainer() {
        String containerPath = this.model.getStringProperty("RestService.javasrcFolder");
        String projectName = WizardUtils.getProjectName(this.model);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFolder container = root.getFolder((IPath)new Path(String.valueOf(projectName) + "/" + containerPath));
        if (!container.exists()) {
            try {
                container.create(true, true, null);
            }
            catch (CoreException e) {
                Activator.log(e);
            }
        }
    }

    private IPackageFragment createJavaPackage(String packageName) {
        String projectName = WizardUtils.getProjectName(this.model);
        IProject project = null;
        if (projectName != null && projectName.length() > 0) {
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        if (project == null) {
            return null;
        }
        String srcFolderName = (String)this.model.getProperty("RestService.javasrcFolder");
        IPackageFragmentRoot packRoot = WizardUtils.getPkgFragRoot(project, srcFolderName);
        IPackageFragment pkg = packRoot.getPackageFragment(packageName);
        if (pkg == null) {
            pkg = packRoot.getPackageFragment("");
        }
        if (!pkg.exists()) {
            String packName = pkg.getElementName();
            try {
                pkg = packRoot.createPackageFragment(packName, true, null);
            }
            catch (JavaModelException e) {
                Activator.log(e);
            }
        }
        return pkg;
    }

    private IFile createJavaFile(IProgressMonitor monitor, IPackageFragment fragment, String source, String className) throws JavaModelException {
        if (fragment != null) {
            ICompilationUnit icu = fragment.getCompilationUnit(className);
            if (icu == null || !icu.exists()) {
                icu = fragment.createCompilationUnit(className, source, true, monitor);
            }
            return (IFile)icu.getResource();
        }
        return null;
    }

    private IStatus updateAppClass(RESTServiceTemplateModel templateModel, IPackageFragment appClasspackageFragment, String ... restServClassNames) {
        String appClassName = templateModel.getApplicationClassName();
        if (appClasspackageFragment != null) {
            String fullClassName = String.valueOf(appClasspackageFragment.getElementName()) + "." + appClassName;
            ICompilationUnit icu = appClasspackageFragment.getCompilationUnit(String.valueOf(appClassName) + ".java");
            if (icu == null) {
                return Activator.createErrorStatus(String.valueOf(Messages.RESTServiceClassOperation_cannotGetCompilationUnit) + appClasspackageFragment.getElementName() + "." + appClassName);
            }
            WriterContext context = null;
            try {
                int n;
                int n2;
                Object[] objectArray;
                context = EditUtil.startEdit((ICompilationUnit)icu);
                TypeDeclaration typeDeclaration = ReaderUtil.getPrimaryType((CompilationUnit)context.getCompilationUnit());
                if (typeDeclaration == null) {
                    return Activator.createErrorStatus(String.valueOf(Messages.RESTServiceClassOperation_cannotFindTypedecl) + appClasspackageFragment.getElementName() + "." + appClassName);
                }
                String name = ClassUtil.getClassName((String)fullClassName);
                if (!typeDeclaration.getName().getIdentifier().equals(name)) {
                    typeDeclaration = ReaderUtil.findInnerType((TypeDeclaration)typeDeclaration, (String)name);
                }
                MethodDeclaration[] methodDecls = typeDeclaration.getMethods();
                MethodDeclaration restResourceClassesMethodDecl = null;
                if (methodDecls != null) {
                    objectArray = methodDecls;
                    n2 = methodDecls.length;
                    n = 0;
                    while (n < n2) {
                        List params;
                        MethodDeclaration methodDecl = objectArray[n];
                        if (methodDecl.getName().getFullyQualifiedName().equals("getRestClasses") && ((params = methodDecl.parameters()) == null || params.size() == 0)) {
                            restResourceClassesMethodDecl = methodDecl;
                            break;
                        }
                        ++n;
                    }
                }
                if (restResourceClassesMethodDecl == null) {
                    return Activator.createErrorStatus(String.valueOf(Messages.RESTServiceClassOperation_cannotFindMethodDecl) + appClasspackageFragment.getElementName() + "." + appClassName);
                }
                objectArray = restServClassNames;
                n2 = restServClassNames.length;
                n = 0;
                while (n < n2) {
                    MethodDeclaration restServiceClass = objectArray[n];
                    if (restServiceClass != null) {
                        String methodCallStr = RESTServiceClassOperation.getMethodCallString((String)restServiceClass);
                        RESTServiceClassOperation.insertDeclaration(restResourceClassesMethodDecl, methodCallStr, 32, (IBodyDeclarationInserter)new MethodInvocationNodeInserter(), context);
                    }
                    ++n;
                }
                final WriterContext context1 = context;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            EditUtil.endEdit((WriterContext)context1);
                        }
                        catch (Exception e) {
                            Activator.log(e);
                            RESTServiceClassOperation.this.disposeWorkingCopy(context1);
                        }
                    }
                });
            }
            catch (Exception e) {
                this.disposeWorkingCopy(context);
                return Activator.createErrorStatus("", e);
            }
        }
        return Status.OK_STATUS;
    }

    private void disposeWorkingCopy(WriterContext context) {
        if (context != null && context.shouldCommit()) {
            try {
                context.getICompilationUnit().discardWorkingCopy();
            }
            catch (JavaModelException e) {
                LoggingService.logException((Plugin)Activator.getDefault(), (CoreException)((Object)e));
            }
        }
    }

    private static String getMethodCallString(String fullClassName) {
        StringBuffer sb = new StringBuffer();
        sb.append("resources.add(").append(fullClassName).append(".class);");
        return sb.toString();
    }

    private static ITrackedNodePosition insertDeclaration(MethodDeclaration methodDecl, String decl, int declType, IBodyDeclarationInserter inserter, WriterContext writerContext) throws BadLocationException, CoreException {
        String str = WriterUtil.formatBodyDeclaration((String)decl, (WriterContext)writerContext);
        ASTRewrite rewrite = writerContext.getASTRewrite();
        ASTNode node = rewrite.createStringPlaceholder(str, declType);
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)methodDecl.getBody(), Block.STATEMENTS_PROPERTY);
        ITrackedNodePosition position = rewrite.track(node);
        inserter.insert(listRewrite, node);
        return position;
    }

    private static class MethodInvocationNodeInserter
    extends IBodyDeclarationInserter.AbstractASTNodeInserter {
        private MethodInvocationNodeInserter() {
        }

        public void insert(ListRewrite rewrite, ASTNode node) {
            List list = rewrite.getRewrittenList();
            ASTNode refNode = this.findLastNode(list, 41);
            if (refNode != null) {
                rewrite.insertBefore(node, refNode, null);
            } else {
                rewrite.insertLast(node, null);
            }
        }
    }
}

