/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.ui.internal.wizards;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.Messages;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.Node;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

class MimeTypeComposite
extends Composite {
    private static Map<String, String> mimeTypesMap = null;
    private Button[] buttons = null;
    private Node.MimeTypePathNode mimeTypePathNode = null;
    static final String MIME_APP_ATOM_XML = "application/atom+xml";
    static final String MIME_TEXT_HTML = "text/html";
    static final String MIME_APP_X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
    static final String MIME_IMAGE_JPEG = "image/jpeg";
    static final String MIME_APP_JSON = "application/json";
    static final String MIME_IMAGE_GIF = "image/gif";
    static final String MIME_APP_OCTET_STREAM = "application/octet-stream";
    static final String MIME_TEXT_PLAIN = "text/plain";
    static final String MIME_APP_SVG_XML = "application/svg+xml";
    static final String MIME_TEXT_XML = "text/xml";
    static final String MIME_APP_XHTML_XML = "application/xhtml+xml";
    static final String MIME_STAR_STAR = "*/*";
    static final String MIME_APP_XML = "application/xml";
    static final String MIME_STAR = "*";
    static final String MIME_MULTIPART_FORM_DATA = "multipart/form-data";
    private SelectionListener buttonSelectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            Object o = e.getSource();
            if (!(o instanceof Button)) {
                return;
            }
            if (MimeTypeComposite.this.mimeTypePathNode == null) {
                return;
            }
            Button button = (Button)o;
            boolean selected = button.getSelection();
            Object data = button.getData();
            if (data instanceof String) {
                String mimeTypeName = (String)mimeTypesMap.get(data);
                if (selected) {
                    MimeTypeComposite.this.mimeTypePathNode.addConsumeMimeType(mimeTypeName);
                } else {
                    MimeTypeComposite.this.mimeTypePathNode.removeConsumeMimeType(mimeTypeName);
                }
            } else {
                boolean isConsume;
                String text = button.getText();
                String mimeType = (String)mimeTypesMap.get(text);
                boolean bl = isConsume = MimeTypeComposite.this.mimeTypePathNode instanceof Node.MethodNode && ((Node.MethodNode)MimeTypeComposite.this.mimeTypePathNode).getHttpMethodType().equals("DELETE");
                if (selected) {
                    if (isConsume) {
                        MimeTypeComposite.this.mimeTypePathNode.addConsumeMimeType(mimeType);
                    } else {
                        MimeTypeComposite.this.mimeTypePathNode.addProduceMimeType(mimeType);
                    }
                } else if (isConsume) {
                    MimeTypeComposite.this.mimeTypePathNode.removeConsumeMimeType(mimeType);
                } else {
                    MimeTypeComposite.this.mimeTypePathNode.removeProduceMimeType(mimeType);
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    };

    MimeTypeComposite(Composite parent, boolean consumeAndProduce) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout(4, false));
        MimeTypeComposite.initMap();
        this.buttons = new Button[mimeTypesMap.size() * 2];
        int i = 0;
        for (String buttonName : mimeTypesMap.keySet()) {
            this.buttons[i] = new Button((Composite)this, 32);
            this.buttons[i].setData((Object)buttonName);
            if (!consumeAndProduce) {
                GridData gridData = new GridData();
                gridData.widthHint = 0;
                gridData.heightHint = 0;
                this.buttons[i].setLayoutData((Object)gridData);
            }
            this.buttons[++i] = new Button((Composite)this, 32);
            this.buttons[i].setText(buttonName);
            ++i;
        }
    }

    void addListeners() {
        Button[] buttonArray = this.buttons;
        int n = this.buttons.length;
        int n2 = 0;
        while (n2 < n) {
            Button button = buttonArray[n2];
            button.addSelectionListener(this.buttonSelectionListener);
            ++n2;
        }
    }

    void removeListeners() {
        Button[] buttonArray = this.buttons;
        int n = this.buttons.length;
        int n2 = 0;
        while (n2 < n) {
            Button button = buttonArray[n2];
            button.removeSelectionListener(this.buttonSelectionListener);
            ++n2;
        }
    }

    void initializeFromModel(Node.MimeTypePathNode mimeTypeNode) {
        String mimeType;
        int i;
        this.mimeTypePathNode = mimeTypeNode;
        Set<String> firstColMimeTypes = null;
        Set<String> secondColMimeTypes = null;
        Button[] buttonArray = this.buttons;
        int n = this.buttons.length;
        int n2 = 0;
        while (n2 < n) {
            Button button = buttonArray[n2];
            button.setSelection(false);
            ++n2;
        }
        if (mimeTypeNode instanceof Node.ClassNode) {
            firstColMimeTypes = mimeTypeNode.getConsumedMimeTypes();
            secondColMimeTypes = mimeTypeNode.getProducedMimeTypes();
        } else if (mimeTypeNode instanceof Node.MethodNode) {
            Node.MethodNode methodNode = (Node.MethodNode)mimeTypeNode;
            String mimeType2 = methodNode.getHttpMethodType();
            if (mimeType2.equals("GET") || mimeType2.equals("DELETE")) {
                this.hideFirstColCheckBoxes(true);
                secondColMimeTypes = mimeType2.equals("GET") ? methodNode.getProducedMimeTypes() : methodNode.getConsumedMimeTypes();
            } else {
                this.hideFirstColCheckBoxes(false);
                firstColMimeTypes = mimeTypeNode.getConsumedMimeTypes();
                secondColMimeTypes = mimeTypeNode.getProducedMimeTypes();
            }
        }
        if (firstColMimeTypes != null) {
            block1: for (String buttonName : firstColMimeTypes) {
                i = 0;
                while (i < this.buttons.length) {
                    String data = (String)this.buttons[i].getData();
                    if (data != null && (mimeType = mimeTypesMap.get(data)) != null && buttonName.equals(mimeType)) {
                        this.buttons[i].setSelection(true);
                        continue block1;
                    }
                    i += 2;
                }
            }
        }
        if (secondColMimeTypes != null) {
            block3: for (String buttonName : secondColMimeTypes) {
                i = 1;
                while (i < this.buttons.length) {
                    String name = this.buttons[i].getText();
                    mimeType = mimeTypesMap.get(name);
                    if (buttonName.equals(mimeType)) {
                        this.buttons[i].setSelection(true);
                        continue block3;
                    }
                    i += 2;
                }
            }
        }
        boolean b = this.mimeTypePathNode.isConsumedMimeTypesEnabled();
        int i2 = 0;
        int len = this.buttons.length;
        while (i2 < len) {
            this.buttons[i2].setEnabled(b);
            i2 += 2;
        }
        b = this.mimeTypePathNode.isProducedMimeTypesEnabled();
        i2 = 1;
        len = this.buttons.length;
        while (i2 < len) {
            this.buttons[i2].setEnabled(b);
            i2 += 2;
        }
    }

    void hideFirstColCheckBoxes(boolean hide) {
        int i = 0;
        int len = this.buttons.length;
        while (i < len) {
            GridData gridData = new GridData();
            if (hide) {
                gridData.widthHint = 0;
                gridData.heightHint = 0;
                this.buttons[i].setLayoutData((Object)gridData);
            } else {
                this.buttons[i].setLayoutData((Object)gridData);
            }
            i += 2;
        }
        this.layout();
    }

    private static void initMap() {
        if (mimeTypesMap == null) {
            mimeTypesMap = new LinkedHashMap<String, String>();
            mimeTypesMap.put(Messages.MimeTypeComposite_app_atom_xml, MIME_APP_ATOM_XML);
            mimeTypesMap.put(Messages.MimeTypeComposite_text_html, MIME_TEXT_HTML);
            mimeTypesMap.put(Messages.MimeTypeComposite_app_x_www_form_urlencoded, MIME_APP_X_WWW_FORM_URLENCODED);
            mimeTypesMap.put(Messages.MimeTypeComposite_image_jpeg, MIME_IMAGE_JPEG);
            mimeTypesMap.put(Messages.MimeTypeComposite_app_json, MIME_APP_JSON);
            mimeTypesMap.put(Messages.MimeTypeComposite_image_gif, MIME_IMAGE_GIF);
            mimeTypesMap.put(Messages.MimeTypeComposite_app_octet_stream, MIME_APP_OCTET_STREAM);
            mimeTypesMap.put(Messages.MimeTypeComposite_text_plain, MIME_TEXT_PLAIN);
            mimeTypesMap.put(Messages.MimeTypeComposite_app_svg_xml, MIME_APP_SVG_XML);
            mimeTypesMap.put(Messages.MimeTypeComposite_text_xml, MIME_TEXT_XML);
            mimeTypesMap.put(Messages.MimeTypeComposite_app_xhtml_xml, MIME_APP_XHTML_XML);
            mimeTypesMap.put(Messages.MimeTypeComposite_star_star, MIME_STAR_STAR);
            mimeTypesMap.put(Messages.MimeTypeComposite_app_xml, MIME_APP_XML);
            mimeTypesMap.put(Messages.MimeTypeComposite_star, MIME_STAR);
            mimeTypesMap.put(Messages.MimeTypeComposite_multipart_form_data, MIME_MULTIPART_FORM_DATA);
        }
    }
}

