/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.ui.internal.wizards;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.common.services.ui.jpa.EntitiesPageComposite;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.Messages;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class EntitySelectionDialog
extends TitleAreaDialog {
    private List<String> selectedEntityNames = null;
    private EntitiesPageComposite entitiesComposite = null;
    private String jpaProjectName;

    public EntitySelectionDialog(Shell parentShell, List<String> existingEntityNames, String jpaProjectName) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.selectedEntityNames = existingEntityNames;
        this.jpaProjectName = jpaProjectName;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.EntitySelectionDialog_selectEntitiesTitle);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.setMessage(Messages.EntitySelectionDialog_entitiesMessageTitle);
        this.entitiesComposite = new EntitiesPageComposite(composite, 0, this.selectedEntityNames, this.jpaProjectName);
        this.entitiesComposite.setLayoutData((Object)new GridData(1808));
        this.validateEntities();
        this.entitiesComposite.addPropertyChangeListener((PropertyChangeListener)new EntitiesSelectionListener());
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Control ret = super.createButtonBar(parent);
        boolean enabled = this.selectedEntityNames != null && this.selectedEntityNames.size() > 0;
        this.getButton(0).setEnabled(enabled);
        return ret;
    }

    List<String> getSelectedEntities() {
        return Collections.unmodifiableList(this.selectedEntityNames);
    }

    private boolean validateEntities() {
        boolean noErrors = true;
        List selectedEntities = this.entitiesComposite.getSelectedEntities();
        if (selectedEntities == null || selectedEntities.size() == 0) {
            this.setErrorMessage(Messages.EntitySelectionDialog_selectEntitiesError);
            noErrors = false;
        } else {
            this.setErrorMessage(null);
        }
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(noErrors);
        }
        return false;
    }

    private class EntitiesSelectionListener
    implements PropertyChangeListener {
        private EntitiesSelectionListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("Entities Changed")) {
                EntitySelectionDialog.this.validateEntities();
                EntitySelectionDialog.this.selectedEntityNames = EntitySelectionDialog.this.entitiesComposite.getSelectedEntities();
            }
        }
    }
}

