/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value;

import org.eclipse.jpt.common.utility.internal.model.value.AbstractCollectionValueModel;
import org.eclipse.jpt.common.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionClearEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionRemoveEvent;
import org.eclipse.jpt.common.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionValueModelWrapper<E>
extends AbstractCollectionValueModel {
    protected final CollectionValueModel<? extends E> collectionModel;
    protected final CollectionChangeListener collectionChangeListener;

    protected CollectionValueModelWrapper(CollectionValueModel<? extends E> collectionModel) {
        if (collectionModel == null) {
            throw new NullPointerException();
        }
        this.collectionModel = collectionModel;
        this.collectionChangeListener = this.buildCollectionChangeListener();
    }

    protected CollectionChangeListener buildCollectionChangeListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionAddEvent event) {
                CollectionValueModelWrapper.this.itemsAdded(event);
            }

            public void itemsRemoved(CollectionRemoveEvent event) {
                CollectionValueModelWrapper.this.itemsRemoved(event);
            }

            public void collectionCleared(CollectionClearEvent event) {
                CollectionValueModelWrapper.this.collectionCleared(event);
            }

            public void collectionChanged(CollectionChangeEvent event) {
                CollectionValueModelWrapper.this.collectionChanged(event);
            }

            public String toString() {
                return "collection change listener";
            }
        };
    }

    @Override
    protected void engageModel() {
        this.collectionModel.addCollectionChangeListener("values", this.collectionChangeListener);
    }

    @Override
    protected void disengageModel() {
        this.collectionModel.removeCollectionChangeListener("values", this.collectionChangeListener);
    }

    protected Iterable<E> getItems(CollectionAddEvent event) {
        return event.getItems();
    }

    protected Iterable<E> getItems(CollectionRemoveEvent event) {
        return event.getItems();
    }

    protected abstract void itemsAdded(CollectionAddEvent var1);

    protected abstract void itemsRemoved(CollectionRemoveEvent var1);

    protected abstract void collectionCleared(CollectionClearEvent var1);

    protected abstract void collectionChanged(CollectionChangeEvent var1);
}

