/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.model.ChangeSupport;
import org.eclipse.jpt.common.utility.model.listener.StateChangeListener;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.TreeNodeValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTreeNodeValueModel<V>
extends AbstractModel
implements TreeNodeValueModel<V> {
    protected AbstractTreeNodeValueModel() {
    }

    @Override
    protected ChangeSupport buildChangeSupport() {
        return super.buildChangeSupport();
    }

    @Override
    public void addStateChangeListener(StateChangeListener listener) {
        if (this.hasNoStateChangeListeners()) {
            this.engageValue();
        }
        super.addStateChangeListener(listener);
    }

    protected abstract void engageValue();

    @Override
    public void removeStateChangeListener(StateChangeListener listener) {
        super.removeStateChangeListener(listener);
        if (this.hasNoStateChangeListeners()) {
            this.disengageValue();
        }
    }

    protected abstract void disengageValue();

    @Override
    public void setValue(V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TreeNodeValueModel<V>[] path() {
        ArrayList<TreeNodeValueModel<V>> path = ListTools.reverse(ListTools.list(this.backPath()));
        return path.toArray(new TreeNodeValueModel[path.size()]);
    }

    protected Iterator<TreeNodeValueModel<V>> backPath() {
        return IteratorTools.chainIterator(this, PARENT_TRANSFORMER);
    }

    @Override
    public TreeNodeValueModel<V> child(int index) {
        return this.childrenModel().get(index);
    }

    @Override
    public int childrenSize() {
        return this.childrenModel().size();
    }

    @Override
    public int indexOfChild(TreeNodeValueModel<V> child) {
        ListValueModel children = this.childrenModel();
        int size = children.size();
        int i = 0;
        while (i < size) {
            if (children.get(i) == child) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return this.childrenModel().size() == 0;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        AbstractTreeNodeValueModel other = (AbstractTreeNodeValueModel)o;
        return this.getValue().equals(other.getValue());
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.getValue());
    }
}

