/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal;

import org.eclipse.jpt.common.utility.internal.VersionComparator;

public final class SystemTools {
    public static boolean jvmIsIBM() {
        return SystemTools.jvmIs("IBM");
    }

    public static boolean jvmIsOracle() {
        return SystemTools.jvmIsSun();
    }

    public static boolean jvmIsSun() {
        return SystemTools.jvmIsStrictlySun() || SystemTools.jvmIsStrictlyOracle();
    }

    public static boolean jvmIsStrictlyOracle() {
        return SystemTools.jvmIs("Oracle");
    }

    public static boolean jvmIsStrictlySun() {
        return SystemTools.jvmIs("Sun");
    }

    private static boolean jvmIs(String jvmVendorName) {
        return System.getProperty("java.vendor").startsWith(jvmVendorName);
    }

    public static boolean javaSpecificationVersionIsGreaterThan(String version) {
        return VersionComparator.INTEGER_VERSION_COMPARATOR.compare(SystemTools.javaSpecificationVersion(), version) > 0;
    }

    public static boolean javaSpecificationVersionIsLessThanOrEqualTo(String version) {
        return !SystemTools.javaSpecificationVersionIsGreaterThan(version);
    }

    public static boolean javaSpecificationVersionIsLessThan(String version) {
        return VersionComparator.INTEGER_VERSION_COMPARATOR.compare(SystemTools.javaSpecificationVersion(), version) < 0;
    }

    public static boolean javaSpecificationVersionIsGreaterThanOrEqualTo(String version) {
        return !SystemTools.javaSpecificationVersionIsLessThan(version);
    }

    public static String javaSpecificationVersion() {
        return System.getProperty("java.specification.version");
    }

    public static boolean fileEncodingIsWindows() {
        return SystemTools.fileEncoding().equals("Cp1252");
    }

    public static boolean fileEncodingIsUTF8() {
        return SystemTools.fileEncoding().equals("UTF-8");
    }

    private static String fileEncoding() {
        return System.getProperty("file.encoding");
    }

    public static boolean osIsWindows() {
        return SystemTools.osIs("Windows");
    }

    public static boolean osIsLinux() {
        return SystemTools.osIs("Linux");
    }

    public static boolean osIsMac() {
        return SystemTools.osIs("Mac");
    }

    private static boolean osIs(String osName) {
        return System.getProperty("os.name").indexOf(osName) != -1;
    }

    private SystemTools() {
        throw new UnsupportedOperationException();
    }
}

