/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.util;

import oracle.eclipse.tools.adf.dtrt.internal.DTRTBundle;
import oracle.eclipse.tools.adf.dtrt.internal.ExtenderManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class ValidationPreferencesHelper {
    public static final String PREF_VALIDATION_DISABLED = "validationDisabled";
    public static final String PREF_MAKE_ERRORS_WARNINGS = "makeErrorsWarnings";
    private static final String KEY_VALIDATION_PREFIX = "validation.";
    public static final String KEY_DISABLE_VALIDATION = "validation.validationDisabled";
    public static final boolean DEFAULT_DISABLE_VALIDATION = false;
    public static final String KEY_MAKE_ERRORS_WARNINGS = "validation.makeErrorsWarnings";
    public static final boolean DEFAULT_MAKE_ERRORS_WARNINGS = true;
    public static final String KEY_TESTING = "_validationTesting_";
    protected static final String ADF_PREFERENCE_KEY = "oracle.eclipse.tools.adf.dtrt";
    protected static final String VALIDATION_NODE_KEY = "/instance/oracle.eclipse.tools.adf.dtrt";
    private IScopeContext[] scopes = new IScopeContext[]{InstanceScope.INSTANCE};
    private boolean isTestEnvironment;

    public static ValidationPreferencesHelper createValidationPreferencesHelper() {
        ValidationPreferencesHelper helper = ExtenderManager.INSTANCE.getExtender(ValidationPreferencesHelper.class);
        return helper != null ? helper : new ValidationPreferencesHelper();
    }

    protected ValidationPreferencesHelper() {
        this.initializePreferenceStoreIfNecessary();
    }

    private void initializePreferenceStoreIfNecessary() {
        try {
            if (Platform.getPreferencesService() == null || this.isForTesting()) {
                this.isTestEnvironment = true;
            } else if (!Platform.getPreferencesService().getRootNode().nodeExists(VALIDATION_NODE_KEY)) {
                this.loadPreferences();
            }
        }
        catch (BackingStoreException e) {
            DTRTBundle.log(e);
        }
    }

    protected void loadPreferences() {
    }

    protected final boolean isForTesting() {
        return System.getProperty(KEY_TESTING) != null;
    }

    public final boolean isValidationDisabled() {
        if (this.isTestEnvironment) {
            return false;
        }
        return Platform.getPreferencesService().getBoolean(ADF_PREFERENCE_KEY, KEY_DISABLE_VALIDATION, false, this.scopes);
    }

    public final boolean isReduceErrorsToWarnings() {
        if (this.isTestEnvironment) {
            return false;
        }
        return Platform.getPreferencesService().getBoolean(ADF_PREFERENCE_KEY, KEY_MAKE_ERRORS_WARNINGS, true, this.scopes);
    }

    public final IEclipsePreferences getValidationPreferences() {
        return (IEclipsePreferences)Platform.getPreferencesService().getRootNode().node(VALIDATION_NODE_KEY);
    }
}

