/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.util;

import oracle.eclipse.tools.adf.dtrt.command.ICommand;
import oracle.eclipse.tools.adf.dtrt.command.ICommandStack;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public final class UndoableOperationDecorator
extends AbstractOperation {
    private ICommand command;

    public UndoableOperationDecorator(ICommand command) {
        super(command.getLabel());
        if (command.isDisposed()) {
            throw new IllegalArgumentException("command cannot be disposed");
        }
        this.command = command;
    }

    public void dispose() {
        if (this.command != null) {
            this.command.dispose();
            this.command = null;
        }
        super.dispose();
    }

    public ICommand getCommand() {
        return this.command;
    }

    public String getLabel() {
        return this.getCommand().getLabel();
    }

    private ICommandStack getCommandStack() {
        return this.getCommand().getCommandStack();
    }

    public boolean canExecute() {
        return this.getCommand() != null && this.getCommand().canExecute().isOK();
    }

    public boolean canUndo() {
        return this.getCommand() != null && this.getCommand().canUndo().isOK();
    }

    public boolean canRedo() {
        return this.getCommand() != null && this.getCommand().canRedo().isOK();
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.getCommand().getLastOperation() == null) {
            this.getCommandStack().setExecuteCommand(this.getCommand());
            return this.execute(ICommand.CommandOperation.EXECUTION, monitor);
        }
        return Status.OK_STATUS;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(ICommand.CommandOperation.UNDO, monitor);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(ICommand.CommandOperation.REDO, monitor);
    }

    private IStatus execute(ICommand.CommandOperation commandOperation, IProgressMonitor monitor) throws ExecutionException {
        if (DTRTUtil.isNotDisposed(this.getCommand())) {
            try {
                DTRTUtil.execute(this.getCommandStack(), commandOperation, monitor);
            }
            catch (Exception e) {
                throw new ExecutionException(e.getMessage(), (Throwable)e);
            }
            return Status.OK_STATUS;
        }
        return DTRTUtil.createErrorStatus(Messages.operationDisposedError);
    }

    private static class Messages
    extends NLS {
        public static String operationDisposedError;

        static {
            NLS.initializeMessages((String)UndoableOperationDecorator.class.getName(), Messages.class);
        }

        private Messages() {
        }
    }
}

