/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.util;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEExecutableContext;
import oracle.eclipse.tools.adf.dtrt.util.ExecutableContextAdapter;
import oracle.eclipse.tools.adf.dtrt.util.IDisposable;
import oracle.eclipse.tools.common.util.Pair;

public final class SaveSummaryCollector
extends ExecutableContextAdapter
implements IDisposable {
    private IOEPEExecutableContext context;
    private LinkedList<Pair<Date, IOEPEExecutableContext.ISaveSummary>> saveSummaries;

    @Override
    public void dispose() {
        this.context = null;
        if (this.saveSummaries != null) {
            this.saveSummaries.clear();
            this.saveSummaries = null;
        }
    }

    @Override
    public void handleSave(IOEPEExecutableContext context, IOEPEExecutableContext.ISaveSummary saveSummary) {
        if (saveSummary != null && saveSummary.getFileCount() > 0) {
            if (this.context == null) {
                this.context = context;
            } else if (this.context != context) {
                throw new IllegalStateException("A collector can only be used with one context.");
            }
            if (this.saveSummaries == null) {
                this.saveSummaries = new LinkedList();
            }
            this.saveSummaries.addFirst((Pair<Date, IOEPEExecutableContext.ISaveSummary>)new Pair((Object)Calendar.getInstance().getTime(), (Object)saveSummary));
        }
    }

    public IOEPEExecutableContext getContext() {
        return this.context;
    }

    public boolean isEmpty() {
        return this.saveSummaries == null || this.saveSummaries.isEmpty();
    }

    public List<? extends Pair<Date, IOEPEExecutableContext.ISaveSummary>> getSaveSummaries() {
        return this.saveSummaries != null ? Collections.unmodifiableList(new ArrayList<Pair<Date, IOEPEExecutableContext.ISaveSummary>>(this.saveSummaries)) : Collections.emptyList();
    }
}

