/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEExecutableContext;
import org.eclipse.core.resources.IFile;

public final class SaveSummary
implements IOEPEExecutableContext.ISaveSummary {
    private final int fileCounter;
    private final Set<IFile> createdFiles;
    private final Set<IFile> deletedFiles;
    private final Set<IFile> changedFiles;

    public SaveSummary(Collection<? extends IFile> createdFiles, Collection<? extends IFile> deletedFiles, Collection<? extends IFile> changedFiles) {
        this.createdFiles = this.createUnmodifiableSet(createdFiles);
        this.deletedFiles = this.createUnmodifiableSet(deletedFiles);
        this.changedFiles = this.createUnmodifiableSet(changedFiles);
        int counter = this.createdFiles.size();
        counter += this.deletedFiles.size();
        this.fileCounter = counter += this.changedFiles.size();
    }

    private Set<IFile> createUnmodifiableSet(Collection<? extends IFile> files) {
        return files != null && !files.isEmpty() ? Collections.unmodifiableSet(new HashSet<IFile>(files)) : Collections.emptySet();
    }

    @Override
    public int getFileCount() {
        return this.fileCounter;
    }

    @Override
    public Collection<? extends IFile> getCreatedFiles() {
        return this.createdFiles;
    }

    @Override
    public Collection<? extends IFile> getDeletedFiles() {
        return this.deletedFiles;
    }

    @Override
    public Collection<? extends IFile> getChangedFiles() {
        return this.changedFiles;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.fileCounter;
        result = 31 * result + (this.changedFiles == null ? 0 : this.changedFiles.hashCode());
        result = 31 * result + (this.createdFiles == null ? 0 : this.createdFiles.hashCode());
        result = 31 * result + (this.deletedFiles == null ? 0 : this.deletedFiles.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof IOEPEExecutableContext.ISaveSummary)) {
            return false;
        }
        IOEPEExecutableContext.ISaveSummary other = (IOEPEExecutableContext.ISaveSummary)obj;
        return this.getFileCount() == other.getFileCount() && this.getChangedFiles().size() == other.getChangedFiles().size() && this.getCreatedFiles().size() == other.getCreatedFiles().size() && this.getDeletedFiles().size() == other.getDeletedFiles().size() && this.getChangedFiles().containsAll(other.getChangedFiles()) && this.getCreatedFiles().containsAll(other.getCreatedFiles()) && this.getDeletedFiles().containsAll(other.getDeletedFiles());
    }
}

