/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;

public abstract class MatchingResourceChangeListener<R extends IResource>
implements IResourceChangeListener {
    private boolean stopAtFirstMatch;
    private volatile AtomicInteger workingFlag = new AtomicInteger();

    public final MatchingResourceChangeListener<R> setStopAtFirstMatch(boolean stopAtFirstMatch) {
        this.stopAtFirstMatch = stopAtFirstMatch;
        return this;
    }

    public boolean isStopAtFirstMatch() {
        return this.stopAtFirstMatch;
    }

    public final boolean isWorking() {
        return this.workingFlag.get() > 0;
    }

    public abstract Collection<? extends R> getResourcesToMatch();

    public abstract void matchedResources(Set<R> var1);

    public final void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta rootDelta = event.getDelta();
        if (rootDelta != null && this.isValidRootDelta(rootDelta)) {
            Set<R> resources = this.asNewSet(this.getResourcesToMatch());
            if (!resources.isEmpty()) {
                this.workingFlag.incrementAndGet();
                try {
                    Iterator<R> i = resources.iterator();
                    while (i.hasNext()) {
                        IResource resource = (IResource)i.next();
                        IResourceDelta delta = rootDelta.findMember(resource.getFullPath());
                        if (delta != null && this.isMatchingDelta(delta)) continue;
                        i.remove();
                    }
                }
                finally {
                    this.workingFlag.decrementAndGet();
                    assert (this.workingFlag.get() >= 0);
                }
                this.matchedResources(resources);
            }
        } else {
            this.matchedResources(new HashSet(0));
        }
    }

    protected Set<R> asNewSet(Collection<? extends R> resources) {
        return new HashSet<R>(resources);
    }

    protected boolean isValidRootDelta(IResourceDelta delta) {
        return delta.getKind() != 0 && delta.getResource() != null && !delta.getResource().isDerived();
    }

    protected abstract boolean isMatchingDelta(IResourceDelta var1);

    protected final boolean isFileChangeDelta(IResourceDelta delta, boolean checkIfRemoved) {
        if (delta.getResource() instanceof IFile) {
            if (checkIfRemoved && delta.getKind() == 2) {
                return true;
            }
            return delta.getKind() == 4 && ((delta.getFlags() & 0x100) != 0 || (delta.getFlags() & 0x40000) != 0);
        }
        return false;
    }
}

