/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.util;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public final class LRUMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 1L;
    private final int fMaxSize;
    private final int numberOfEldestEntriesToRemove;

    public LRUMap(int maxSize) {
        super(maxSize, 0.75f, true);
        this.fMaxSize = maxSize;
        this.numberOfEldestEntriesToRemove = 1;
    }

    public LRUMap(int initialSize, int maxSize, int numberOfEldestEntriesToRemove) {
        super(initialSize, 0.75f, true);
        this.fMaxSize = maxSize;
        this.numberOfEldestEntriesToRemove = 1 < numberOfEldestEntriesToRemove && numberOfEldestEntriesToRemove <= maxSize ? numberOfEldestEntriesToRemove : 1;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        if (this.size() > this.fMaxSize) {
            if (this.numberOfEldestEntriesToRemove == 1) {
                this.aboutToRemoveEldestEntry(eldest);
                return true;
            }
            this.aboutToRemoveEldestEntries(this.numberOfEldestEntriesToRemove);
            Iterator entryIterator = this.entrySet().iterator();
            try {
                int i = 0;
                while (i < this.numberOfEldestEntriesToRemove && entryIterator.hasNext()) {
                    entryIterator.next();
                    entryIterator.remove();
                    ++i;
                }
            }
            catch (Exception exception) {}
        }
        return false;
    }

    protected void aboutToRemoveEldestEntry(Map.Entry<K, V> eldest) {
    }

    protected void aboutToRemoveEldestEntries(int numberOfEldestEntriesToRemove) {
    }
}

