/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.util;

import oracle.eclipse.tools.adf.dtrt.command.ICommand;
import oracle.eclipse.tools.adf.dtrt.command.ICommandStack;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IExceptionHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.command.AbortExecutionException;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.util.WrappedException;

public class EMFCommandDecorator
extends AbstractCommand {
    private ICommand command;
    private IExceptionHandler exceptionHandler;

    public EMFCommandDecorator(ICommand command) {
        this.command = command;
    }

    public void dispose() {
        if (this.command != null) {
            this.command.dispose();
            this.command = null;
        }
        this.exceptionHandler = null;
        super.dispose();
    }

    public ICommand getCommand() {
        return this.command;
    }

    protected final ICommandStack getCommandStack() {
        return this.getCommand().getCommandStack();
    }

    public void setExceptionHandler(IExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public IExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    protected Object beforeExecute() {
        return null;
    }

    protected void afterExecute(Object beforeExecuteData) {
    }

    public final String getLabel() {
        return this.getCommand().getLabel();
    }

    public final boolean canExecute() {
        ICommand.CommandOperation nextOperation = ICommand.CommandOperation.nextOperation(this.getCommand());
        return nextOperation == ICommand.CommandOperation.EXECUTION ? this.getCommand().canExecute().isOK() : (nextOperation == ICommand.CommandOperation.REDO ? this.getCommand().canRedo().isOK() : false);
    }

    public final boolean canUndo() {
        return this.getCommand() != null && this.getCommand().canUndo().isOK();
    }

    public final void execute() {
        this.getCommandStack().setExecuteCommand(this.getCommand());
        this.execute(ICommand.CommandOperation.EXECUTION);
    }

    public final void undo() {
        this.execute(ICommand.CommandOperation.UNDO);
    }

    public final void redo() {
        this.execute(ICommand.CommandOperation.REDO);
    }

    private void execute(ICommand.CommandOperation operation) {
        ICommandStack commandStack = this.getCommandStack();
        try {
            Object data = this.beforeExecute();
            DTRTUtil.execute(commandStack, operation, null);
            this.afterExecute(data);
        }
        catch (InterruptedException e) {
            throw new AbortExecutionException((Throwable)e);
        }
        catch (CoreException e) {
            if (this.getExceptionHandler() != null) {
                this.getExceptionHandler().handleException((Exception)((Object)e));
            }
            throw new WrappedException((Exception)((Object)e));
        }
    }
}

