/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.adf.common.util.ProjectUtils;
import oracle.eclipse.tools.adf.dtrt.command.ICommand;
import oracle.eclipse.tools.adf.dtrt.command.ICommandStack;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEContext;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEContextFactory;
import oracle.eclipse.tools.adf.dtrt.jdt.JDTUtil;
import oracle.eclipse.tools.adf.dtrt.locator.IObjectLocator;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.dtrt.util.IDescriptor;
import oracle.eclipse.tools.adf.dtrt.util.IDisposable;
import oracle.eclipse.tools.adf.dtrt.util.IFileMarker;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.util.jdt.JavaProjectUtil;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.WrappedException;

public final class DTRTUtil {
    public static final Object[] EMPTY_ARRAY = new Object[0];
    private static final int WRAP_LENGTH = 60;
    public static final Comparator<Object> COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            return DTRTUtil.compare(o1, o2);
        }

        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }
    };

    private DTRTUtil() {
    }

    public static byte[] read(URL url) throws IOException {
        if (url != null) {
            try (InputStream stream = url.openStream();){
                byte[] byArray = DTRTUtil.read(stream);
                return byArray;
            }
        }
        return null;
    }

    public static byte[] read(InputStream stream) throws IOException {
        if (stream != null) {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            byte[] bytes = new byte[1024];
            int count = stream.read(bytes);
            while (count != -1) {
                buf.write(bytes, 0, count);
                count = stream.read(bytes);
            }
            return buf.toByteArray();
        }
        return null;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static <T> int compare(T o1, T o2) {
        if (o1 == null) {
            return o2 == null ? 0 : 1;
        }
        return o2 == null ? -1 : (o1 == o2 ? 0 : (o1 instanceof String && o2 instanceof String ? Collator.getInstance().compare((String)o1, (String)o2) : (o1 instanceof Comparable && o2 instanceof Comparable ? ((Comparable)o1).compareTo(o2) : (o1 instanceof IDescriptor && o2 instanceof IDescriptor ? DTRTUtil.compare(((IDescriptor)o1).getLabel(), ((IDescriptor)o2).getLabel()) : (o1 instanceof IDescribable && o2 instanceof IDescribable ? DTRTUtil.compare(((IDescribable)o1).getDescriptor(), ((IDescribable)o2).getDescriptor()) : o1.toString().compareTo(o2.toString()))))));
    }

    public static boolean isModelProject(IProject project) {
        return project != null && JavaProjectUtil.isJavaProject((IProject)project) && !WtpProjectUtil.isDynamicWebProject((IProject)project) && !WtpProjectUtil.isEarProject((IProject)project);
    }

    public static boolean isWebProject(IProject project) {
        return project != null && WtpProjectUtil.isDynamicWebProject((IProject)project);
    }

    public static boolean isEARProject(IProject project) {
        return project != null && WtpProjectUtil.isEarProject((IProject)project);
    }

    public static IProject getEARProject(IResource resource) {
        return resource != null && resource.getProject() != null ? WtpProjectUtil.findReferencingEarProject((IProject)resource.getProject()) : null;
    }

    public static IProject getEARProject(IObjectLocator locator, IResource resource) {
        if (resource != null && resource.getProject() != null) {
            IProject earProject = null;
            if (locator != null) {
                earProject = locator.getCachedEARProject(resource.getProject());
            }
            if (earProject == null) {
                earProject = DTRTUtil.getEARProject(resource);
            }
            return earProject;
        }
        return null;
    }

    public static boolean hasJRFOnTheClasspath(IProject project) {
        try {
            return JDTUtil.getNoCachingTypeHelper().findType(project, "oracle.binding.meta.AccessorDefinition") != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String toNotNullString(String string) {
        return string == null ? "" : string;
    }

    public static boolean isNotDisposed(IOEPEContext context) {
        return context != null && !context.isDisposed();
    }

    public static boolean isNotDisposed(ICommand command) {
        return command != null && !command.isDisposed();
    }

    public static void assertTrue(boolean actual, String detail) throws AssertionFailedException {
        if (!actual) {
            DTRTUtil.fail(detail);
        }
    }

    public static void assertTrue(boolean actual, String format, Object ... args) throws AssertionFailedException {
        if (!actual) {
            DTRTUtil.fail(format, args);
        }
    }

    public static void fail(String detail) throws AssertionFailedException {
        throw new AssertionFailedException(detail);
    }

    public static void fail(String format, Object ... args) throws AssertionFailedException {
        throw new AssertionFailedException(String.format(format, args));
    }

    public static int indexOf(Object[] array, Object element) {
        if (array != null) {
            int i = 0;
            while (i < array.length) {
                if (DTRTUtil.equals(array[i], element)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static int indexOf(int[] array, int element) {
        if (array != null) {
            int i = 0;
            while (i < array.length) {
                if (array[i] == element) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static <T extends IOEPEContext> T createContext(IResource resource, Class<T> contextType) {
        IOEPEContextFactory contextFactory;
        Project oepeProject;
        IProject project;
        if (resource != null && contextType != null && (project = resource.getProject()) != null && (oepeProject = (Project)project.getAdapter(Project.class)) != null && (contextFactory = (IOEPEContextFactory)oepeProject.getAppService(IOEPEContextFactory.class)) != null) {
            return contextFactory.createContext(contextType);
        }
        return null;
    }

    public static <T> List<T> trimNulls(T[] array) {
        if (array != null) {
            ArrayList<T> list = new ArrayList<T>(array.length);
            T[] TArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                T elemement = TArray[n2];
                if (elemement != null) {
                    list.add(elemement);
                }
                ++n2;
            }
            return list;
        }
        return new ArrayList(0);
    }

    public static Throwable getRootCause(CoreException e) {
        if (e != null) {
            IStatus[] children;
            IStatus status = e.getStatus();
            while ((children = status.getChildren()).length > 0) {
                status = children[0];
                assert (status != null);
            }
            return status.getException();
        }
        return null;
    }

    public static IStatus createErrorStatus(Throwable throwable) {
        return DTRTUtil.createErrorStatus(null, throwable);
    }

    public static IStatus createErrorStatus(String message) {
        return DTRTUtil.createErrorStatus(message, null);
    }

    public static IStatus createErrorStatus(String format, Object ... args) {
        return format != null ? DTRTUtil.createErrorStatus(String.format(format, args)) : null;
    }

    public static IStatus createErrorStatus(String message, Throwable throwable) {
        MultiStatus multiStatus;
        if (throwable instanceof WrappedException) {
            return DTRTUtil.createErrorStatus(message, throwable.getCause());
        }
        if (throwable instanceof CoreException) {
            IStatus status = ((CoreException)throwable).getStatus();
            if (message == null || message.equals(status.getMessage())) {
                return status;
            }
            if (status.getMessage() != null || status.getException() != null) {
                MultiStatus multiStatus2 = new MultiStatus("oracle.eclipse.tools.adf.dtrt", 0, message, null);
                multiStatus2.add(status);
                return multiStatus2;
            }
            throwable = null;
        }
        if (message == null && throwable == null) {
            return null;
        }
        if (throwable == null) {
            return new Status(4, "oracle.eclipse.tools.adf.dtrt", message);
        }
        if (message == null) {
            message = throwable.getLocalizedMessage();
            if (message == null && (message = throwable.getMessage()) == null) {
                message = throwable.getClass().getName();
            }
            if (throwable.getCause() == null) {
                return new Status(4, "oracle.eclipse.tools.adf.dtrt", message, throwable);
            }
            multiStatus = new MultiStatus("oracle.eclipse.tools.adf.dtrt", 0, message, throwable);
            throwable = throwable.getCause();
        } else {
            multiStatus = new MultiStatus("oracle.eclipse.tools.adf.dtrt", 0, message, null);
        }
        multiStatus.add(DTRTUtil.createErrorStatus(throwable));
        return multiStatus;
    }

    public static IStatus getLeafStatus(IStatus status) {
        return status != null && status.getChildren().length > 0 ? DTRTUtil.getLeafStatus(status.getChildren()[0]) : status;
    }

    public static boolean execute(ICommandStack commandStack, ICommand.CommandOperation commandOperation, IProgressMonitor monitor) throws InterruptedException, CoreException {
        if (commandStack != null && commandOperation != null) {
            switch (commandOperation) {
                case EXECUTION: {
                    commandStack.execute(monitor);
                    return true;
                }
                case UNDO: {
                    commandStack.undo(monitor);
                    return true;
                }
                case REDO: {
                    commandStack.redo(monitor);
                    return true;
                }
            }
        }
        return false;
    }

    public static String upperCaseFirstLetter(String name) {
        int cp = name.codePointAt(0);
        return new StringBuffer().appendCodePoint(Character.toTitleCase(cp)).append(name.substring(Character.charCount(cp))).toString();
    }

    public static IResource getAccessibleResource(IResource resource) {
        IResource res = resource;
        while (res instanceof IFile || res instanceof IFolder || res instanceof IProject) {
            if (res.isAccessible()) {
                return res;
            }
            res = res.getParent();
        }
        return null;
    }

    public static boolean contains(IContainer container, IResource resource) {
        if (container != null && resource != null) {
            IResource parent = resource;
            while (parent != null) {
                if (container.equals((Object)parent)) {
                    return true;
                }
                parent = parent.getParent();
            }
            return container instanceof IWorkspaceRoot && container.equals((Object)resource.getWorkspace().getRoot());
        }
        return false;
    }

    public static IMarker createMarker(IFileMarker fileMarker) throws CoreException {
        if (fileMarker != null && fileMarker.getFile() != null && fileMarker.getType() != null) {
            IMarker marker = fileMarker.getFile().createMarker(fileMarker.getType());
            if (fileMarker.getCharStart() >= 0) {
                marker.setAttribute("charStart", fileMarker.getCharStart());
            }
            if (fileMarker.getCharEnd() >= 0) {
                marker.setAttribute("charStart", fileMarker.getCharEnd());
            }
            if (fileMarker.getLineNumber() > 0) {
                marker.setAttribute("lineNumber", fileMarker.getLineNumber());
            }
            return marker;
        }
        return null;
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1.equals(o2)) {
            return true;
        }
        if (o1 instanceof Object[]) {
            if (!(o2 instanceof Object[])) {
                return false;
            }
            Object[] a1 = (Object[])o1;
            Object[] a2 = (Object[])o2;
            if (a1.length != a2.length) {
                return false;
            }
            int i = 0;
            while (i < a1.length) {
                if (!DTRTUtil.equals(a1[i], a2[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return o1 instanceof boolean[] ? o2 instanceof boolean[] && Arrays.equals((boolean[])o1, (boolean[])o2) : (o1 instanceof byte[] ? o2 instanceof byte[] && Arrays.equals((byte[])o1, (byte[])o2) : (o1 instanceof char[] ? o2 instanceof char[] && Arrays.equals((char[])o1, (char[])o2) : (o1 instanceof double[] ? o2 instanceof double[] && Arrays.equals((double[])o1, (double[])o2) : (o1 instanceof float[] ? o2 instanceof float[] && Arrays.equals((float[])o1, (float[])o2) : (o1 instanceof int[] ? o2 instanceof int[] && Arrays.equals((int[])o1, (int[])o2) : (o1 instanceof long[] ? o2 instanceof long[] && Arrays.equals((long[])o1, (long[])o2) : (o1 instanceof short[] ? o2 instanceof short[] && Arrays.equals((short[])o1, (short[])o2) : false)))))));
    }

    public static String getWebResourcePath(IFile file) {
        IPath path = ProjectUtils.computeWebContentRelativePath((IResource)file);
        if (path == null) {
            path = file.getProjectRelativePath();
        }
        return DTRTUtil.sanitizePath(path.toString());
    }

    private static String sanitizePath(String path) {
        return path.charAt(0) == '/' ? path.substring(1) : path;
    }

    public static String getLabel(IDescribable describable) {
        return describable != null ? DTRTUtil.getLabel(describable.getDescriptor()) : null;
    }

    public static String getToolTipText(IDescribable describable) {
        return describable != null ? DTRTUtil.getToolTipText(describable.getDescriptor()) : null;
    }

    public static Object getImage(IDescribable describable) {
        return describable != null ? DTRTUtil.getImage(describable.getDescriptor()) : null;
    }

    public static String getLabel(IDescriptor descriptor) {
        return descriptor != null ? descriptor.getLabel() : null;
    }

    public static String getToolTipText(IDescriptor descriptor) {
        return descriptor != null ? descriptor.getToolTipText() : null;
    }

    public static String adjustTooltipText(String text) {
        return DTRTUtil.adjustTooltipText(text, 60);
    }

    public static String adjustTooltipText(String text, int wrapLength) {
        if (text != null && text.length() >= wrapLength) {
            text = text.replace('\n', ' ');
            text = text.replace('\t', ' ');
            text = text.replace("  ", " ");
            int length = text.length();
            String tempText = "";
            String[] words = text.split(" ");
            int wrapCount = length / wrapLength;
            int wrapCounter = 0;
            int wordCounter = 0;
            int wordCount = words.length;
            while (wrapCounter <= wrapCount) {
                String line = "";
                while (wordCounter < wordCount) {
                    line = String.valueOf(line) + words[wordCounter];
                    ++wordCounter;
                    if (line.length() + 1 > wrapLength) {
                        line = String.valueOf(line) + '\n';
                        break;
                    }
                    line = String.valueOf(line) + " ";
                }
                tempText = String.valueOf(tempText) + line;
                ++wrapCounter;
            }
            text = tempText.trim();
        }
        return text;
    }

    public static Object getImage(IDescriptor descriptor) {
        return descriptor != null ? descriptor.getImage() : null;
    }

    public static <T> T getFirstElement(Collection<? extends T> collection) {
        return collection == null || collection.isEmpty() ? null : (collection instanceof List ? (T)((List)collection).get(0) : (T)collection.iterator().next());
    }

    public static <T> T getFistElement(T[] array) {
        return array == null || array.length == 0 ? null : (T)array[0];
    }

    public static <K, V> void putUniqueEntries(Map<K, V> mapToGrow, Map<? extends K, ? extends V> mapToInclude) {
        if (mapToGrow != null && mapToInclude != null && !mapToInclude.isEmpty()) {
            if (mapToGrow.isEmpty()) {
                mapToGrow.putAll(mapToInclude);
            } else {
                for (Map.Entry<K, V> entryToInclude : mapToInclude.entrySet()) {
                    if (mapToGrow.containsKey(entryToInclude.getKey())) continue;
                    mapToGrow.put(entryToInclude.getKey(), entryToInclude.getValue());
                }
            }
        }
    }

    public static <T> T getAdapter(IAdaptable adaptable, Class<T> adapter) {
        Object adapted;
        if (adaptable != null && adapter != null && adapter.isInstance(adapted = adaptable.getAdapter(adapter))) {
            return adapter.cast(adapted);
        }
        return null;
    }

    public static void dispose(Collection<? extends IDisposable> disposables) {
        if (disposables != null) {
            for (IDisposable iDisposable : disposables) {
                iDisposable.dispose();
            }
        }
    }

    public static void dispose(IDisposable[] disposables) {
        if (disposables != null) {
            int i = 0;
            while (i < disposables.length) {
                disposables[i].dispose();
                ++i;
            }
        }
    }

    public static <T> List<T> toUnmodifiablePrunedList(Collection<T> collection) {
        return collection == null || collection.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<T>(collection));
    }

    public static IStatus getStatus(IStatus status, int severity, int code) {
        if (status != null) {
            if (status.getSeverity() == severity && status.getCode() == code) {
                return status;
            }
            IStatus[] children = status.getChildren();
            if (children != null && children.length > 0) {
                int i = 0;
                while (i < children.length) {
                    IStatus found = DTRTUtil.getStatus(children[i], severity, code);
                    if (found != null) {
                        return found;
                    }
                    ++i;
                }
            }
        }
        return null;
    }
}

