/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEContext;
import oracle.eclipse.tools.adf.dtrt.context.typed.IPageDefinitionContext;
import oracle.eclipse.tools.adf.dtrt.object.IBinding;
import oracle.eclipse.tools.adf.dtrt.object.IBindingObject;
import oracle.eclipse.tools.adf.dtrt.object.IDataControl;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlChild;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlObject;
import oracle.eclipse.tools.adf.dtrt.object.IELMetadata;
import oracle.eclipse.tools.adf.dtrt.object.IELMethod;
import oracle.eclipse.tools.adf.dtrt.object.IELProperty;
import oracle.eclipse.tools.adf.dtrt.object.IELType;
import oracle.eclipse.tools.adf.dtrt.object.IExecutable;
import oracle.eclipse.tools.adf.dtrt.object.IIteratorBinding;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IPageDefinition;
import oracle.eclipse.tools.adf.dtrt.object.IStructure;
import oracle.eclipse.tools.adf.dtrt.object.IStructureObject;
import oracle.eclipse.tools.adf.dtrt.usage.BindingObjectUsageManager;
import oracle.eclipse.tools.adf.dtrt.util.CompoundList;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDataControlProvider;
import oracle.eclipse.tools.common.util.Pair;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class DTRTObjectUtil {
    private DTRTObjectUtil() {
    }

    public static IObject find(Collection<? extends IObject> roots, URI objectURI) {
        if (roots != null && objectURI != null) {
            for (IObject iObject : roots) {
                IPageDefinition pageDefinition;
                IObject found;
                URI uri = iObject.getURI();
                if (uri == null) continue;
                if (DTRTUtil.equals(uri, objectURI)) {
                    return iObject;
                }
                URI relativeURI = uri.relativize(objectURI);
                if (relativeURI.equals(objectURI) || !(iObject instanceof IPageDefinition ? (found = DTRTObjectUtil.find(DTRTObjectUtil.getBindingObjects(pageDefinition = (IPageDefinition)iObject), objectURI)) != null : (iObject instanceof IDataControlObject ? (found = DTRTObjectUtil.find(((IDataControlObject)iObject).getChildren(), objectURI)) != null : iObject instanceof IStructureObject && (found = DTRTObjectUtil.find(((IStructureObject)iObject).getChildren(), objectURI)) != null))) continue;
                return found;
            }
        }
        return null;
    }

    public static IObject find(IPageDefinitionContext context, URI objectURI) {
        if (context != null && objectURI != null) {
            try {
                ArrayList<IObject> roots = new ArrayList<IObject>(context.getDataControls(null).size() + 1);
                roots.add(context.getPageDefinition());
                roots.addAll(context.getDataControls(null));
                return DTRTObjectUtil.find(roots, objectURI);
            }
            catch (InterruptedException interruptedException) {}
        }
        return null;
    }

    public static Pair<List<IBinding>, List<IExecutable>> computePageDefinitionUsage(IPageDefinition pageDefinition, IDataControlObject dataControlObject) {
        if (DTRTObjectUtil.isAccessible(pageDefinition) && DTRTObjectUtil.isAccessible(dataControlObject) && pageDefinition.getUsedDataControlObjects().contains(dataControlObject)) {
            ArrayList<IBinding> bindings = new ArrayList<IBinding>(pageDefinition.getBindings().size() / 2);
            for (IBinding iBinding : pageDefinition.getBindings()) {
                if (!dataControlObject.equals(iBinding.getDataControlObject())) continue;
                bindings.add(iBinding);
            }
            ArrayList<IExecutable> arrayList = new ArrayList<IExecutable>(pageDefinition.getExecutables().size() / 2);
            for (IExecutable iExecutable : pageDefinition.getExecutables()) {
                if (!dataControlObject.equals(iExecutable.getDataControlObject())) continue;
                arrayList.add(iExecutable);
            }
            return new Pair(bindings, arrayList);
        }
        return new Pair(new ArrayList(0), new ArrayList(0));
    }

    public static <T extends IObject> T find(Collection<? extends T> objects, String id) {
        if (id != null && objects != null) {
            for (IObject object : objects) {
                if (!DTRTUtil.equals(id, object.getId())) continue;
                return (T)object;
            }
        }
        return null;
    }

    public static boolean isNotDisposed(IObject object) {
        return object != null && !object.isDisposed();
    }

    public static List<? extends IBindingObject> getBindingObjects(IPageDefinition pageDefinition) {
        return DTRTObjectUtil.isAccessible(pageDefinition) ? new CompoundList<IExecutable>((List<? extends IExecutable>)pageDefinition.getBindings(), pageDefinition.getExecutables()) : Collections.emptyList();
    }

    public static Map<IObject, IStatus> validateBindingObjects(IOEPEContext context, IPageDefinition pageDefinition, IProgressMonitor monitor) {
        ArrayList<? extends IBindingObject> bindingObjects;
        if (context != null && DTRTObjectUtil.isAccessible(pageDefinition) && !(bindingObjects = new ArrayList<IBindingObject>(DTRTObjectUtil.getBindingObjects(pageDefinition))).isEmpty()) {
            HashMap<IObject, IStatus> map = new HashMap<IObject, IStatus>(bindingObjects.size());
            for (IBindingObject iBindingObject : bindingObjects) {
                IStatus status = context.validate(iBindingObject, monitor);
                map.put(iBindingObject, status);
            }
            return map;
        }
        return new HashMap<IObject, IStatus>(3);
    }

    public static Map<IObject, IStatus> validate(IOEPEContext context, Collection<? extends IObject> objects, IProgressMonitor monitor) {
        if (DTRTUtil.isNotDisposed(context) && objects != null && !objects.isEmpty()) {
            ArrayList<? extends IObject> copy = new ArrayList<IObject>(objects);
            HashMap<IObject, IStatus> map = new HashMap<IObject, IStatus>(copy.size());
            for (IObject iObject : objects) {
                IStatus status = context.validate(iObject, monitor);
                map.put(iObject, status);
            }
            return map;
        }
        return new HashMap<IObject, IStatus>(3);
    }

    public static boolean isExecutable(Object object) {
        return object instanceof IExecutable && !(object instanceof IIteratorBinding);
    }

    public static List<IBindingObject> findBindingObjects(IPageDefinition pageDefinition, Node node) {
        if (DTRTObjectUtil.isAccessible(pageDefinition) && node != null) {
            String text;
            ArrayList<IBindingObject> bindingObjects = new ArrayList<IBindingObject>(5);
            NamedNodeMap attributeMap = node.getAttributes();
            if (attributeMap != null) {
                int j = 0;
                while (j < attributeMap.getLength()) {
                    String value;
                    Node node2 = attributeMap.item(j);
                    if (node2 instanceof Attr && !DTRTUtil.isEmpty(value = ((Attr)node2).getValue())) {
                        for (IBindingObject iBindingObject : pageDefinition.findBindingObjects(value)) {
                            if (bindingObjects.contains(iBindingObject)) continue;
                            bindingObjects.add(iBindingObject);
                        }
                    }
                    ++j;
                }
            }
            if (3 == node.getNodeType() && !DTRTUtil.isEmpty(text = node.getNodeValue())) {
                for (IBindingObject iBindingObject : pageDefinition.findBindingObjects(text)) {
                    if (bindingObjects.contains(iBindingObject)) continue;
                    bindingObjects.add(iBindingObject);
                }
            }
            if (!bindingObjects.isEmpty()) {
                return bindingObjects;
            }
        }
        return new ArrayList<IBindingObject>(0);
    }

    public static List<IPageDefinition.IBoundSource> findBoundSources(Collection<? extends IPageDefinition> pageDefinitions, IFile file) {
        if (pageDefinitions != null && !pageDefinitions.isEmpty() && file != null) {
            ArrayList<IPageDefinition.IBoundSource> boundSources = new ArrayList<IPageDefinition.IBoundSource>();
            for (IPageDefinition iPageDefinition : pageDefinitions) {
                if (!DTRTObjectUtil.isAccessible(iPageDefinition)) continue;
                for (IPageDefinition.IBoundSource iBoundSource : iPageDefinition.getBoundSources()) {
                    if (!file.equals((Object)iBoundSource.getFile()) || boundSources.contains(iBoundSource)) continue;
                    boundSources.add(iBoundSource);
                }
            }
            return boundSources;
        }
        return new ArrayList<IPageDefinition.IBoundSource>(0);
    }

    public static List<? extends IPageDefinition.IBoundSource> getBoundSources(IPageDefinition pageDefinition, IPageDefinition.IBoundSource.BoundSourceType boundSourceType) {
        if (pageDefinition != null && boundSourceType != null) {
            List<? extends IPageDefinition.IBoundSource> boundSources = pageDefinition.getBoundSources();
            ArrayList<IPageDefinition.IBoundSource> filteredBoundSources = new ArrayList<IPageDefinition.IBoundSource>(boundSources.size());
            for (IPageDefinition.IBoundSource iBoundSource : boundSources) {
                if (boundSourceType != iBoundSource.getType()) continue;
                filteredBoundSources.add(iBoundSource);
            }
            if (!filteredBoundSources.isEmpty()) {
                return Collections.unmodifiableList(filteredBoundSources);
            }
        }
        return Collections.emptyList();
    }

    public static Set<? extends IDataControlObject> findByLabel(IDataControlProvider dataControlProvider, IStringMatcher matcher, String searchString, IProgressMonitor monitor) throws InterruptedException {
        if (dataControlProvider != null) {
            ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)3);
            List<? extends IDataControl> dataControls = dataControlProvider.getDataControls(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
            ProgressMonitorUtil.checkIfCanceled((IProgressMonitor)monitor);
            Set<? extends IDataControlObject> dataControlObjects = DTRTObjectUtil.findByLabel(dataControls, matcher, searchString, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)2));
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
            return dataControlObjects;
        }
        return new HashSet(0);
    }

    public static Set<? extends IDataControlObject> findByLabel(Collection<? extends IDataControlObject> dataControlObjects, IStringMatcher matcher, String searchString, IProgressMonitor monitor) throws InterruptedException {
        if (dataControlObjects != null && !dataControlObjects.isEmpty() && searchString != null) {
            HashMap<URI, IDataControlObject> objectMap = new HashMap<URI, IDataControlObject>();
            if (matcher == null) {
                searchString = searchString.toLowerCase();
            }
            DTRTObjectUtil.findByLabel(new HashSet<Object>(), objectMap, dataControlObjects, matcher, searchString, monitor);
            if (!objectMap.isEmpty()) {
                return new HashSet(objectMap.values());
            }
        }
        return new HashSet(0);
    }

    private static void findByLabel(Set<Object> visitedObjects, Map<URI, IDataControlObject> objectMap, Collection<? extends IDataControlObject> dataControlObjects, IStringMatcher matcher, String searchString, IProgressMonitor monitor) throws InterruptedException {
        assert (matcher != null || searchString.toLowerCase().equals(searchString)) : searchString;
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)(dataControlObjects.size() * 3));
        for (IDataControlObject iDataControlObject : dataControlObjects) {
            String label;
            if (!DTRTObjectUtil.isAccessible(iDataControlObject) || !visitedObjects.add(DTRTObjectUtil.createVisitedObjectKey(iDataControlObject))) continue;
            if (!objectMap.containsKey(iDataControlObject.getURI()) && (label = DTRTUtil.getLabel(iDataControlObject)) != null && (matcher != null ? matcher.matches(searchString, label) : label.toLowerCase().indexOf(searchString) >= 0)) {
                IDataControlObject o = iDataControlObject;
                while (o != null && !objectMap.containsKey(o.getURI())) {
                    objectMap.put(o.getURI(), o);
                    o = o.getParent();
                }
            }
            ProgressMonitorUtil.checkIfCanceled((IProgressMonitor)monitor);
            ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
            List<? extends IDataControlChild> children = iDataControlObject.getChildren();
            if (children.isEmpty()) continue;
            DTRTObjectUtil.findByLabel(visitedObjects, objectMap, children, matcher, searchString, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)2));
        }
        ProgressMonitorUtil.done((IProgressMonitor)monitor);
    }

    public static List<? extends IDataControlChild> findDataControlChildrenById(IDataControlObject dataControlObject, String id) {
        if (DTRTObjectUtil.isAccessible(dataControlObject) && id != null) {
            LinkedHashSet<IDataControlChild> children = new LinkedHashSet<IDataControlChild>();
            DTRTObjectUtil.findDataControlChildrenById(new HashSet<Object>(), children, dataControlObject, id);
            if (!children.isEmpty()) {
                return Collections.unmodifiableList(new ArrayList<IDataControlChild>(children));
            }
        }
        return Collections.emptyList();
    }

    private static void findDataControlChildrenById(Set<Object> visitedObjects, Set<IDataControlChild> children, IDataControlObject dataControlObject, String id) {
        if (DTRTObjectUtil.isAccessible(dataControlObject) && visitedObjects.add(DTRTObjectUtil.createVisitedObjectKey(dataControlObject))) {
            if (dataControlObject instanceof IDataControlChild && ((IDataControlChild)dataControlObject).getStructureObject() != null && id.equals(dataControlObject.getId()) && !children.add((IDataControlChild)dataControlObject)) {
                return;
            }
            for (IDataControlChild iDataControlChild : dataControlObject.getChildren()) {
                DTRTObjectUtil.findDataControlChildrenById(visitedObjects, children, iDataControlChild, id);
            }
        }
    }

    private static Object createVisitedObjectKey(IDataControlObject dataControlObject) {
        ArrayList<Object> key = new ArrayList<Object>();
        key.add(dataControlObject.getTypeDescriptor() != null ? dataControlObject.getTypeDescriptor().getLabel() : "null");
        key.add(DTRTUtil.getLabel(dataControlObject));
        int counter = 0;
        IDataControlObject parent = dataControlObject;
        do {
            if ((parent = parent.getParent()) != null) {
                key.add(parent.getTypeDescriptor() != null ? parent.getTypeDescriptor().getLabel() : "null");
                key.add(DTRTUtil.getLabel(parent));
                continue;
            }
            key.add("null");
            key.add("null");
        } while (++counter < 10 && parent instanceof IDataControlChild && ((IDataControlChild)parent).getStructureObject() == null);
        IDataControl dataControl = DTRTObjectUtil.getDataControl(dataControlObject);
        assert (dataControl != null) : dataControlObject;
        key.add(dataControl.getURI());
        return key;
    }

    public static IObject getRootObject(IObject object) {
        if (DTRTObjectUtil.isAccessible(object)) {
            while (true) {
                if (object.getParent() == null) {
                    return object;
                }
                object = object.getParent();
            }
        }
        return null;
    }

    public static IDataControl getDataControl(IDataControlObject object) {
        if (object instanceof IDataControl) {
            return (IDataControl)object;
        }
        IObject root = DTRTObjectUtil.getRootObject(object);
        if (root instanceof IDataControl) {
            return (IDataControl)root;
        }
        return null;
    }

    public static IStructure getStructure(IStructureObject object) {
        if (object instanceof IStructure) {
            return (IStructure)object;
        }
        IObject root = DTRTObjectUtil.getRootObject(object);
        if (root instanceof IStructure) {
            return (IStructure)root;
        }
        return null;
    }

    public static IBindingObject getFirstBindingObject(IOEPEContext context, IFile nodeFile, Node node) {
        BindingObjectUsageManager usageManager;
        if (context != null && nodeFile != null && node != null && (usageManager = BindingObjectUsageManager.create(context)) != null) {
            IBindingObject bindingObject = null;
            for (IPageDefinition.IBoundSource iBoundSource : BindingObjectUsageManager.getBoundSources(usageManager, nodeFile, node)) {
                List<? extends BindingObjectUsageManager.Usage> usages = usageManager.getUsages(iBoundSource, node);
                if (usages.isEmpty()) continue;
                bindingObject = usages.get(0).getBindingObject();
                break;
            }
            usageManager.dispose();
            return bindingObject;
        }
        return null;
    }

    public static boolean isAccessible(IObject object) {
        return object != null && !object.isDisposed() && !object.isDeleted();
    }

    public static boolean isAncestor(IDataControlObject ancestor, IDataControlObject dataControlObject) {
        if (ancestor != null) {
            while (dataControlObject != null) {
                if (DTRTUtil.equals(ancestor, dataControlObject)) {
                    return true;
                }
                dataControlObject = dataControlObject.getParent();
            }
        }
        return false;
    }

    public static boolean isAncestor(IStructureObject ancestor, IStructureObject structureObject) {
        if (ancestor != null) {
            while (structureObject != null) {
                if (DTRTUtil.equals(ancestor, structureObject)) {
                    return true;
                }
                structureObject = structureObject.getParent();
            }
        }
        return false;
    }

    public static String computeEL(boolean deferred, IBindingObject bindingObject, Collection<? extends IELProperty> properties) {
        String id;
        if (DTRTObjectUtil.isAccessible(bindingObject) && (id = bindingObject.getId()) != null) {
            StringBuilder sb = new StringBuilder(deferred ? "#{" : "${").append("bindings.").append(id);
            if (properties != null) {
                for (IELProperty iELProperty : properties) {
                    sb.append('.').append(iELProperty.getId());
                }
            }
            return sb.append('}').toString();
        }
        return null;
    }

    public static String getELMetadataType(IBindingObject bindingObject) {
        IELMetadata metadata;
        if (bindingObject != null && (metadata = bindingObject.getELMetadata()) != null) {
            String type = metadata.getType();
            if (type == null && (type = bindingObject.getBindType()) == null) {
                type = bindingObject.getClass().getName();
            }
            return type;
        }
        return null;
    }

    public static String[] getParameterTypes(IELMethod elMethod) {
        List<? extends IELType> types = elMethod.getParameterELTypes();
        String[] parameterTypes = new String[types.size()];
        int i = 0;
        while (i < parameterTypes.length) {
            parameterTypes[i] = types.get(i).getType();
            ++i;
        }
        return parameterTypes;
    }

    public static List<? extends IDataControl> getDataControls(IDataControlProvider provider) {
        if (provider != null) {
            try {
                return provider.getDataControls(null);
            }
            catch (InterruptedException interruptedException) {}
        }
        return Collections.emptyList();
    }

    public static IResource getResource(IStructure.IStructureSource source) {
        return source != null ? source.getResource() : null;
    }

    public static IFile getFile(IStructure.IStructureSource source) {
        IResource resource = DTRTObjectUtil.getResource(source);
        return resource instanceof IFile ? (IFile)resource : null;
    }

    public static interface IStringMatcher {
        public boolean matches(String var1, String var2);
    }
}

