/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.util;

import oracle.eclipse.tools.adf.dtrt.util.BaseDescriptor;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.dtrt.util.IDisposable;

public abstract class BaseDescribable
implements IDescribable,
IDisposable {
    private BaseDescriptor descriptor;

    @Override
    public void dispose() {
        this.descriptor = null;
    }

    @Override
    public final BaseDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = this.createDescriptor();
        }
        if (this.descriptor != null && this.descriptor.getLabel() == null) {
            throw new IllegalStateException("The descriptor's label cannot be null");
        }
        return this.descriptor;
    }

    protected abstract BaseDescriptor createDescriptor();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    protected final int objectHashCode() {
        return super.hashCode();
    }

    protected final int baseHashCode() {
        int result = 1;
        result = 31 * result + (this.getDescriptor() == null ? 0 : this.getDescriptor().hashCode());
        return result;
    }

    protected final boolean baseEquals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BaseDescribable other = (BaseDescribable)obj;
        return DTRTUtil.equals(this.getDescriptor(), other.getDescriptor());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
        builder.append("[label=");
        builder.append(DTRTUtil.getLabel(this.getDescriptor()));
        builder.append("]");
        return builder.toString();
    }
}

