/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.usage;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.adf.dtrt.object.IPageDefinition;
import oracle.eclipse.tools.adf.dtrt.usage.BindingObjectUsageManager;
import oracle.eclipse.tools.adf.dtrt.usage.SSEDocumentProvider;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.MatchingResourceChangeListener;
import oracle.eclipse.tools.adf.dtrt.util.SSEUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;

public class FileMonitoringProvider
extends SSEDocumentProvider {
    private MatchingResourceChangeListener<IFile> matchingResourceChangeListener = new MatchingResourceChangeListener<IFile>(){

        @Override
        public Collection<? extends IFile> getResourcesToMatch() {
            return FileMonitoringProvider.this.usageManagersByFile.keySet();
        }

        @Override
        protected boolean isMatchingDelta(IResourceDelta delta) {
            return this.isFileChangeDelta(delta, true);
        }

        @Override
        public void matchedResources(Set<IFile> resources) {
            FileMonitoringProvider.this.resetUsageManagers(resources);
        }
    };

    @Override
    protected IDOMModel getDOMModel(IFile xmlFile) throws Exception {
        IStructuredModel model = StructuredModelManager.getModelManager().getModelForRead(xmlFile);
        return model instanceof IDOMModel ? (IDOMModel)model : null;
    }

    @Override
    protected void monitor(BindingObjectUsageManager usageManager, IFile xmlFile, IDOMModel model) {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.matchingResourceChangeListener, 1);
    }

    @Override
    protected void stopMonitoring(IFile xmlFile, boolean userManagerDisposed) {
        if (this.usageManagersByFile.isEmpty()) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.matchingResourceChangeListener);
        }
    }

    @Override
    public BindingObjectUsageManager.INodeProxy createNodeProxy(BindingObjectUsageManager usageManager, IPageDefinition.IBoundSource boundSource, Node node) {
        return NodeProxy.createNodeProxy(boundSource, node);
    }

    private void resetUsageManagers(Collection<IFile> files) {
        HashSet<BindingObjectUsageManager> resetUsageManagers = new HashSet<BindingObjectUsageManager>(files.size());
        for (IFile file : files) {
            for (BindingObjectUsageManager usageManager : (Set)this.usageManagersByFile.get(file)) {
                if (!resetUsageManagers.add(usageManager)) continue;
                usageManager.reset();
            }
        }
    }

    private static final class NodeProxy
    implements BindingObjectUsageManager.INodeProxy {
        private IPageDefinition.IBoundSource boundSource;
        private String label;
        private int startPosition;
        private int endPosition;
        private int startLine;
        private int endLine;
        private String toString;

        private static NodeProxy createNodeProxy(IPageDefinition.IBoundSource boundSource, Node node) {
            IDOMNode domNode = (IDOMNode)node;
            int[] lines = SSEUtil.computeLineNumbers(domNode);
            if (lines != null) {
                return new NodeProxy(boundSource, FileMonitoringProvider.getNodeProxyLabel((Node)domNode), domNode.getStartOffset(), domNode.getEndOffset(), lines[0], lines[1]);
            }
            return null;
        }

        private NodeProxy(IPageDefinition.IBoundSource boundSource, String label, int startPosition, int endPosition, int startLine, int endLine) {
            assert (boundSource != null);
            assert (label != null);
            assert (startPosition >= 0);
            assert (endPosition > startPosition);
            this.boundSource = boundSource;
            this.label = label;
            this.startPosition = startPosition;
            this.endPosition = endPosition;
            this.startLine = startLine;
            this.endLine = endLine;
        }

        @Override
        public void dipose() {
            this.boundSource = null;
            this.label = null;
            this.startPosition = -1;
            this.endPosition = -1;
            this.startLine = -1;
            this.endLine = -1;
        }

        @Override
        public boolean isDisposed() {
            return this.boundSource == null;
        }

        @Override
        public IPageDefinition.IBoundSource getBoundSource() {
            return this.boundSource;
        }

        @Override
        public boolean represents(Node node) {
            return node instanceof IDOMNode && this.equals(NodeProxy.createNodeProxy(this.getBoundSource(), node));
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public int getStartPosition() {
            return this.startPosition;
        }

        @Override
        public int getEndPosition() {
            return this.endPosition;
        }

        @Override
        public int getStartLine() {
            return this.startLine;
        }

        @Override
        public int getEndLine() {
            return this.endLine;
        }

        @Override
        public int hashCode() {
            if (!this.isDisposed()) {
                int result = 1;
                result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
                result = 31 * result + (this.boundSource == null ? 0 : this.boundSource.hashCode());
                result = 31 * result + this.startPosition;
                result = 31 * result + this.endPosition;
                return result;
            }
            return super.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (!this.isDisposed()) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof NodeProxy)) {
                    return false;
                }
                NodeProxy other = (NodeProxy)obj;
                return this.startPosition == other.startPosition && this.endPosition == other.endPosition && DTRTUtil.equals(this.label, other.label) && DTRTUtil.equals(this.boundSource, other.boundSource);
            }
            return super.equals(obj);
        }

        @Override
        public String toString() {
            if (!this.isDisposed()) {
                if (this.toString == null) {
                    this.toString = BindingObjectUsageManager.toString(this);
                }
                return this.toString;
            }
            return super.toString();
        }
    }
}

