/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.usage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.adf.dtrt.command.ICommand;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEContext;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEExecutableContext;
import oracle.eclipse.tools.adf.dtrt.context.command.ISetCommand;
import oracle.eclipse.tools.adf.dtrt.context.typed.IPageDefinitionContext;
import oracle.eclipse.tools.adf.dtrt.context.typed.ITaskFlowContext;
import oracle.eclipse.tools.adf.dtrt.context.typed.IWebPageContext;
import oracle.eclipse.tools.adf.dtrt.internal.DTRTBundle;
import oracle.eclipse.tools.adf.dtrt.object.IBindingObject;
import oracle.eclipse.tools.adf.dtrt.object.IPageDefinition;
import oracle.eclipse.tools.adf.dtrt.usage.FileMonitoringProvider;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.ExecutableContextAdapter;
import oracle.eclipse.tools.adf.dtrt.util.ObjectList;
import oracle.eclipse.tools.adf.dtrt.util.TypedListenerList;
import org.eclipse.core.resources.IFile;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class BindingObjectUsageManager {
    private IOEPEContext context;
    private IOEPEExecutableContext.IExecutableContextListener contextListener;
    private IBoundSourceDocumentProvider documentProvider;
    private Map<IPageDefinition.IBoundSource, ObjectList<Usage>> boundSourceUsageMap;
    private Map<IBindingObject, ObjectList<Usage>> bindingObjectUsageMap;
    private TypedListenerList<IResetListener> resetListeners;
    private boolean reseting;

    public static BindingObjectUsageManager create(IOEPEContext context) {
        return context instanceof IPageDefinitionContext ? new BindingObjectUsageManager((IPageDefinitionContext)context) : (context instanceof IWebPageContext ? new BindingObjectUsageManager((IWebPageContext)context) : (context instanceof ITaskFlowContext ? new BindingObjectUsageManager((ITaskFlowContext)context) : null));
    }

    public static List<? extends IPageDefinition.IBoundSource> getBoundSources(BindingObjectUsageManager usageManager, IFile boundSourceFile, Node boundSourceNode) {
        if (usageManager != null && boundSourceFile != null) {
            ArrayList<IPageDefinition.IBoundSource> list = new ArrayList<IPageDefinition.IBoundSource>();
            for (IPageDefinition iPageDefinition : usageManager.getPageDefinitions()) {
                for (IPageDefinition.IBoundSource iBoundSource : iPageDefinition.getBoundSources()) {
                    if (!boundSourceFile.equals((Object)iBoundSource.getFile()) || boundSourceNode != null && !iBoundSource.appliesTo(boundSourceNode).isOK()) continue;
                    list.add(iBoundSource);
                }
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public static Map<IFile, List<Usage>> toUsageByFile(List<? extends Usage> usages) {
        if (usages != null && !usages.isEmpty()) {
            LinkedHashMap<IFile, List<Usage>> map = new LinkedHashMap<IFile, List<Usage>>();
            for (Usage usage : usages) {
                ArrayList<Usage> list = (ArrayList<Usage>)map.get(usage.getBoundSource().getFile());
                if (list == null) {
                    list = new ArrayList<Usage>();
                    map.put(usage.getBoundSource().getFile(), list);
                }
                list.add(usage);
            }
            return map;
        }
        return new HashMap<IFile, List<Usage>>(0);
    }

    public static Map<IBindingObject, List<Usage>> toUsageByBindingObject(List<? extends Usage> usages) {
        if (usages != null && !usages.isEmpty()) {
            LinkedHashMap<IBindingObject, List<Usage>> map = new LinkedHashMap<IBindingObject, List<Usage>>();
            for (Usage usage : usages) {
                ArrayList<Usage> list = (ArrayList<Usage>)map.get(usage.getBindingObject());
                if (list == null) {
                    list = new ArrayList<Usage>();
                    map.put(usage.getBindingObject(), list);
                }
                list.add(usage);
            }
            return map;
        }
        return new HashMap<IBindingObject, List<Usage>>(0);
    }

    public static String toString(INodeProxy nodeProxy) {
        return nodeProxy == null ? "<null>" : (nodeProxy.getStartLine() > 1 && nodeProxy.getEndLine() == nodeProxy.getStartLine() ? NLS.bind((String)Messages.nodeProxyLineLabel, (Object[])new Object[]{nodeProxy.getLabel(), nodeProxy.getStartLine()}) : (nodeProxy.getStartLine() > 1 && nodeProxy.getEndLine() > nodeProxy.getStartLine() ? NLS.bind((String)Messages.nodeProxyLinesLabel, (Object[])new Object[]{nodeProxy.getLabel(), nodeProxy.getStartLine(), nodeProxy.getEndLine()}) : NLS.bind((String)Messages.nodeProxyLabel, (Object[])new Object[]{nodeProxy.getLabel(), nodeProxy.getStartPosition(), nodeProxy.getEndPosition()})));
    }

    private BindingObjectUsageManager(IOEPEExecutableContext context) {
        assert (context != null);
        this.context = context;
        this.contextListener = new ExecutableContextAdapter(){

            @Override
            public void handleCommandOperation(IOEPEExecutableContext context, ICommand command) {
                if (!(command instanceof ISetCommand) && !BindingObjectUsageManager.this.isDisposed()) {
                    BindingObjectUsageManager.this.reset();
                }
            }

            @Override
            public void handleReset(IOEPEContext context) {
                if (!BindingObjectUsageManager.this.isDisposed()) {
                    BindingObjectUsageManager.this.reset();
                }
            }
        };
        context.addListener(this.contextListener);
        this.resetListeners = new TypedListenerList();
    }

    public BindingObjectUsageManager(IWebPageContext context) {
        this((IOEPEExecutableContext)context);
    }

    public BindingObjectUsageManager(IPageDefinitionContext context) {
        this((IOEPEExecutableContext)context);
    }

    public BindingObjectUsageManager(ITaskFlowContext context) {
        this((IOEPEExecutableContext)context);
    }

    public void dispose() {
        if (this.contextListener != null) {
            assert (this.context != null);
            this.context.removeListener(this.contextListener);
            this.contextListener = null;
        }
        if (this.resetListeners != null) {
            this.resetListeners.clear();
            this.resetListeners = null;
        }
        if (this.documentProvider != null) {
            this.documentProvider.usageManagerDisposed(this);
            this.documentProvider = null;
        }
        this.reset();
        this.context = null;
    }

    public IOEPEContext getContext() {
        return this.context;
    }

    public void setBoundSourceDocumentProvider(IBoundSourceDocumentProvider documentProvider) {
        if (documentProvider == null) {
            throw new IllegalArgumentException("Document provider cannot be null");
        }
        this.documentProvider = documentProvider;
    }

    public IBoundSourceDocumentProvider getBoundSourceDocumentProvider() {
        if (this.documentProvider == null) {
            this.setBoundSourceDocumentProvider(new FileMonitoringProvider());
        }
        return this.documentProvider;
    }

    public List<? extends IPageDefinition> getPageDefinitions() {
        if (this.context instanceof ITaskFlowContext) {
            return ((ITaskFlowContext)this.context).getPageDefinitions();
        }
        IPageDefinition pageDefinition = this.context instanceof IWebPageContext ? ((IWebPageContext)this.context).getPageDefinition() : ((IPageDefinitionContext)this.context).getPageDefinition();
        return pageDefinition == null ? Collections.emptyList() : Collections.singletonList(pageDefinition);
    }

    public boolean isDisposed() {
        return this.context == null;
    }

    public void addResetListener(IResetListener listener) {
        this.resetListeners.add(listener);
    }

    public void removeResetListener(IResetListener listener) {
        this.resetListeners.remove(listener);
    }

    public synchronized void reset() {
        if (!this.reseting) {
            this.reseting = true;
            try {
                this.doReset();
            }
            finally {
                this.reseting = false;
            }
        }
    }

    private synchronized void doReset() {
        this.reseting = true;
        if (this.boundSourceUsageMap != null) {
            for (List list : this.boundSourceUsageMap.values()) {
                for (Usage usage : list) {
                    usage.dispose();
                }
            }
            this.boundSourceUsageMap.clear();
            this.boundSourceUsageMap = null;
        }
        if (this.bindingObjectUsageMap != null) {
            this.bindingObjectUsageMap.clear();
            this.bindingObjectUsageMap = null;
        }
        if (this.documentProvider != null) {
            this.documentProvider.usageManagerReset(this);
        }
        if (this.resetListeners != null) {
            for (IResetListener iResetListener : this.resetListeners) {
                try {
                    iResetListener.handleReset(this);
                }
                catch (Exception e) {
                    DTRTBundle.log(e);
                }
            }
        }
    }

    public synchronized List<? extends Usage> getUsages(IFile boundSourceFile) {
        List<IPageDefinition.IBoundSource> boundSources;
        if (DTRTUtil.isNotDisposed(this.context) && !(boundSources = DTRTObjectUtil.findBoundSources(this.getPageDefinitions(), boundSourceFile)).isEmpty()) {
            this.initializeUsageMaps();
            if (this.boundSourceUsageMap != null) {
                ObjectList usages = new ObjectList();
                for (IPageDefinition.IBoundSource boundSource : boundSources) {
                    ObjectList<Usage> boundSourceUsages = this.boundSourceUsageMap.get(boundSource);
                    if (boundSourceUsages == null) continue;
                    if (boundSources.size() == 1) {
                        return boundSourceUsages.getUnmodifiableView();
                    }
                    usages.addAll(boundSourceUsages);
                }
                if (!usages.isEmpty()) {
                    return usages.getUnmodifiableView();
                }
            }
        }
        return Collections.emptyList();
    }

    public synchronized List<? extends Usage> getUsages(IPageDefinition.IBoundSource boundSource) {
        if (DTRTUtil.isNotDisposed(this.context) && boundSource != null) {
            ObjectList<Usage> boundSourceUsages;
            this.initializeUsageMaps();
            if (this.boundSourceUsageMap != null && (boundSourceUsages = this.boundSourceUsageMap.get(boundSource)) != null) {
                return boundSourceUsages.getUnmodifiableView();
            }
        }
        return Collections.emptyList();
    }

    public synchronized List<? extends Usage> getUsages(IBindingObject bindingObject) {
        if (bindingObject != null && DTRTUtil.isNotDisposed(this.context) && this.getPageDefinitions().contains(DTRTObjectUtil.getRootObject(bindingObject))) {
            ObjectList<Usage> usages;
            this.initializeUsageMaps();
            if (this.bindingObjectUsageMap != null && (usages = this.bindingObjectUsageMap.get(bindingObject)) != null) {
                return usages.getUnmodifiableView();
            }
        }
        return Collections.emptyList();
    }

    public synchronized List<? extends Usage> getUsages(IPageDefinition.IBoundSource boundSource, Node node) {
        List<? extends Usage> xmlFileUsages;
        if (boundSource != null && node != null && !(xmlFileUsages = this.getUsages(boundSource.getFile())).isEmpty()) {
            ArrayList<Usage> nodeProxyUsages = new ArrayList<Usage>(xmlFileUsages.size());
            block0: for (Usage usage : xmlFileUsages) {
                if (nodeProxyUsages.contains(usage)) continue;
                for (INodeProxy proxy : usage.getNodeProxies()) {
                    if (!proxy.represents(node)) continue;
                    nodeProxyUsages.add(usage);
                    continue block0;
                }
            }
            if (!nodeProxyUsages.isEmpty()) {
                return Collections.unmodifiableList(nodeProxyUsages);
            }
        }
        return Collections.emptyList();
    }

    private void initializeUsageMaps() {
        List<? extends IPageDefinition> currentPageDefinitions = this.getPageDefinitions();
        if (this.context.isDisposed() || currentPageDefinitions.isEmpty()) {
            if (this.boundSourceUsageMap != null && this.bindingObjectUsageMap != null) {
                this.reset();
            }
            return;
        }
        if (this.boundSourceUsageMap != null && this.bindingObjectUsageMap != null) {
            return;
        }
        for (IPageDefinition iPageDefinition : currentPageDefinitions) {
            List<? extends IBindingObject> bindingObjects;
            if (iPageDefinition.getBoundSources().isEmpty() || (bindingObjects = DTRTObjectUtil.getBindingObjects(iPageDefinition)).isEmpty()) continue;
            HashMap<IPageDefinition.IBoundSource, ObjectList<Usage>> boundSourceUsageMap = new HashMap<IPageDefinition.IBoundSource, ObjectList<Usage>>(iPageDefinition.getBoundSources().size());
            HashMap<IBindingObject, ObjectList<Usage>> bindingObjectUsageMap = new HashMap<IBindingObject, ObjectList<Usage>>(bindingObjects.size());
            for (IPageDefinition.IBoundSource iBoundSource : iPageDefinition.getBoundSources()) {
                Document document;
                if (!iBoundSource.getFile().isAccessible()) continue;
                try {
                    document = this.getBoundSourceDocumentProvider().loadDocument(this, iBoundSource.getFile());
                }
                catch (Exception e) {
                    DTRTBundle.log(e);
                    document = null;
                }
                if (document == null || document.getDocumentElement() == null) continue;
                this.collectUsage(boundSourceUsageMap, bindingObjectUsageMap, iBoundSource, document, iPageDefinition);
                try {
                    this.getBoundSourceDocumentProvider().nodeProxiesCreated(this, iBoundSource.getFile(), document);
                }
                catch (Exception exception) {}
            }
            if (boundSourceUsageMap.isEmpty()) continue;
            this.boundSourceUsageMap = boundSourceUsageMap;
            this.bindingObjectUsageMap = bindingObjectUsageMap;
        }
    }

    private void collectUsage(Map<IPageDefinition.IBoundSource, ObjectList<Usage>> boundSourceUsageMap, Map<IBindingObject, ObjectList<Usage>> bindingObjectUsageMap, IPageDefinition.IBoundSource boundSource, Document document, IPageDefinition pageDefinition) {
        Map<Node, List<? extends IBindingObject>> map = boundSource.collectUsedBindingObjects(pageDefinition, document);
        if (!map.isEmpty()) {
            for (Map.Entry<Node, List<? extends IBindingObject>> entry : map.entrySet()) {
                INodeProxy nodeProxy = this.getBoundSourceDocumentProvider().createNodeProxy(this, boundSource, entry.getKey());
                if (nodeProxy == null) continue;
                this.collectUsage(boundSourceUsageMap, bindingObjectUsageMap, boundSource, nodeProxy, entry.getValue());
            }
        }
    }

    private void collectUsage(Map<IPageDefinition.IBoundSource, ObjectList<Usage>> boundSourceUsageMap, Map<IBindingObject, ObjectList<Usage>> bindingObjectUsageMap, IPageDefinition.IBoundSource boundSource, INodeProxy nodeProxy, List<? extends IBindingObject> bindingObjects) {
        for (IBindingObject iBindingObject : bindingObjects) {
            ObjectList<Usage> usages = bindingObjectUsageMap.get(iBindingObject);
            if (usages == null) {
                usages = new ObjectList();
                bindingObjectUsageMap.put(iBindingObject, usages);
            }
            Usage usage = null;
            for (Usage u : usages) {
                if (!boundSource.equals(u.getBoundSource())) continue;
                usage = u;
                break;
            }
            if (usage == null) {
                usage = new Usage(boundSource, iBindingObject);
                usages.add(usage);
                ObjectList<Usage> fileUsages = boundSourceUsageMap.get(boundSource);
                if (fileUsages == null) {
                    fileUsages = new ObjectList();
                    boundSourceUsageMap.put(boundSource, fileUsages);
                }
                fileUsages.add(usage);
            }
            if (usage.nodeProxies.contains(nodeProxy)) continue;
            usage.nodeProxies.add(nodeProxy);
        }
    }

    public static interface IBoundSourceDocumentProvider {
        public void usageManagerDisposed(BindingObjectUsageManager var1);

        public void usageManagerReset(BindingObjectUsageManager var1);

        public Document loadDocument(BindingObjectUsageManager var1, IFile var2) throws Exception;

        public void nodeProxiesCreated(BindingObjectUsageManager var1, IFile var2, Document var3) throws Exception;

        public INodeProxy createNodeProxy(BindingObjectUsageManager var1, IPageDefinition.IBoundSource var2, Node var3);
    }

    public static interface INodeProxy {
        public void dipose();

        public boolean isDisposed();

        public IPageDefinition.IBoundSource getBoundSource();

        public boolean represents(Node var1);

        public String getLabel();

        public int getStartPosition();

        public int getEndPosition();

        public int getStartLine();

        public int getEndLine();

        public int hashCode();

        public boolean equals(Object var1);

        public String toString();
    }

    public static interface IResetListener {
        public void handleReset(BindingObjectUsageManager var1);
    }

    private static class Messages
    extends NLS {
        public static String nodeProxyLabel;
        public static String nodeProxyLineLabel;
        public static String nodeProxyLinesLabel;

        static {
            NLS.initializeMessages((String)BindingObjectUsageManager.class.getName(), Messages.class);
        }

        private Messages() {
        }
    }

    public static final class Usage {
        private IPageDefinition.IBoundSource boundSource;
        private IBindingObject bindingObject;
        private ObjectList<INodeProxy> nodeProxies;

        private Usage(IPageDefinition.IBoundSource boundSource, IBindingObject bindingObject) {
            assert (boundSource != null);
            assert (boundSource.getFile().isAccessible());
            assert (bindingObject != null);
            assert (!bindingObject.isDisposed());
            assert (!bindingObject.isDeleted());
            this.boundSource = boundSource;
            this.bindingObject = bindingObject;
            this.nodeProxies = new ObjectList();
        }

        private void dispose() {
            this.boundSource = null;
            this.bindingObject = null;
            if (this.nodeProxies != null) {
                for (INodeProxy nodeProxy : this.nodeProxies) {
                    nodeProxy.dipose();
                }
                this.nodeProxies.clear();
                this.nodeProxies = null;
            }
        }

        public boolean isDisposed() {
            return this.boundSource == null;
        }

        public IPageDefinition.IBoundSource getBoundSource() {
            return this.boundSource;
        }

        public IBindingObject getBindingObject() {
            return this.bindingObject;
        }

        public List<INodeProxy> getNodeProxies() {
            return this.nodeProxies.getUnmodifiableView();
        }

        public int hashCode() {
            if (!this.isDisposed()) {
                int result = 1;
                result = 31 * result + (this.bindingObject == null ? 0 : this.bindingObject.hashCode());
                result = 31 * result + (this.boundSource == null ? 0 : this.boundSource.hashCode());
                return result;
            }
            return super.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Usage)) {
                return false;
            }
            if (!this.isDisposed()) {
                Usage other = (Usage)obj;
                return DTRTUtil.equals(this.boundSource, other.boundSource) && DTRTUtil.equals(this.bindingObject, other.bindingObject);
            }
            return super.equals(obj);
        }
    }
}

