/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.locator;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEContext;
import oracle.eclipse.tools.adf.dtrt.context.typed.ITaskFlowContext;
import oracle.eclipse.tools.adf.dtrt.locator.IObjectLocator;
import oracle.eclipse.tools.adf.dtrt.object.IApplication;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IPageDefinition;
import oracle.eclipse.tools.adf.dtrt.object.IStructure;
import oracle.eclipse.tools.adf.dtrt.util.IFileMarker;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public final class SynchronizedObjectLocator
implements IObjectLocator {
    private IObjectLocator objectLocator;

    public SynchronizedObjectLocator(IObjectLocator objectLocator) {
        if (objectLocator == null || objectLocator.isDisposed()) {
            throw new IllegalArgumentException("The objectLocator can be neither null nor disposed");
        }
        this.objectLocator = objectLocator;
    }

    @Override
    public synchronized void dispose() {
        if (this.objectLocator != null) {
            this.objectLocator.dispose();
            this.objectLocator = null;
        }
    }

    @Override
    public synchronized boolean isDisposed() {
        assert (this.objectLocator == null || !this.objectLocator.isDisposed()) : this.objectLocator;
        return this.objectLocator == null;
    }

    @Override
    public synchronized void addListener(IOEPEContext.IContextListener listener) {
        this.objectLocator.addListener(listener);
    }

    @Override
    public synchronized void removeListener(IOEPEContext.IContextListener listener) {
        this.objectLocator.removeListener(listener);
    }

    @Override
    public synchronized boolean isKnown(IObject object) {
        return this.objectLocator.isKnown(object);
    }

    @Override
    public synchronized IFile getAccessibleFile(IObject object) throws IllegalArgumentException {
        return this.objectLocator.getAccessibleFile(object);
    }

    @Override
    public synchronized List<? extends IFileMarker> getAccessibleDeclarations(IObject object) throws IllegalArgumentException {
        return this.objectLocator.getAccessibleDeclarations(object);
    }

    @Override
    public synchronized IProject getCachedEARProject(IProject project) {
        return this.objectLocator.getCachedEARProject(project);
    }

    @Override
    public synchronized List<? extends IPageDefinition> getPageDefinitions(IProject assemblyProject, IContainer container) {
        return this.objectLocator.getPageDefinitions(assemblyProject, container);
    }

    @Override
    public synchronized IPageDefinition getPageDefinition(IProject assemblyProject, IFile pageDefinitionFile) {
        return this.objectLocator.getPageDefinition(assemblyProject, pageDefinitionFile);
    }

    @Override
    public synchronized IPageDefinition getPageDefinitionForWebPage(IProject assemblyProject, IFile viewPageFile) {
        return this.objectLocator.getPageDefinitionForWebPage(assemblyProject, viewPageFile);
    }

    @Override
    public synchronized List<? extends IPageDefinition> getPageDefinitions(IProject assemblyProject, ITaskFlowContext.ITaskFlowProxy taskFlow) {
        return this.objectLocator.getPageDefinitions(assemblyProject, taskFlow);
    }

    @Override
    public synchronized IPageDefinition getPageDefinitionForTaskFlowActivity(IProject assemblyProject, ITaskFlowContext.ITaskFlowProxy taskFlow, Object activity) {
        return this.objectLocator.getPageDefinitionForTaskFlowActivity(assemblyProject, taskFlow, activity);
    }

    @Override
    public synchronized Map<IApplication, List<IPageDefinition.IBoundSource>> getApplications(IPageDefinition pageDefinition) {
        return this.objectLocator.getApplications(pageDefinition);
    }

    @Override
    public synchronized IApplication getApplication(IProject assemblyProject, IFile applicationFile) {
        return this.objectLocator.getApplication(assemblyProject, applicationFile);
    }

    @Override
    public synchronized List<? extends IApplication> getApplications(IProject assemblyProject, IContainer container) {
        return this.objectLocator.getApplications(assemblyProject, container);
    }

    @Override
    public synchronized Collection<? extends IPageDefinition> getPageDefinitions(IApplication application) {
        return this.objectLocator.getPageDefinitions(application);
    }

    @Override
    public synchronized boolean hasUpdateableStructure(IStructure.IStructureSource source) {
        return this.objectLocator.hasUpdateableStructure(source);
    }

    @Override
    public synchronized boolean hasUpdateableStructure(IProject assemblyProject, IStructure.IStructureSource source) {
        return this.objectLocator.hasUpdateableStructure(assemblyProject, source);
    }

    @Override
    public synchronized IStatus validate(IObject object, IProgressMonitor monitor) {
        return this.objectLocator.validate(object, monitor);
    }
}

