/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.jdt;

import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.adf.dtrt.jdt.AnnotationMemberValue;
import oracle.eclipse.tools.adf.dtrt.jdt.BasicTypeHelper;
import oracle.eclipse.tools.adf.dtrt.jdt.CacheKey;
import oracle.eclipse.tools.adf.dtrt.jdt.IMemberFilter;
import oracle.eclipse.tools.adf.dtrt.jdt.ITypeHelperClient;
import oracle.eclipse.tools.adf.dtrt.jdt.TypeInfo;
import oracle.eclipse.tools.adf.dtrt.util.LRUMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.dom.CompilationUnit;

final class SimpleCacheTypeHelper
extends BasicTypeHelper {
    private Map<CacheKey, Object> cache = new LRUMap<CacheKey, Object>(100, 1000, 100);
    private ITypeHelperClient client;

    public SimpleCacheTypeHelper() {
    }

    public SimpleCacheTypeHelper(ITypeHelperClient client) {
        this.client = client;
    }

    @Override
    public boolean reset() {
        if (!this.cache.isEmpty()) {
            this.cache.clear();
            return true;
        }
        return false;
    }

    @Override
    public boolean reset(IType type) {
        return type != null && this.reset(this.cache.keySet(), type);
    }

    private Object getCachedValue(CacheKey key) {
        Object value = this.cache.get(key);
        if (value instanceof SoftReference) {
            value = ((SoftReference)value).get();
        }
        if (value == null) {
            this.cache.remove(key);
        }
        return value;
    }

    private <T> T cacheValue(CacheKey key, boolean asSoftReference, T value) {
        if (value != null) {
            IType type;
            IJavaElement javaElement;
            if (asSoftReference) {
                this.cache.put(key, new SoftReference<T>(value));
            } else {
                this.cache.put(key, value);
            }
            if (this.client != null && (javaElement = key.getJavaElement()) != null && (type = this.getCacheKeyType(javaElement)) != null) {
                this.client.handleCachedJavaElement(this, type, javaElement);
            }
        }
        return value;
    }

    public void dispose() {
        this.reset();
        this.cache = null;
        this.client = null;
    }

    @Override
    public IType findType(IJavaProject javaProject, String className) throws CoreException {
        if (javaProject != null && className != null) {
            CacheKey key = new CacheKey("findType", (IJavaElement)javaProject, new Object[]{className});
            Object value = this.getCachedValue(key);
            return value instanceof IType ? (IType)value : this.cacheValue(key, false, super.findType(javaProject, className));
        }
        return null;
    }

    @Override
    public ICompilationUnit getCompilationUnit(IFile javaFile, boolean workingCopy) throws CoreException {
        if (javaFile != null) {
            CacheKey key;
            Object value;
            if (workingCopy) {
                super.getCompilationUnit(javaFile, workingCopy);
            }
            return (value = this.getCachedValue(key = new CacheKey("getCompilationUnit", javaFile))) instanceof ICompilationUnit ? (ICompilationUnit)value : this.cacheValue(key, false, super.getCompilationUnit(javaFile, workingCopy));
        }
        return null;
    }

    @Override
    public IType findType(ICompilationUnit compilationUnit, String name) throws CoreException {
        if (compilationUnit != null && name != null) {
            CacheKey key = new CacheKey("findType", (IJavaElement)compilationUnit, new Object[]{name});
            Object value = this.getCachedValue(key);
            return value instanceof IType ? (IType)value : this.cacheValue(key, false, super.findType(compilationUnit, name));
        }
        return null;
    }

    @Override
    public TypeInfo getTypeInfo(IType type) throws CoreException {
        if (type != null) {
            CacheKey key = new CacheKey("getTypeInfo", (IJavaElement)type);
            Object value = this.getCachedValue(key);
            return value instanceof TypeInfo ? (TypeInfo)value : this.cacheValue(key, false, super.getTypeInfo(type));
        }
        return null;
    }

    @Override
    public List<? extends TypeInfo> getSuperInterfaceTypeInfos(IType type) throws CoreException {
        if (type != null) {
            CacheKey key = new CacheKey("getSuperInterfaceTypeInfos", (IJavaElement)type);
            Object value = this.getCachedValue(key);
            return value instanceof List ? (List<? extends TypeInfo>)value : this.cacheValue(key, false, super.getSuperInterfaceTypeInfos(type));
        }
        return Collections.emptyList();
    }

    @Override
    public List<? extends IType> getSuperTypes(IType type, boolean visitSuperTypes, boolean addSuperClasses, boolean addSuperIntefaces, IMemberFilter ... filters) throws CoreException {
        if (type != null) {
            CacheKey key = new CacheKey("getSuperTypes", (IJavaElement)type, new Object[]{visitSuperTypes, addSuperClasses, addSuperIntefaces, filters});
            Object value = this.getCachedValue(key);
            return value instanceof List ? (List<? extends IType>)value : this.cacheValue(key, false, super.getSuperTypes(type, visitSuperTypes, addSuperClasses, addSuperIntefaces, filters));
        }
        return Collections.emptyList();
    }

    @Override
    public List<? extends IMethod> getMethods(IType type, boolean visitSuperTypes, IMemberFilter ... filters) throws CoreException {
        if (type != null) {
            CacheKey key = new CacheKey("getMethods", (IJavaElement)type, new Object[]{visitSuperTypes, filters});
            Object value = this.getCachedValue(key);
            return value instanceof List ? (List<? extends IMethod>)value : this.cacheValue(key, false, super.getMethods(type, visitSuperTypes, filters));
        }
        return Collections.emptyList();
    }

    @Override
    public List<? extends IField> getFields(IType type, boolean visitSuperTypes, IMemberFilter ... filters) throws CoreException {
        if (type != null) {
            CacheKey key = new CacheKey("getFields", (IJavaElement)type, new Object[]{visitSuperTypes, filters});
            Object value = this.getCachedValue(key);
            return value instanceof List ? (List<? extends IField>)value : this.cacheValue(key, false, super.getFields(type, visitSuperTypes, filters));
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<? extends AnnotationMemberValue> getAnnotationMemberValues(IAnnotation annotation) throws CoreException {
        if (annotation != null) {
            CacheKey key = new CacheKey("getAnnotationMemberValues", (IJavaElement)annotation);
            Object value = this.getCachedValue(key);
            return value instanceof Collection ? (Collection<? extends AnnotationMemberValue>)value : this.cacheValue(key, false, super.getAnnotationMemberValues(annotation));
        }
        return Collections.emptyList();
    }

    @Override
    public AnnotationMemberValue getAnnotationMemberValue(IAnnotation annotation, String memberName) throws CoreException {
        if (annotation != null && memberName != null) {
            CacheKey key = new CacheKey("getAnnotationMemberValue", (IJavaElement)annotation, new Object[]{memberName});
            Object value = this.getCachedValue(key);
            return value instanceof AnnotationMemberValue ? (AnnotationMemberValue)value : this.cacheValue(key, false, super.getAnnotationMemberValue(annotation, memberName));
        }
        return null;
    }

    @Override
    public IType getAnnotationType(IAnnotation annotation) throws CoreException {
        if (annotation != null) {
            CacheKey key = new CacheKey("getAnnotationType", (IJavaElement)annotation);
            Object value = this.getCachedValue(key);
            return value instanceof IType ? (IType)value : this.cacheValue(key, false, super.getAnnotationType(annotation));
        }
        return null;
    }

    @Override
    public boolean isOverriding(IType mainType, IMethod overriding, IMethod overridden) throws CoreException {
        if (mainType != null && overriding != null && overridden != null) {
            CacheKey key = new CacheKey("isOverriding", (IJavaElement)mainType, new Object[]{overriding, overridden});
            Object value = this.getCachedValue(key);
            return value instanceof Boolean ? (Boolean)value : this.cacheValue(key, false, super.isOverriding(mainType, overriding, overridden));
        }
        return false;
    }

    @Override
    public String[] toMethodParameterCompareArray(String[] parameterTypes, boolean parameterTypesAreSignature) throws CoreException {
        CacheKey key = new CacheKey("toMethodParameterCompareArray", parameterTypes, parameterTypesAreSignature);
        Object value = this.getCachedValue(key);
        return value instanceof String[] ? (String[])value : this.cacheValue(key, false, super.toMethodParameterCompareArray(parameterTypes, parameterTypesAreSignature));
    }

    @Override
    public boolean matches(IType type, String name) {
        if (type != null && name != null) {
            CacheKey key = new CacheKey("matches", (IJavaElement)type, new Object[]{name});
            Object value = this.getCachedValue(key);
            return value instanceof Boolean ? (Boolean)value : this.cacheValue(key, false, super.matches(type, name));
        }
        return false;
    }

    @Override
    protected TypeInfo getTypeInfo(IJavaElement javaElement, String signature) throws CoreException {
        if (javaElement != null && signature != null) {
            CacheKey key = new CacheKey("getTypeInfo", javaElement, new Object[]{signature});
            Object value = this.getCachedValue(key);
            return value instanceof TypeInfo ? (TypeInfo)value : this.cacheValue(key, false, super.getTypeInfo(javaElement, signature));
        }
        return null;
    }

    @Override
    protected String toTypeName(String signature) throws CoreException {
        if (signature != null) {
            CacheKey key = new CacheKey("toTypeName", signature);
            Object value = this.getCachedValue(key);
            return value instanceof String ? (String)value : this.cacheValue(key, false, super.toTypeName(signature));
        }
        return null;
    }

    @Override
    protected ITypeHierarchy getSuperTypeHierarchy(IType type) throws CoreException {
        if (type != null) {
            CacheKey key = new CacheKey("getSuperTypeHierarchy", (IJavaElement)type);
            Object value = this.getCachedValue(key);
            return value instanceof ITypeHierarchy ? (ITypeHierarchy)value : this.cacheValue(key, false, super.getSuperTypeHierarchy(type));
        }
        return null;
    }

    @Override
    protected void cacheSuperTypeHierarchy(IType type, IType[] superTypes, ITypeHierarchy typeHierarchy) {
        if (superTypes != null && typeHierarchy != null) {
            IType[] iTypeArray = superTypes;
            int n = superTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IType superType = iTypeArray[n2];
                CacheKey key = new CacheKey("getSuperTypeHierarchy", (IJavaElement)superType);
                this.cacheValue(key, false, typeHierarchy);
                ++n2;
            }
        }
    }

    @Override
    public String[] toResolvedName(IJavaElement javaElement, String typeName) throws CoreException {
        if (javaElement != null) {
            CacheKey key = new CacheKey("toResolvedName", javaElement, new Object[]{typeName});
            Object value = this.getCachedValue(key);
            return value instanceof String[] ? (String[])value : this.cacheValue(key, false, super.toResolvedName(javaElement, typeName));
        }
        return new String[1];
    }

    @Override
    protected CompilationUnit getCompilationUnit(IJavaElement source) throws CoreException {
        if (source != null) {
            CacheKey key = new CacheKey("getCompilationUnit", source);
            Object value = this.getCachedValue(key);
            return value instanceof CompilationUnit ? (CompilationUnit)value : this.cacheValue(key, true, super.getCompilationUnit(source));
        }
        return null;
    }

    @Override
    protected IAnnotation getAnnotation(IAnnotatable annotatable, String annotationName) throws CoreException {
        if (annotatable != null && annotationName != null) {
            CacheKey key = annotatable instanceof IJavaElement ? new CacheKey("getAnnotation", (IJavaElement)annotatable, new Object[]{annotationName}) : new CacheKey("getAnnotation", annotatable, annotationName);
            Object value = this.getCachedValue(key);
            return value instanceof IAnnotation ? (IAnnotation)value : this.cacheValue(key, false, super.getAnnotation(annotatable, annotationName));
        }
        return null;
    }

    @Override
    protected Map<String, String> doGetErasedTypeParameters(IJavaElement javaElement) throws CoreException {
        if (javaElement != null) {
            CacheKey key = new CacheKey("doGetErasedTypeParameters", javaElement);
            Object value = this.getCachedValue(key);
            return value instanceof Map ? (Map<String, String>)value : this.cacheValue(key, false, super.doGetErasedTypeParameters(javaElement));
        }
        return Collections.emptyMap();
    }
}

