/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.jdt;

import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.adf.dtrt.jdt.AnnotationMemberValue;
import oracle.eclipse.tools.adf.dtrt.jdt.BasicTypeHelper;
import oracle.eclipse.tools.adf.dtrt.jdt.CacheKey;
import oracle.eclipse.tools.adf.dtrt.jdt.IMemberFilter;
import oracle.eclipse.tools.adf.dtrt.jdt.SimpleCacheTypeHelper;
import oracle.eclipse.tools.adf.dtrt.jdt.TypeInfo;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.LRUMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.dom.CompilationUnit;

final class ManagedTypeHelper
extends BasicTypeHelper {
    private static final String NULL = "NULL - " + System.nanoTime();
    private Map<IFile, CachedValue> fileCache = new LRUMap<IFile, CachedValue>(1001, 1000, 100);
    private SimpleCacheTypeHelper simpleCacheTypeHelper = new SimpleCacheTypeHelper();

    ManagedTypeHelper() {
    }

    private static long getFileTimestamp(IFile file) {
        return file.getModificationStamp();
    }

    private IFile getFile(Object object) throws CoreException {
        return object instanceof IJavaElement ? this.getFile((IJavaElement)object) : null;
    }

    private IFile getFile(IJavaElement javaElement) throws CoreException {
        IResource resource = javaElement.getResource();
        if (resource instanceof IFile) {
            return (IFile)resource;
        }
        return null;
    }

    private synchronized Object getCachedValue(IFile file, CacheKey key) {
        CachedValue cachedValue = this.fileCache.get(file);
        if (cachedValue != null) {
            Object value = cachedValue.getValue(key);
            if (value == null && cachedValue.isEmpty()) {
                this.fileCache.remove(file);
            }
            if (value != NULL) {
                return value;
            }
        }
        return null;
    }

    private synchronized <T> T cacheValue(IFile file, CacheKey key, boolean asSoftReference, T value) {
        long timestamp = ManagedTypeHelper.getFileTimestamp(file);
        CachedValue cachedValue = this.fileCache.get(file);
        if (cachedValue != null && cachedValue.getTimestamp(file) != timestamp) {
            this.fileCache.remove(file);
            cachedValue.dispose();
            cachedValue = null;
        }
        if (cachedValue == null) {
            cachedValue = new CachedValue(file);
            this.fileCache.put(file, cachedValue);
        }
        cachedValue.putValue(key, asSoftReference, value == null ? NULL : value);
        return value;
    }

    @Override
    public ICompilationUnit getCompilationUnit(IFile javaFile, boolean workingCopy) throws CoreException {
        if (javaFile != null) {
            if (workingCopy) {
                return super.getCompilationUnit(javaFile, workingCopy);
            }
            CacheKey key = new CacheKey("getCompilationUnit");
            Object value = this.getCachedValue(javaFile, key);
            return value instanceof ICompilationUnit ? (ICompilationUnit)value : this.cacheValue(javaFile, key, false, super.getCompilationUnit(javaFile, workingCopy));
        }
        return null;
    }

    @Override
    public IType findType(ICompilationUnit compilationUnit, String name) throws CoreException {
        if (compilationUnit != null && !DTRTUtil.isEmpty(name)) {
            IFile file = this.getFile((IJavaElement)compilationUnit);
            if (file == null) {
                return this.simpleCacheTypeHelper.findType(compilationUnit, name);
            }
            CacheKey key = new CacheKey("findType", name);
            Object value = this.getCachedValue(file, key);
            return value instanceof IType ? (IType)value : this.cacheValue(file, key, false, super.findType(compilationUnit, name));
        }
        return null;
    }

    @Override
    public TypeInfo getTypeInfo(IType type) throws CoreException {
        if (type != null) {
            IFile file = this.getFile((IJavaElement)type);
            if (file == null) {
                return this.simpleCacheTypeHelper.getTypeInfo(type);
            }
            CacheKey key = new CacheKey("getTypeInfo", (IJavaElement)type);
            Object value = this.getCachedValue(file, key);
            return value instanceof TypeInfo ? (TypeInfo)value : this.cacheValue(file, key, false, super.getTypeInfo(type));
        }
        return null;
    }

    @Override
    public List<? extends TypeInfo> getSuperInterfaceTypeInfos(IType type) throws CoreException {
        if (type != null) {
            IFile file = this.getFile((IJavaElement)type);
            if (file == null) {
                return this.simpleCacheTypeHelper.getSuperInterfaceTypeInfos(type);
            }
            CacheKey key = new CacheKey("getSuperInterfaceTypeInfos", (IJavaElement)type);
            Object value = this.getCachedValue(file, key);
            return value instanceof List ? (List<? extends TypeInfo>)value : this.cacheValue(file, key, false, super.getSuperInterfaceTypeInfos(type));
        }
        return Collections.emptyList();
    }

    @Override
    public List<? extends IType> getSuperTypes(IType type, boolean visitSuperTypes, boolean addSuperClasses, boolean addSuperIntefaces, IMemberFilter ... filters) throws CoreException {
        if (type != null && (addSuperClasses || addSuperIntefaces)) {
            IFile file = this.getFile((IJavaElement)type);
            if (file == null) {
                return this.simpleCacheTypeHelper.getSuperTypes(type, visitSuperTypes, addSuperClasses, addSuperIntefaces, filters);
            }
            CacheKey key = new CacheKey("getSuperTypes", (IJavaElement)type, new Object[]{visitSuperTypes, addSuperClasses, addSuperIntefaces, filters});
            Object value = this.getCachedValue(file, key);
            return value instanceof List ? (List<? extends IType>)value : this.cacheValue(file, key, false, super.getSuperTypes(type, visitSuperTypes, addSuperClasses, addSuperIntefaces, filters));
        }
        return Collections.emptyList();
    }

    @Override
    public List<? extends IMethod> getMethods(IType type, boolean visitSuperTypes, IMemberFilter ... filters) throws CoreException {
        if (type != null) {
            IFile file = this.getFile((IJavaElement)type);
            if (file == null) {
                return this.simpleCacheTypeHelper.getMethods(type, visitSuperTypes, filters);
            }
            CacheKey key = new CacheKey("getMethods", (IJavaElement)type, new Object[]{visitSuperTypes, filters});
            Object value = this.getCachedValue(file, key);
            return value instanceof List ? (List<? extends IMethod>)value : this.cacheValue(file, key, false, super.getMethods(type, visitSuperTypes, filters));
        }
        return Collections.emptyList();
    }

    @Override
    public List<? extends IField> getFields(IType type, boolean visitSuperTypes, IMemberFilter ... filters) throws CoreException {
        if (type != null) {
            IFile file = this.getFile((IJavaElement)type);
            if (file == null) {
                return this.simpleCacheTypeHelper.getFields(type, visitSuperTypes, filters);
            }
            CacheKey key = new CacheKey("getFields", (IJavaElement)type, new Object[]{visitSuperTypes, filters});
            Object value = this.getCachedValue(file, key);
            return value instanceof List ? (List<? extends IField>)value : this.cacheValue(file, key, false, super.getFields(type, visitSuperTypes, filters));
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<? extends AnnotationMemberValue> getAnnotationMemberValues(IAnnotation annotation) throws CoreException {
        if (annotation != null) {
            IFile file = this.getFile((IJavaElement)annotation);
            if (file == null) {
                return this.simpleCacheTypeHelper.getAnnotationMemberValues(annotation);
            }
            CacheKey key = new CacheKey("getAnnotationMemberValues", (IJavaElement)annotation);
            Object value = this.getCachedValue(file, key);
            return value instanceof Collection ? (Collection<? extends AnnotationMemberValue>)value : this.cacheValue(file, key, false, super.getAnnotationMemberValues(annotation));
        }
        return Collections.emptyList();
    }

    @Override
    public AnnotationMemberValue getAnnotationMemberValue(IAnnotation annotation, String memberName) throws CoreException {
        if (annotation != null && !DTRTUtil.isEmpty(memberName)) {
            IFile file = this.getFile((IJavaElement)annotation);
            if (file == null) {
                return this.simpleCacheTypeHelper.getAnnotationMemberValue(annotation, memberName);
            }
            CacheKey key = new CacheKey("getAnnotationMemberValue", (IJavaElement)annotation, new Object[]{memberName});
            Object value = this.getCachedValue(file, key);
            return value instanceof AnnotationMemberValue ? (AnnotationMemberValue)value : this.cacheValue(file, key, false, super.getAnnotationMemberValue(annotation, memberName));
        }
        return null;
    }

    @Override
    public IType getAnnotationType(IAnnotation annotation) throws CoreException {
        if (annotation != null) {
            IFile file = this.getFile((IJavaElement)annotation);
            if (file == null) {
                return this.simpleCacheTypeHelper.getAnnotationType(annotation);
            }
            CacheKey key = new CacheKey("getAnnotationType", (IJavaElement)annotation);
            Object value = this.getCachedValue(file, key);
            return value instanceof IType ? (IType)value : this.cacheValue(file, key, false, super.getAnnotationType(annotation));
        }
        return null;
    }

    @Override
    public String[] toMethodParameterCompareArray(String[] parameterTypes, boolean parameterTypesAreSignature) throws CoreException {
        return this.simpleCacheTypeHelper.toMethodParameterCompareArray(parameterTypes, parameterTypesAreSignature);
    }

    @Override
    protected TypeInfo getTypeInfo(IJavaElement javaElement, String signature) throws CoreException {
        if (javaElement != null && signature != null) {
            IFile file = this.getFile(javaElement);
            if (file == null) {
                return this.simpleCacheTypeHelper.getTypeInfo(javaElement, signature);
            }
            CacheKey key = new CacheKey("getTypeInfo", javaElement, new Object[]{signature});
            Object value = this.getCachedValue(file, key);
            return value instanceof TypeInfo ? (TypeInfo)value : this.cacheValue(file, key, false, super.getTypeInfo(javaElement, signature));
        }
        return null;
    }

    @Override
    protected String toTypeName(String signature) throws CoreException {
        return this.simpleCacheTypeHelper.toTypeName(signature);
    }

    @Override
    public String[] toResolvedName(IJavaElement javaElement, String typeName) throws CoreException {
        if (javaElement != null) {
            IFile file = this.getFile(javaElement);
            if (file == null) {
                return this.simpleCacheTypeHelper.toResolvedName(javaElement, typeName);
            }
            CacheKey key = new CacheKey("toResolvedName", javaElement, new Object[]{typeName});
            Object value = this.getCachedValue(file, key);
            return value instanceof String[] ? (String[])value : this.cacheValue(file, key, false, super.toResolvedName(javaElement, typeName));
        }
        return new String[0];
    }

    @Override
    protected CompilationUnit getCompilationUnit(IJavaElement source) throws CoreException {
        if (source != null) {
            IFile file = this.getFile(source);
            if (file == null) {
                return this.simpleCacheTypeHelper.getCompilationUnit(source);
            }
            CacheKey key = new CacheKey("getCompilationUnit", source);
            Object value = this.getCachedValue(file, key);
            return value instanceof CompilationUnit ? (CompilationUnit)value : this.cacheValue(file, key, true, super.getCompilationUnit(source));
        }
        return null;
    }

    @Override
    protected IAnnotation getAnnotation(IAnnotatable annotatable, String annotationName) throws CoreException {
        if (annotatable != null && annotationName != null) {
            IFile file = this.getFile(annotatable);
            if (file == null) {
                return this.simpleCacheTypeHelper.getAnnotation(annotatable, annotationName);
            }
            CacheKey key = new CacheKey("getAnnotation", annotatable, annotationName);
            Object value = this.getCachedValue(file, key);
            return value instanceof IAnnotation ? (IAnnotation)value : this.cacheValue(file, key, false, super.getAnnotation(annotatable, annotationName));
        }
        return null;
    }

    @Override
    protected Map<String, String> doGetErasedTypeParameters(IJavaElement javaElement) throws CoreException {
        if (javaElement != null) {
            IFile file = this.getFile(javaElement);
            if (file == null) {
                return this.simpleCacheTypeHelper.doGetErasedTypeParameters(javaElement);
            }
            CacheKey key = new CacheKey("doGetErasedTypeParameters", javaElement);
            Object value = this.getCachedValue(file, key);
            return value instanceof Map ? (Map<String, String>)value : this.cacheValue(file, key, false, super.doGetErasedTypeParameters(javaElement));
        }
        return Collections.emptyMap();
    }

    @Override
    protected ITypeHierarchy getSuperTypeHierarchy(IType type) throws CoreException {
        if (type != null) {
            IFile file = this.getFile((IJavaElement)type);
            if (file == null) {
                return this.simpleCacheTypeHelper.getSuperTypeHierarchy(type);
            }
            CacheKey key = new CacheKey("getSuperTypeHierarchy", (IJavaElement)type);
            Object value = this.getCachedValue(file, key);
            return value instanceof ITypeHierarchy ? (ITypeHierarchy)value : this.cacheValue(file, key, false, super.getSuperTypeHierarchy(type));
        }
        return null;
    }

    @Override
    protected void cacheSuperTypeHierarchy(IType type, IType[] superTypes, ITypeHierarchy typeHierarchy) throws CoreException {
        if (type != null && typeHierarchy != null && superTypes != null && superTypes.length > 0) {
            CachedValue cachedValue = null;
            IFile file = this.getFile((IJavaElement)type);
            if (file != null) {
                cachedValue = this.fileCache.get(file);
            }
            IType[] iTypeArray = superTypes;
            int n = superTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IType superType = iTypeArray[n2];
                IFile superTypeFile = this.getFile((IJavaElement)superType);
                if (superTypeFile != null) {
                    if (cachedValue != null) {
                        cachedValue.monitorFile(superTypeFile);
                    }
                    CacheKey key = new CacheKey("getSuperTypeHierarchy", (IJavaElement)superType);
                    this.cacheValue(superTypeFile, key, false, typeHierarchy);
                }
                ++n2;
            }
        }
        super.cacheSuperTypeHierarchy(type, superTypes, typeHierarchy);
    }

    private static final class CachedValue {
        private Map<IFile, Long> timestampMap = new HashMap<IFile, Long>();
        private Map<CacheKey, Object> valueMap = new HashMap<CacheKey, Object>(30);

        public CachedValue(IFile file) {
            this.monitorFile(file);
        }

        public void dispose() {
            if (this.timestampMap != null) {
                this.timestampMap.clear();
                this.timestampMap = null;
            }
            if (this.valueMap != null) {
                this.valueMap.clear();
                this.valueMap = null;
            }
        }

        public void monitorFile(IFile file) {
            this.timestampMap.put(file, ManagedTypeHelper.getFileTimestamp(file));
        }

        public long getTimestamp(IFile file) {
            Long timestamp = this.timestampMap.get(file);
            return timestamp == null ? -1L : timestamp;
        }

        public boolean isEmpty() {
            return this.valueMap.isEmpty();
        }

        public <T> T putValue(CacheKey key, boolean asSoftReference, T value) {
            if (value != null) {
                if (asSoftReference) {
                    this.valueMap.put(key, new SoftReference<T>(value));
                } else {
                    this.valueMap.put(key, value);
                }
            }
            return value;
        }

        public Object getValue(CacheKey key) {
            Object value;
            if (this.checkTimestamps()) {
                value = this.valueMap.get(key);
                if (value instanceof SoftReference) {
                    value = ((SoftReference)value).get();
                }
            } else {
                value = null;
            }
            if (value == null) {
                this.valueMap.remove(key);
            }
            return value;
        }

        private boolean checkTimestamps() {
            if (!this.timestampMap.isEmpty()) {
                for (Map.Entry<IFile, Long> entry : this.timestampMap.entrySet()) {
                    if (entry.getValue() == ManagedTypeHelper.getFileTimestamp(entry.getKey())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

