/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.jdt;

import java.util.Arrays;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import org.eclipse.jdt.core.IJavaElement;

final class CacheKey {
    private String key;
    private IJavaElement javaElement;
    private Object[] keyElements;
    private int hashCode;

    CacheKey(String key) {
        this.key = key;
        this.keyElements = DTRTUtil.EMPTY_ARRAY;
        this.initialize();
    }

    CacheKey(String key, IJavaElement javaElement) {
        this.key = key;
        this.javaElement = javaElement;
        this.initialize();
    }

    CacheKey(String key, IJavaElement javaElement, Object ... keyElements) {
        this.key = key;
        this.javaElement = javaElement;
        this.keyElements = keyElements != null && keyElements.length > 0 ? keyElements : DTRTUtil.EMPTY_ARRAY;
        this.initialize();
    }

    CacheKey(String key, Object ... keyElements) {
        this.key = key;
        this.keyElements = keyElements != null && keyElements.length > 0 ? keyElements : DTRTUtil.EMPTY_ARRAY;
        this.initialize();
    }

    private void initialize() {
        int prime = 31;
        int result = 1;
        result = prime * result + (this.key == null ? 0 : this.key.hashCode());
        result = prime * result + (this.javaElement == null ? 0 : this.javaElement.hashCode());
        this.hashCode = result = prime * result + Arrays.deepHashCode(this.keyElements);
    }

    public IJavaElement getJavaElement() {
        return this.javaElement;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof CacheKey)) {
            return false;
        }
        CacheKey other = (CacheKey)obj;
        return this.hashCode == other.hashCode && DTRTUtil.equals(this.key, other.key) && DTRTUtil.equals(this.javaElement, other.javaElement) && DTRTUtil.equals(this.keyElements, other.keyElements);
    }
}

