/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.jdt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.adf.dtrt.internal.DTRTBundle;
import oracle.eclipse.tools.adf.dtrt.jdt.AnnotationMemberValue;
import oracle.eclipse.tools.adf.dtrt.jdt.CacheKey;
import oracle.eclipse.tools.adf.dtrt.jdt.IMemberFilter;
import oracle.eclipse.tools.adf.dtrt.jdt.ITypeHelper;
import oracle.eclipse.tools.adf.dtrt.jdt.JDTUtil;
import oracle.eclipse.tools.adf.dtrt.jdt.MemberFilterUtil;
import oracle.eclipse.tools.adf.dtrt.jdt.MethodOverrideTester;
import oracle.eclipse.tools.adf.dtrt.jdt.TypeInfo;
import oracle.eclipse.tools.adf.dtrt.util.CompoundList;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.JavaUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.WildcardType;

class BasicTypeHelper
implements ITypeHelper {
    private static final Comparator<IType> TYPE_COMPARATOR = new Comparator<IType>(){

        @Override
        public int compare(IType o1, IType o2) {
            try {
                return this.doCompare(o1, o2);
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }

        private int doCompare(IType o1, IType o2) throws CoreException {
            if (o1.isClass()) {
                return o2.isClass() ? 0 : -1;
            }
            if (o2.isClass()) {
                return 1;
            }
            if (o1.isInterface()) {
                return o2.isInterface() ? 0 : -1;
            }
            if (o2.isInterface()) {
                return 1;
            }
            if (o1.isAnnotation()) {
                return o2.isAnnotation() ? 0 : -1;
            }
            if (o2.isAnnotation()) {
                return 1;
            }
            if (o1.isEnum()) {
                return o2.isEnum() ? 0 : -1;
            }
            if (o2.isEnum()) {
                return 1;
            }
            return 0;
        }
    };

    BasicTypeHelper() {
    }

    @Override
    public boolean reset() {
        return false;
    }

    @Override
    public boolean reset(IType type) {
        return false;
    }

    protected final boolean reset(Collection<CacheKey> keys, IType type) {
        if (keys != null && type != null) {
            boolean modfied = false;
            Iterator<CacheKey> i = keys.iterator();
            while (i.hasNext()) {
                CacheKey key = i.next();
                IType keyType = this.getCacheKeyType(key.getJavaElement());
                if (!JDTUtil.equals(keyType, type)) continue;
                i.remove();
                modfied = true;
            }
            return modfied;
        }
        return false;
    }

    protected final IType getCacheKeyType(IJavaElement javaElement) {
        if (javaElement != null) {
            return javaElement.getElementType() == 7 ? (IType)javaElement : (IType)javaElement.getAncestor(7);
        }
        return null;
    }

    @Override
    public final IType findType(IProject project, String className) throws CoreException {
        if (project != null && className != null) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            return this.findType(javaProject, className);
        }
        return null;
    }

    @Override
    public IType findType(IJavaProject javaProject, String className) throws CoreException {
        if (javaProject != null && !DTRTUtil.isEmpty(className)) {
            IType type = javaProject.findType(className, null);
            return type;
        }
        return null;
    }

    @Override
    public ICompilationUnit getCompilationUnit(IFile javaFile, boolean workingCopy) throws CoreException {
        IJavaElement javaElement;
        if (javaFile != null && (javaElement = JavaCore.create((IFile)javaFile)) instanceof ICompilationUnit) {
            return workingCopy ? ((ICompilationUnit)javaElement).getWorkingCopy(null) : (ICompilationUnit)javaElement;
        }
        return null;
    }

    @Override
    public IType findType(ICompilationUnit compilationUnit, String name) throws CoreException {
        if (compilationUnit != null && !DTRTUtil.isEmpty(name)) {
            IType[] iTypeArray = compilationUnit.getTypes();
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType topLevelType = iTypeArray[n2];
                IType type = this.findMemberType(topLevelType, TypeInfo.toClassName(name));
                if (type != null) {
                    return type;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public TypeInfo getTypeInfo(IType type) throws CoreException {
        if (type != null) {
            TypeInfo typeInfo = new TypeInfo().setClassName(type.getFullyQualifiedName('.'));
            ITypeParameter[] typeParameters = type.getTypeParameters();
            if (typeParameters.length > 0) {
                StringBuilder sourceNameBuilder = new StringBuilder(typeInfo.getClassName());
                sourceNameBuilder.append('<');
                int i = 0;
                while (i < typeParameters.length) {
                    if (i != 0) {
                        sourceNameBuilder.append(", ");
                    }
                    ITypeParameter typeParameter = typeParameters[i];
                    sourceNameBuilder.append(typeParameter.getElementName());
                    String[] boundSignatures = typeParameter.getBoundsSignatures();
                    if (boundSignatures.length > 0) {
                        sourceNameBuilder.append(" extends ");
                        int j = 0;
                        while (j < boundSignatures.length) {
                            if (j != 0) {
                                sourceNameBuilder.append(" & ");
                            }
                            sourceNameBuilder.append(this.getTypeInfo((IJavaElement)type, boundSignatures[j]).getSourceName());
                            ++j;
                        }
                    }
                    ++i;
                }
                sourceNameBuilder.append('>');
                typeInfo.setSourceName(sourceNameBuilder.toString());
            }
            return typeInfo;
        }
        return null;
    }

    @Override
    public final TypeInfo getSuperClassTypeInfo(IType type) throws CoreException {
        return type != null && !type.isInterface() ? this.getTypeInfo((IJavaElement)type, type.getSuperclassTypeSignature()) : null;
    }

    @Override
    public List<? extends TypeInfo> getSuperInterfaceTypeInfos(IType type) throws CoreException {
        String[] signatures;
        if (type != null && (signatures = type.getSuperInterfaceTypeSignatures()).length > 0) {
            List<TypeInfo> typeInfos = new ArrayList(signatures.length);
            String[] stringArray = signatures;
            int n = signatures.length;
            int n2 = 0;
            while (n2 < n) {
                String signature = stringArray[n2];
                typeInfos.add(this.getTypeInfo((IJavaElement)type, signature));
                ++n2;
            }
            typeInfos = Collections.unmodifiableList(typeInfos);
            return typeInfos;
        }
        return Collections.emptyList();
    }

    @Override
    public final TypeInfo getTypeInfo(IMethod method) throws CoreException {
        return method != null ? this.getTypeInfo((IJavaElement)method, method.getReturnType()) : null;
    }

    @Override
    public final TypeInfo getTypeInfo(ILocalVariable localVariable) throws CoreException {
        return localVariable != null ? this.getTypeInfo((IJavaElement)localVariable, localVariable.getTypeSignature()) : null;
    }

    @Override
    public final TypeInfo getTypeInfo(IField field) throws CoreException {
        return field != null ? this.getTypeInfo((IJavaElement)field, field.getTypeSignature()) : null;
    }

    @Override
    public final Map<String, String> getErasedTypeParameters(IType type) throws CoreException {
        return this.doGetErasedTypeParameters((IJavaElement)type);
    }

    @Override
    public final Map<String, String> getErasedTypeParameters(IMethod method) throws CoreException {
        return this.doGetErasedTypeParameters((IJavaElement)method);
    }

    @Override
    public final <M extends IMember> List<M> filter(List<? extends M> initialMembers, IType mainType, M[] members, IMemberFilter ... filters) throws CoreException {
        return this.filter(initialMembers, mainType, members == null ? null : Arrays.asList(members), filters);
    }

    @Override
    public final <M extends IMember> List<M> filter(List<? extends M> initialMembers, IType mainType, Collection<? extends M> members, IMemberFilter ... filters) throws CoreException {
        if (members != null && !members.isEmpty() && filters != null && filters.length > 0) {
            ArrayList list = new ArrayList(members.size());
            List<Object> visitedMembers = initialMembers != null ? Collections.unmodifiableList(initialMembers) : Collections.emptyList();
            block3: for (IMember member : members) {
                if (member.isBinary() && (member.getElementName().indexOf(36) >= 0 || "<clinit>".equals(member.getElementName()))) continue;
                IMemberFilter[] iMemberFilterArray = filters;
                int n = filters.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemberFilter filter = iMemberFilterArray[n2];
                    if (filter != null) {
                        try {
                            if (filter.exclude(visitedMembers, this, mainType, member)) continue block3;
                            if (filter.include(visitedMembers, this, mainType, member)) {
                                list.add(member);
                                visitedMembers = initialMembers == null || initialMembers.isEmpty() ? list : new CompoundList<M>(initialMembers, list);
                                continue block3;
                            }
                            if (filter.stop(visitedMembers, this, mainType, member)) {
                                break block3;
                            }
                        }
                        catch (CoreException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw new CoreException(DTRTUtil.createErrorStatus(e));
                        }
                    }
                    ++n2;
                }
            }
            if (!list.isEmpty()) {
                return list;
            }
        }
        return new ArrayList(0);
    }

    private List<? extends IType> getSuperTypes(IType type, boolean visitSuperTypes, boolean addSuperClasses, boolean addSuperIntefaces) throws CoreException {
        return this.getSuperTypes(type, visitSuperTypes, addSuperClasses, addSuperIntefaces, null);
    }

    @Override
    public List<? extends IType> getSuperTypes(IType type, boolean visitSuperTypes, boolean addSuperClasses, boolean addSuperIntefaces, IMemberFilter ... filters) throws CoreException {
        if (type != null && (addSuperClasses || addSuperIntefaces)) {
            List list;
            IType[] superTypes;
            ITypeHierarchy typeHierarchy = this.getSuperTypeHierarchy(type);
            if (visitSuperTypes) {
                superTypes = !addSuperClasses ? typeHierarchy.getAllSuperInterfaces(type) : (!addSuperIntefaces ? typeHierarchy.getAllSuperclasses(type) : typeHierarchy.getAllSupertypes(type));
            } else {
                IType[] iTypeArray;
                if (!addSuperClasses) {
                    iTypeArray = typeHierarchy.getSuperInterfaces(type);
                } else if (!addSuperIntefaces) {
                    IType superClass = typeHierarchy.getSuperclass(type);
                    if (superClass != null) {
                        IType[] iTypeArray2 = new IType[1];
                        iTypeArray = iTypeArray2;
                        iTypeArray2[0] = superClass;
                    } else {
                        iTypeArray = new IType[]{};
                    }
                } else {
                    iTypeArray = typeHierarchy.getSupertypes(type);
                }
                superTypes = iTypeArray;
            }
            List list2 = list = filters != null && filters.length > 0 ? this.filter(null, type, (IMember[])superTypes, filters) : Arrays.asList(superTypes);
            if (addSuperClasses && addSuperIntefaces) {
                Collections.sort(list, TYPE_COMPARATOR);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public List<? extends IMethod> getMethods(IType type, boolean visitSuperTypes, IMemberFilter ... filters) throws CoreException {
        if (type != null) {
            List<Object> methods;
            boolean hasFilters = filters != null && filters.length > 0;
            List<Object> list = methods = hasFilters ? this.filter(null, type, (IMember[])type.getMethods(), filters) : new ArrayList<IMethod>(Arrays.asList(type.getMethods()));
            if (visitSuperTypes) {
                ITypeHierarchy typeHierarchy = this.getSuperTypeHierarchy(type);
                IType[] superClassTypes = typeHierarchy.getAllSuperclasses(type);
                this.cacheSuperTypeHierarchy(type, superClassTypes, typeHierarchy);
                IType[] iTypeArray = superClassTypes;
                int n = superClassTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    IType superClassType = iTypeArray[n2];
                    List superClassMethods = hasFilters ? this.filter(methods, type, (IMember[])superClassType.getMethods(), filters) : Arrays.asList(superClassType.getMethods());
                    methods.addAll(superClassMethods);
                    ++n2;
                }
                IType[] superInterfaceTypes = typeHierarchy.getAllSuperInterfaces(type);
                this.cacheSuperTypeHierarchy(type, superInterfaceTypes, typeHierarchy);
                IType[] iTypeArray2 = superInterfaceTypes;
                int n3 = superInterfaceTypes.length;
                n = 0;
                while (n < n3) {
                    IType superInterfaceType = iTypeArray2[n];
                    List superInterfaceMethods = hasFilters ? this.filter(methods, type, (IMember[])superInterfaceType.getMethods(), filters) : Arrays.asList(superInterfaceType.getMethods());
                    methods.addAll(superInterfaceMethods);
                    ++n;
                }
            }
            methods = methods.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<IMethod>(methods));
            return methods;
        }
        return Collections.emptyList();
    }

    @Override
    public List<? extends IField> getFields(IType type, boolean visitSuperTypes, IMemberFilter ... filters) throws CoreException {
        if (type != null) {
            List<Object> fields;
            boolean hasFilters = filters != null && filters.length > 0;
            List<Object> list = fields = hasFilters ? this.filter(null, type, (IMember[])type.getFields(), filters) : new ArrayList<IField>(Arrays.asList(type.getFields()));
            if (visitSuperTypes) {
                ITypeHierarchy typeHierarchy = this.getSuperTypeHierarchy(type);
                IType[] superClassTypes = typeHierarchy.getAllSuperclasses(type);
                this.cacheSuperTypeHierarchy(type, superClassTypes, typeHierarchy);
                IType[] iTypeArray = superClassTypes;
                int n = superClassTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    IType superClassType = iTypeArray[n2];
                    List superClassFields = hasFilters ? this.filter(fields, type, (IMember[])superClassType.getFields(), filters) : Arrays.asList(superClassType.getFields());
                    fields.addAll(superClassFields);
                    ++n2;
                }
                IType[] superInterfaceTypes = typeHierarchy.getAllSuperInterfaces(type);
                this.cacheSuperTypeHierarchy(type, superInterfaceTypes, typeHierarchy);
                IType[] iTypeArray2 = superInterfaceTypes;
                int n3 = superInterfaceTypes.length;
                n = 0;
                while (n < n3) {
                    IType superInterfaceType = iTypeArray2[n];
                    List superInterfaceFields = hasFilters ? this.filter(fields, type, (IMember[])superInterfaceType.getFields(), filters) : Arrays.asList(superInterfaceType.getFields());
                    fields.addAll(superInterfaceFields);
                    ++n;
                }
            }
            fields = fields.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(fields);
            return fields;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isCollection(IType type) throws CoreException {
        return type != null && this.isAssignableFrom(this.findType(type.getJavaProject(), Collection.class.getName()), type);
    }

    @Override
    public final boolean isCollectionOrMap(IType type) throws CoreException {
        return type != null && (this.isAssignableFrom(this.findType(type.getJavaProject(), Collection.class.getName()), type) || this.isAssignableFrom(this.findType(type.getJavaProject(), Map.class.getName()), type));
    }

    @Override
    public final boolean isAssignableFrom(IType type1, IType type2) throws CoreException {
        if (type1 != null && type2 != null) {
            ITypeHierarchy typeHierarchy;
            Object[] superTypes;
            if (type1.equals(type2)) {
                return true;
            }
            if ((type2.getSuperclassTypeSignature() != null || type2.getSuperInterfaceTypeSignatures().length > 0) && (type1 = this.findType(type2.getJavaProject(), type1.getFullyQualifiedName())) != null && DTRTUtil.indexOf(superTypes = (typeHierarchy = this.getSuperTypeHierarchy(type2)).getAllSupertypes(type2), type1) >= 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public final IAnnotation getAnnotation(IAnnotatable annotatable, boolean visitSuperTypes, String annotationName) throws CoreException {
        if (annotatable != null && !DTRTUtil.isEmpty(annotationName)) {
            IAnnotation annotation = this.getAnnotation(annotatable, annotationName);
            if (annotation == null && visitSuperTypes) {
                IType declaringType;
                List<? extends IMethod> superMethods;
                IMethod iMethod;
                if (annotatable instanceof IType) {
                    for (IType iType : this.getSuperTypes((IType)annotatable, true, true, true)) {
                        annotation = this.getAnnotation((IAnnotatable)iType, annotationName);
                        if (annotation == null) {
                            continue;
                        }
                        break;
                    }
                } else if (annotatable instanceof IMethod && !(iMethod = (IMethod)annotatable).isConstructor() && !(superMethods = this.getMethods(declaringType = iMethod.getDeclaringType(), true, new MemberFilterUtil.ExcludeNotInserted((IMemberFilter)MemberFilterUtil.PUBLIC_PROTECTED), new MemberFilterUtil.MemberFinder().findByName(iMethod.getElementName()))).isEmpty()) {
                    for (IMethod iMethod2 : superMethods) {
                        if (!this.isOverriding(declaringType, iMethod, iMethod2) || (annotation = this.getAnnotation((IAnnotatable)iMethod2, annotationName)) == null) {
                            continue;
                        }
                        break;
                    }
                }
            }
            return annotation;
        }
        return null;
    }

    @Override
    public Collection<? extends AnnotationMemberValue> getAnnotationMemberValues(IAnnotation annotation) throws CoreException {
        if (annotation != null) {
            List annotationMemberValues;
            IMemberValuePair[] memberValuePairs = annotation.getMemberValuePairs();
            if (memberValuePairs.length == 0) {
                annotationMemberValues = Collections.emptyList();
            } else {
                annotationMemberValues = new ArrayList(memberValuePairs.length);
                int i = 0;
                while (i < memberValuePairs.length) {
                    IMemberValuePair memberValuePair = memberValuePairs[i];
                    AnnotationMemberValue annotationMemberValue = new AnnotationMemberValue(annotation, memberValuePair, this.isMultiValue(annotation, memberValuePair));
                    this.setValues(annotationMemberValue);
                    annotationMemberValues.add(annotationMemberValue);
                    ++i;
                }
            }
            return Collections.unmodifiableList(annotationMemberValues);
        }
        return Collections.emptyList();
    }

    @Override
    public AnnotationMemberValue getAnnotationMemberValue(IAnnotation annotation, String memberName) throws CoreException {
        IMemberValuePair memberValuePair;
        if (annotation != null && !DTRTUtil.isEmpty(memberName) && (memberValuePair = JDTUtil.findMemberValuePair(annotation, memberName)) != null) {
            AnnotationMemberValue annotationMemberValue = new AnnotationMemberValue(annotation, memberValuePair, this.isMultiValue(annotation, memberValuePair));
            this.setValues(annotationMemberValue);
            return annotationMemberValue;
        }
        return null;
    }

    @Override
    public IType getAnnotationType(IAnnotation annotation) throws CoreException {
        if (annotation != null) {
            String resolvedClassName = this.toResolvedClassName(this.toResolvedName((IJavaElement)annotation, annotation.getElementName()));
            return this.findType(annotation.getJavaProject(), resolvedClassName);
        }
        return null;
    }

    public boolean isOverriding(IType mainType, IMethod overriding, IMethod overridden) throws CoreException {
        if (overriding == overridden) {
            return false;
        }
        int overridingFlags = overriding.getFlags();
        if (Flags.isPrivate((int)overridingFlags) || Flags.isStatic((int)overridingFlags) || overriding.isConstructor()) {
            return false;
        }
        int overriddenFlags = overriding.getFlags();
        if (Flags.isPrivate((int)overriddenFlags) || Flags.isStatic((int)overriddenFlags) || overridden.isConstructor() || Flags.isFinal((int)overriddenFlags)) {
            return false;
        }
        if (Flags.isProtected((int)overridingFlags) && Flags.isPublic((int)overriddenFlags)) {
            return false;
        }
        if (mainType != null) {
            MethodOverrideTester tester = new MethodOverrideTester(mainType, this.getSuperTypeHierarchy(mainType));
            return tester.isSubsignature(overriding, overridden);
        }
        return false;
    }

    private IType findMemberType(IType type, String name) throws CoreException {
        if (type != null) {
            if (this.matches(type, name)) {
                return type;
            }
            IType[] iTypeArray = type.getTypes();
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType memberType = iTypeArray[n2];
                IType matchingType = this.findMemberType(memberType, name);
                if (matchingType != null) {
                    return matchingType;
                }
                ++n2;
            }
        }
        return null;
    }

    public String[] toMethodParameterCompareArray(String[] parameterTypes, boolean parameterTypesAreSignature) throws CoreException {
        String[] parameterTypeSignatures;
        if (parameterTypes == null || parameterTypes.length == 0) {
            return new String[0];
        }
        if (parameterTypesAreSignature) {
            parameterTypeSignatures = parameterTypes;
        } else {
            parameterTypeSignatures = new String[parameterTypes.length];
            int i = 0;
            while (i < parameterTypes.length) {
                if (DTRTUtil.isEmpty(parameterTypes[i])) {
                    throw new CoreException(DTRTUtil.createErrorStatus("The type of the parameter cannot be null or an empty string."));
                }
                try {
                    parameterTypeSignatures[i] = Signature.createTypeSignature((String)parameterTypes[i], (boolean)false);
                }
                catch (RuntimeException runtimeException) {
                    parameterTypeSignatures[i] = parameterTypes[i];
                }
                ++i;
            }
        }
        String[] array = new String[parameterTypeSignatures.length * 2];
        int i = 0;
        while (i < parameterTypeSignatures.length) {
            array[i] = parameterTypeSignatures[i];
            String erasure = Signature.getTypeErasure((String)parameterTypeSignatures[i]);
            array[i + parameterTypeSignatures.length] = Signature.getSimpleName((String)Signature.toString((String)erasure));
            ++i;
        }
        return array;
    }

    public final boolean areSimilarMethodParameterCompareArrays(String[] array1, String[] array2) {
        if (array1 != null && array2 != null && array1.length == array2.length) {
            int numberOfParameters = array1.length / 2;
            boolean similar = true;
            int i = 0;
            while (i < numberOfParameters) {
                if (!DTRTUtil.equals(array1[i], array2[i])) {
                    similar = false;
                    break;
                }
                ++i;
            }
            if (!similar) {
                similar = true;
                i = numberOfParameters;
                while (i < array1.length) {
                    if (!DTRTUtil.equals(array1[i], array2[i])) {
                        similar = false;
                        break;
                    }
                    ++i;
                }
            }
            return similar;
        }
        return false;
    }

    public boolean matches(IType type, String name) {
        String trimmed;
        String fullyQualifiedName;
        return type != null && !DTRTUtil.isEmpty(name) && ((fullyQualifiedName = type.getFullyQualifiedName()).equals(name) || (trimmed = this.trimPackage(type, fullyQualifiedName)).equals(name) || fullyQualifiedName.replace('$', '.').equals(name) || trimmed.replace('$', '.').equals(name));
    }

    private String trimPackage(IType type, String fullyQualifiedName) {
        return type == null ? null : (type.getPackageFragment().isDefaultPackage() ? fullyQualifiedName : fullyQualifiedName.substring(type.getPackageFragment().getElementName().length() + 1));
    }

    protected TypeInfo getTypeInfo(IJavaElement javaElement, String signature) throws CoreException {
        TypeInfo typeInfo;
        try {
            typeInfo = this.doGetTypeInfo(javaElement, signature);
        }
        catch (SourceNameWasResolvedNotification e) {
            typeInfo = new TypeInfo().setSourceName(e.getSourceName());
        }
        return typeInfo;
    }

    private TypeInfo doGetTypeInfo(IJavaElement javaElement, String signature) throws CoreException, SourceNameWasResolvedNotification {
        int i;
        String typeName = this.toTypeName(signature);
        String className = this.toResolvedNameWithSourceNameResolvedException(javaElement, typeName);
        StringBuilder sourceNameBuilder = new StringBuilder(className);
        String[] typeArgumentSignatures = Signature.getTypeArguments((String)signature);
        if (typeArgumentSignatures.length > 0) {
            sourceNameBuilder.append('<');
            i = 0;
            while (i < typeArgumentSignatures.length) {
                TypeInfo detailTypeInfo;
                String typeArgumentSignature;
                if (i > 0) {
                    sourceNameBuilder.append(", ");
                }
                if ((typeArgumentSignature = typeArgumentSignatures[i]).startsWith("-")) {
                    sourceNameBuilder.append("? super ");
                    detailTypeInfo = this.doGetTypeInfo(javaElement, typeArgumentSignature.substring(1));
                } else if (typeArgumentSignature.startsWith("+")) {
                    sourceNameBuilder.append("? extends ");
                    detailTypeInfo = this.doGetTypeInfo(javaElement, typeArgumentSignature.substring(1));
                } else if (typeArgumentSignature.equals("*")) {
                    sourceNameBuilder.append("?");
                    detailTypeInfo = null;
                } else {
                    detailTypeInfo = this.doGetTypeInfo(javaElement, typeArgumentSignature);
                }
                if (detailTypeInfo != null) {
                    sourceNameBuilder.append(detailTypeInfo.getSourceName());
                }
                ++i;
            }
            sourceNameBuilder.append('>');
        }
        i = Signature.getArrayCount((String)signature);
        while (i > 0) {
            sourceNameBuilder.append("[]");
            --i;
        }
        TypeInfo typeInfo = new TypeInfo().setClassName(className);
        if (sourceNameBuilder.length() > className.length()) {
            typeInfo.setSourceName(sourceNameBuilder.toString());
        }
        return typeInfo;
    }

    private IMember getScope(IJavaElement javaElement) {
        return javaElement == null ? null : (javaElement instanceof IMember ? (IMember)javaElement : (javaElement instanceof ILocalVariable ? ((ILocalVariable)javaElement).getDeclaringMember() : this.getScope(javaElement.getParent())));
    }

    private IType getScopeType(IMember scope) {
        return scope instanceof IType ? (IType)scope : scope.getDeclaringType();
    }

    protected String toTypeName(String signature) throws CoreException {
        int arrayCount = Signature.getArrayCount((String)signature);
        char type = signature.charAt(arrayCount);
        if (type == 'Q') {
            int bracket = signature.indexOf(60, arrayCount + 1);
            if (bracket > 0) {
                return signature.substring(arrayCount + 1, bracket);
            }
            int semi = signature.indexOf(59, arrayCount + 1);
            if (semi == -1) {
                throw new CoreException(DTRTUtil.createErrorStatus("Invalid signature"));
            }
            return signature.substring(arrayCount + 1, semi);
        }
        try {
            return Signature.toString((String)signature.substring(arrayCount));
        }
        catch (RuntimeException e) {
            throw new CoreException(DTRTUtil.createErrorStatus(e));
        }
    }

    protected ITypeHierarchy getSuperTypeHierarchy(IType type) throws CoreException {
        return type.newSupertypeHierarchy(null);
    }

    protected void cacheSuperTypeHierarchy(IType type, IType[] superTypes, ITypeHierarchy typeHierarchy) throws CoreException {
    }

    private IType getDeclaringType(IAnnotatable annotatable) {
        return annotatable instanceof IType ? (IType)annotatable : (annotatable instanceof IMember ? ((IMember)annotatable).getDeclaringType() : (annotatable instanceof ILocalVariable ? ((ILocalVariable)annotatable).getDeclaringMember().getDeclaringType() : null));
    }

    private String toResolvedNameWithSourceNameResolvedException(IJavaElement javaElement, String typeName) throws CoreException, SourceNameWasResolvedNotification {
        String[] resolvedName = this.toResolvedName(javaElement, typeName);
        if (resolvedName.length == 2) {
            assert (resolvedName[0] == null);
            throw new SourceNameWasResolvedNotification(resolvedName[1]);
        }
        return resolvedName[0];
    }

    public final String toResolvedClassName(String[] resolvedName) {
        return resolvedName == null ? null : (resolvedName.length == 1 ? resolvedName[0] : TypeInfo.toClassName(resolvedName[1]));
    }

    public String[] toResolvedName(IJavaElement javaElement, String typeName) throws CoreException {
        String resolvedName;
        String resolvedName2;
        IType type;
        String[][] resolvedNameArray;
        if (JavaUtil.getPrimitiveOrVoidType(typeName) != null) {
            return new String[]{typeName};
        }
        IMember scope = this.getScope(javaElement);
        if (typeName.indexOf(46) < 0) {
            ITypeParameter[] typeParameters;
            Object object = scope instanceof IMethod ? ((IMethod)scope).getTypeParameters() : (typeParameters = javaElement instanceof IType ? ((IType)javaElement).getTypeParameters() : null);
            if (typeParameters != null && typeParameters.length > 0) {
                ITypeParameter[] iTypeParameterArray = typeParameters;
                int n = typeParameters.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeParameter typeParameter = iTypeParameterArray[n2];
                    if (typeName.equals(typeParameter.getElementName())) {
                        return new String[]{typeName};
                    }
                    ++n2;
                }
            }
        }
        if ((resolvedNameArray = (type = this.getScopeType(scope)).resolveType(typeName)) != null && resolvedNameArray.length > 0 && !DTRTUtil.isEmpty(resolvedName2 = resolvedNameArray[0][1])) {
            resolvedName2 = resolvedName2.replace('$', '.');
            String pack = resolvedNameArray[0][0];
            return new String[]{DTRTUtil.isEmpty(pack) ? resolvedName2 : String.valueOf(pack) + '.' + resolvedName2};
        }
        IType resolvedType = this.findType(type.getJavaProject(), typeName);
        if (resolvedType != null) {
            return new String[]{resolvedType.getFullyQualifiedName('.')};
        }
        if (typeName.indexOf(46) < 0 && !Flags.isStatic((int)type.getFlags())) {
            IType declaringType = scope.getDeclaringType();
            while (declaringType != null) {
                ITypeParameter[] iTypeParameterArray = declaringType.getTypeParameters();
                int n = iTypeParameterArray.length;
                int n3 = 0;
                while (n3 < n) {
                    ITypeParameter typeParameter = iTypeParameterArray[n3];
                    if (typeName.equals(typeParameter.getElementName())) {
                        return new String[]{typeName};
                    }
                    ++n3;
                }
                IType iType = declaringType = Flags.isStatic((int)declaringType.getFlags()) ? null : declaringType.getDeclaringType();
            }
        }
        if ((resolvedName = this.toASTResolvedSourceName(javaElement)) != null) {
            String[] stringArray = new String[2];
            stringArray[1] = resolvedName.replace('$', '.');
            return stringArray;
        }
        throw new CoreException(DTRTUtil.createErrorStatus("Cannot resolve '%s' for the type '%s'", typeName, type.getFullyQualifiedName()));
    }

    private String toASTResolvedSourceName(IJavaElement javaElement) throws CoreException {
        ASTNode astNode = this.parse(javaElement);
        if (astNode instanceof MethodDeclaration) {
            return this.toASTResolvedSourceName(((MethodDeclaration)astNode).getReturnType2());
        }
        if (astNode instanceof VariableDeclarationFragment) {
            VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)astNode;
            StringBuilder sb = new StringBuilder(this.toASTResolvedSourceName(((FieldDeclaration)variableDeclarationFragment.getParent()).getType()));
            int i = variableDeclarationFragment.getExtraDimensions();
            while (i > 0) {
                sb.append("[]");
                --i;
            }
            return sb.toString();
        }
        if (astNode instanceof SingleVariableDeclaration) {
            SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)astNode;
            StringBuilder sb = new StringBuilder(this.toASTResolvedSourceName(singleVariableDeclaration.getType()));
            int i = singleVariableDeclaration.getExtraDimensions();
            int min = singleVariableDeclaration.isVarargs() ? -1 : 0;
            while (i > min) {
                sb.append("[]");
                --i;
            }
            return sb.toString();
        }
        return null;
    }

    private ASTNode parse(IJavaElement javaElement) throws CoreException {
        CompilationUnit astCompilationUnit;
        IMember scope = this.getScope(javaElement);
        ICompilationUnit source = scope.getCompilationUnit();
        if (source == null) {
            source = scope.getClassFile();
        }
        if (source != null && (astCompilationUnit = this.getCompilationUnit((IJavaElement)source)) != null) {
            return this.findNode(astCompilationUnit, javaElement);
        }
        return null;
    }

    protected CompilationUnit getCompilationUnit(IJavaElement source) throws CoreException {
        ASTParser parser = ASTParser.newParser((int)4);
        parser.setResolveBindings(true);
        parser.setStatementsRecovery(true);
        parser.setIgnoreMethodBodies(true);
        if (source instanceof ICompilationUnit) {
            parser.setSource((ICompilationUnit)source);
        } else {
            parser.setSource((IClassFile)source);
        }
        return (CompilationUnit)parser.createAST(null);
    }

    private ASTNode findNode(CompilationUnit astCompilationUnit, IJavaElement javaElement) throws CoreException {
        IMember scope;
        IType type;
        AbstractTypeDeclaration abstractTypeDeclaration;
        ASTNode node;
        String key = this.getJavaElementKey(javaElement);
        ASTNode aSTNode = node = key != null ? astCompilationUnit.findDeclaringNode(key) : null;
        if (node == null && (abstractTypeDeclaration = this.findTypeDeclarationByName(astCompilationUnit, type = this.getScopeType(scope = this.getScope(javaElement)))) != null) {
            List bodyDeclarations = abstractTypeDeclaration.bodyDeclarations();
            block0: for (Object o : bodyDeclarations) {
                int index;
                IMethodBinding binding;
                BodyDeclaration bodyDeclaration = (BodyDeclaration)o;
                if (javaElement instanceof IField) {
                    if (!(bodyDeclaration instanceof FieldDeclaration)) continue;
                    FieldDeclaration fieldDeclaration = (FieldDeclaration)bodyDeclaration;
                    List variableDeclarationFragments = fieldDeclaration.fragments();
                    for (Object o1 : variableDeclarationFragments) {
                        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)o1;
                        if (!javaElement.getElementName().equals(variableDeclarationFragment.getName().getFullyQualifiedName())) continue;
                        node = variableDeclarationFragment;
                        break block0;
                    }
                    continue;
                }
                if (!(javaElement instanceof IMethod) && (!(javaElement instanceof ILocalVariable) || !(scope instanceof IMethod)) || !(bodyDeclaration instanceof MethodDeclaration) || (binding = ((MethodDeclaration)bodyDeclaration).resolveBinding()) == null) continue;
                IJavaElement nodeJavaElement = binding.getJavaElement();
                assert (nodeJavaElement instanceof IMethod) : nodeJavaElement;
                assert (bodyDeclaration instanceof MethodDeclaration) : bodyDeclaration;
                if (javaElement instanceof IMethod) {
                    if (!javaElement.equals(nodeJavaElement)) continue;
                    node = bodyDeclaration;
                    break;
                }
                if (!scope.equals(nodeJavaElement)) continue;
                ILocalVariable localVariable = (ILocalVariable)javaElement;
                if (!localVariable.isParameter() || (index = DTRTUtil.indexOf(((IMethod)localVariable.getDeclaringMember()).getParameters(), localVariable)) < 0) break;
                MethodDeclaration methodDeclaration = (MethodDeclaration)bodyDeclaration;
                node = (ASTNode)methodDeclaration.parameters().get(index);
                break;
            }
        }
        return node;
    }

    private String getJavaElementKey(IJavaElement javaElement) {
        return javaElement instanceof IType ? ((IType)javaElement).getKey() : (javaElement instanceof IMethod ? ((IMethod)javaElement).getKey() : (javaElement instanceof IField ? ((IField)javaElement).getKey() : (javaElement instanceof ILocalVariable ? this.getJavaElementKey((IJavaElement)((ILocalVariable)javaElement).getDeclaringMember()) : null)));
    }

    private AbstractTypeDeclaration findTypeDeclarationByName(CompilationUnit astCompilationUnit, IType type) {
        IType declaringType = type.getDeclaringType();
        if (declaringType == null) {
            AbstractTypeDeclaration typeDeclaration = this.findTypeDeclarationByName(astCompilationUnit.types(), type);
            if (typeDeclaration != null) {
                return typeDeclaration;
            }
        } else {
            AbstractTypeDeclaration typeDeclaration;
            AbstractTypeDeclaration declaringTypeDeclaration = this.findTypeDeclarationByName(astCompilationUnit, declaringType);
            if (declaringTypeDeclaration != null && (typeDeclaration = this.findTypeDeclarationByName(declaringTypeDeclaration.bodyDeclarations(), type)) != null) {
                return typeDeclaration;
            }
        }
        return null;
    }

    private AbstractTypeDeclaration findTypeDeclarationByName(List<?> list, IType type) {
        for (Object o : list) {
            AbstractTypeDeclaration typeDeclaration;
            if (!(o instanceof AbstractTypeDeclaration) || !(typeDeclaration = (AbstractTypeDeclaration)o).getName().getFullyQualifiedName().equals(type.getElementName())) continue;
            return typeDeclaration;
        }
        return null;
    }

    private String toASTResolvedSourceName(Type type) throws CoreException {
        if (type instanceof PrimitiveType) {
            return ((PrimitiveType)type).getPrimitiveTypeCode().toString();
        }
        if (type instanceof SimpleType || type instanceof QualifiedType) {
            ITypeBinding typeBinding = type.resolveBinding();
            if (typeBinding != null) {
                String name = typeBinding.getQualifiedName();
                if (name == null) {
                    name = typeBinding.getName();
                }
                return TypeInfo.toClassName(name);
            }
            return null;
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            return String.valueOf(this.toASTResolvedSourceName(arrayType.getComponentType())) + "[]";
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            StringBuilder sb = new StringBuilder(this.toASTResolvedSourceName(parameterizedType.getType()));
            List list = parameterizedType.typeArguments();
            sb.append('<');
            int i = 0;
            while (i < list.size()) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(this.toASTResolvedSourceName((Type)list.get(i)));
                ++i;
            }
            return sb.append('>').toString();
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type bound = wildcardType.getBound();
            if (bound != null) {
                StringBuilder sb = new StringBuilder(wildcardType.isUpperBound() ? "? extends " : "? super ");
                sb.append(this.toASTResolvedSourceName(bound));
                return sb.toString();
            }
            return "?";
        }
        if (type instanceof UnionType) {
            UnionType unionType = (UnionType)type;
            StringBuilder sb = new StringBuilder();
            List list = unionType.types();
            int i = 0;
            while (i < list.size()) {
                if (i != 0) {
                    sb.append('|');
                }
                sb.append(this.toASTResolvedSourceName((Type)list.get(i)));
                ++i;
            }
            return sb.toString();
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    protected IAnnotation getAnnotation(IAnnotatable annotatable, String annotationName) throws CoreException {
        IAnnotation[] annotations = annotatable.getAnnotations();
        if (annotations.length > 0) {
            IAnnotation[] iAnnotationArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotation annotation = iAnnotationArray[n2];
                if (annotation.getElementName().equals(annotationName)) {
                    return annotation;
                }
                ++n2;
            }
            IType declaringType = this.getDeclaringType(annotatable);
            assert (declaringType != null) : annotatable;
            String annotationSimpleName = JavaUtil.toSimpleName(annotationName);
            IAnnotation[] iAnnotationArray2 = annotations;
            int n3 = annotations.length;
            int n4 = 0;
            while (n4 < n3) {
                IAnnotation annotation = iAnnotationArray2[n4];
                if (JavaUtil.toSimpleName(annotation.getElementName()).equals(annotationSimpleName)) {
                    String annotationClassName = this.toResolvedClassName(this.toResolvedName((IJavaElement)declaringType, annotation.getElementName()));
                    if (this.matches(this.findType(declaringType.getJavaProject(), annotationClassName), annotationName)) {
                        return annotation;
                    }
                }
                ++n4;
            }
        }
        return null;
    }

    private void setValues(AnnotationMemberValue annotationMemberValue) {
        if (annotationMemberValue.getRawValues().length == 0 || annotationMemberValue.getValueKind() == AnnotationMemberValue.ValueKind.UNKNOWN) {
            annotationMemberValue.setValues(annotationMemberValue.getRawValues());
        } else {
            Object[] rawValues = annotationMemberValue.getRawValues();
            Object[] values = new Object[rawValues.length];
            int i = 0;
            while (i < rawValues.length) {
                values[i] = this.computeValue(annotationMemberValue.getAnnotation(), annotationMemberValue.getValueKind(), rawValues[i]);
                ++i;
            }
            annotationMemberValue.setValues(values);
        }
    }

    private Object computeValue(IAnnotation annotation, AnnotationMemberValue.ValueKind valueKind, Object rawValue) {
        if (rawValue instanceof Object[]) {
            Object[] array = (Object[])rawValue;
            String[] valueArray = new String[array.length];
            int i = 0;
            while (i < array.length) {
                valueArray[i] = this.computeValue(annotation, valueKind, array[i]);
                ++i;
            }
            return valueArray;
        }
        try {
            switch (valueKind) {
                case CLASS: {
                    String resovedName = this.toResolvedClassName(this.toResolvedName((IJavaElement)annotation, (String)rawValue));
                    IType type = this.findType(annotation.getJavaProject(), resovedName);
                    if (type != null) {
                        return type;
                    }
                }
                case QUALIFIED_NAME: {
                    String[] dottedNames = JavaUtil.computeDottedNames((String)rawValue);
                    int i = 0;
                    while (i < dottedNames.length) {
                        if (!dottedNames[i].equals(dottedNames[i].toLowerCase())) {
                            try {
                                String resovedName = this.toResolvedClassName(this.toResolvedName((IJavaElement)annotation, dottedNames[i]));
                                IType type = this.findType(annotation.getJavaProject(), resovedName);
                                if (type != null) {
                                    IField field;
                                    while (--i > 0 && type != null) {
                                        type = this.findMemberType(type, dottedNames[i]);
                                    }
                                    if (type != null && (field = type.getField(JavaUtil.toSimpleName(dottedNames[0]))).exists()) {
                                        return field;
                                    }
                                }
                            }
                            catch (Exception exception) {}
                        }
                        ++i;
                    }
                }
                case SIMPLE_NAME: {
                    String name = (String)rawValue;
                    IJavaElement parent = annotation.getParent();
                    while (parent != null) {
                        IField field;
                        if (parent instanceof IType && (field = ((IType)parent).getField(name)).exists()) {
                            return field;
                        }
                        parent = parent.getParent();
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            DTRTBundle.log(e);
        }
        return rawValue;
    }

    protected Map<String, String> doGetErasedTypeParameters(IJavaElement javaElement) throws CoreException {
        if (javaElement != null) {
            Map<Object, Object> erasedTypeParameterFromDeclaringTypesMap;
            ITypeParameter[] typeParameters;
            assert (javaElement instanceof IType || javaElement instanceof IMethod) : javaElement;
            if (javaElement instanceof IType) {
                IType type = (IType)javaElement;
                typeParameters = type.getTypeParameters();
                erasedTypeParameterFromDeclaringTypesMap = type.getDeclaringType() != null && !Flags.isStatic((int)type.getFlags()) ? this.doGetErasedTypeParameters((IJavaElement)type.getDeclaringType()) : Collections.emptyMap();
            } else {
                IMethod method = (IMethod)javaElement;
                typeParameters = method.getTypeParameters();
                erasedTypeParameterFromDeclaringTypesMap = this.doGetErasedTypeParameters((IJavaElement)method.getDeclaringType());
            }
            HashMap<String, String> map = new HashMap<String, String>(typeParameters.length + erasedTypeParameterFromDeclaringTypesMap.size());
            ITypeParameter[] iTypeParameterArray = typeParameters;
            int n = typeParameters.length;
            int n2 = 0;
            while (n2 < n) {
                String erasure;
                ITypeParameter typeParameter = iTypeParameterArray[n2];
                String[] bounds = typeParameter.getBounds();
                if (bounds.length == 0) {
                    erasure = Object.class.getName();
                } else {
                    String bound = bounds[bounds.length - 1];
                    String resolvedClassName = this.toResolvedClassName(this.toResolvedName(javaElement, bound));
                    if (resolvedClassName.indexOf(46) < 0) {
                        erasure = (String)map.get(resolvedClassName);
                        if (erasure == null && (erasure = (String)erasedTypeParameterFromDeclaringTypesMap.get(resolvedClassName)) == null) {
                            erasure = resolvedClassName;
                        }
                    } else {
                        erasure = resolvedClassName;
                    }
                }
                map.put(typeParameter.getElementName(), erasure);
                ++n2;
            }
            for (Map.Entry<Object, Object> entry : erasedTypeParameterFromDeclaringTypesMap.entrySet()) {
                if (map.containsKey(entry.getKey()) || !((String)entry.getKey()).equals(this.toResolvedClassName(this.toResolvedName(javaElement, (String)entry.getKey())))) continue;
                map.put((String)entry.getKey(), (String)entry.getValue());
            }
            return Collections.unmodifiableMap(map);
        }
        return Collections.emptyMap();
    }

    private boolean isMultiValue(IAnnotation annotation, IMemberValuePair memberValuePair) throws CoreException {
        if (memberValuePair.getValue() instanceof Object[]) {
            return true;
        }
        IType annotationType = this.getAnnotationType(annotation);
        if (annotationType != null) {
            IMethod[] iMethodArray = annotationType.getMethods();
            int n = iMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                if (method.getElementName().equals(memberValuePair.getMemberName())) {
                    return Signature.getArrayCount((String)method.getReturnType()) > 0;
                }
                ++n2;
            }
        }
        return false;
    }

    private static class SourceNameWasResolvedNotification
    extends Exception {
        private static final long serialVersionUID = 1L;
        private String sourceName;

        public SourceNameWasResolvedNotification(String sourceName) {
            this.sourceName = sourceName;
        }

        public String getSourceName() {
            return this.sourceName;
        }
    }
}

