/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import oracle.eclipse.tools.adf.common.JRFVersion;
import oracle.eclipse.tools.adf.dtrt.impl.IDTRTImplementation;
import oracle.eclipse.tools.adf.dtrt.internal.DTRTBundle;
import oracle.eclipse.tools.application.common.services.metadata.IVersion;
import oracle.eclipse.tools.application.common.services.metadata.internal.DefaultVersionFactory;
import oracle.eclipse.tools.application.common.services.metadata.internal.IVersionRange;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.Platform;

class ImplementationProviderManager {
    public static final ImplementationProviderManager INSTANCE = new ImplementationProviderManager();
    private static final String EXTENSION_POINT_ELEMENT_NAME = "implementationProvider";
    private static final String EXTENSION_POINT_ID = "oracle.eclipse.tools.adf.dtrt.implementationProviders";
    private static DefaultVersionFactory versionFactory;
    private List<DTRTImplementationProviderHelper> helpers;
    private IRegistryEventListener registryEventListener;

    private ImplementationProviderManager() {
    }

    private static DefaultVersionFactory getVersionFactory() {
        return versionFactory == null ? (versionFactory = new DefaultVersionFactory()) : versionFactory;
    }

    public void reset() {
        this.helpers = null;
        if (this.registryEventListener != null) {
            Platform.getExtensionRegistry().removeListener(this.registryEventListener);
            this.registryEventListener = null;
        }
    }

    public List<IDTRTImplementation> getDTRTImplementations(JRFVersion version) {
        if (version != null) {
            try {
                this.initialize();
                if (!this.helpers.isEmpty()) {
                    ArrayList<IDTRTImplementation> implementations = new ArrayList<IDTRTImplementation>(this.helpers.size());
                    Iterator<DTRTImplementationProviderHelper> i = this.helpers.iterator();
                    while (i.hasNext()) {
                        DTRTImplementationProviderHelper helper = i.next();
                        if (helper.getDTRTImplementation() != null) {
                            if (!helper.matches(version)) continue;
                            implementations.add(helper.getDTRTImplementation());
                            continue;
                        }
                        i.remove();
                    }
                    return implementations;
                }
            }
            catch (RuntimeException e) {
                DTRTBundle.log("An error occurred while handling the extension point oracle.eclipse.tools.adf.dtrt.implementationProviders", e);
            }
        }
        return new ArrayList<IDTRTImplementation>(0);
    }

    public List<IDTRTImplementation> getDTRTImplementations(String contributorName) {
        try {
            this.initialize();
            if (this.helpers != null && !this.helpers.isEmpty()) {
                ArrayList<IDTRTImplementation> implementations = new ArrayList<IDTRTImplementation>(this.helpers.size());
                Iterator<DTRTImplementationProviderHelper> i = this.helpers.iterator();
                while (i.hasNext()) {
                    DTRTImplementationProviderHelper helper = i.next();
                    if (helper.getDTRTImplementation() != null) {
                        if (!helper.isFromContributor(contributorName)) continue;
                        implementations.add(helper.getDTRTImplementation());
                        continue;
                    }
                    i.remove();
                }
                return implementations;
            }
        }
        catch (RuntimeException e) {
            DTRTBundle.log("An error occurred while handling the extension point oracle.eclipse.tools.adf.dtrt.implementationProviders", e);
        }
        return new ArrayList<IDTRTImplementation>(0);
    }

    private void initialize() {
        if (this.registryEventListener == null) {
            this.registryEventListener = new IRegistryEventListener(){

                public void added(IExtension[] extensions) {
                    IExtension[] iExtensionArray = extensions;
                    int n = extensions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IExtension extension = iExtensionArray[n2];
                        ImplementationProviderManager.this.initialize();
                        ImplementationProviderManager.this.load(extension.getConfigurationElements());
                        ++n2;
                    }
                }

                public void removed(IExtension[] extensions) {
                    HashSet<String> contributorNames = new HashSet<String>(extensions.length / 2 + 1);
                    IExtension[] iExtensionArray = extensions;
                    int n = extensions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IExtension extension = iExtensionArray[n2];
                        IContributor contributor = extension.getContributor();
                        if (contributor != null && contributor.getName() != null && contributorNames.add(contributor.getName())) {
                            ImplementationProviderManager.this.unload(contributor.getName());
                        }
                        ++n2;
                    }
                }

                public void added(IExtensionPoint[] extensionPoints) {
                }

                public void removed(IExtensionPoint[] extensionPoints) {
                }
            };
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            extensionRegistry.addListener(this.registryEventListener, EXTENSION_POINT_ID);
            IExtensionPoint point = extensionRegistry.getExtensionPoint(EXTENSION_POINT_ID);
            if (point != null) {
                this.helpers = new ArrayList<DTRTImplementationProviderHelper>();
                this.load(point.getConfigurationElements());
            }
        }
    }

    private void load(IConfigurationElement[] configurationElements) {
        if (this.helpers != null) {
            IConfigurationElement[] iConfigurationElementArray = configurationElements;
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                if (EXTENSION_POINT_ELEMENT_NAME.equals(configurationElement.getName()) && configurationElement.getAttribute("class") != null) {
                    this.helpers.add(new DTRTImplementationProviderHelper(configurationElement));
                }
                ++n2;
            }
        }
    }

    private void unload(String contributorName) {
        if (this.helpers != null) {
            Iterator<DTRTImplementationProviderHelper> i = this.helpers.iterator();
            while (i.hasNext()) {
                DTRTImplementationProviderHelper helper = i.next();
                if (!helper.isFromContributor(contributorName)) continue;
                i.remove();
            }
        }
    }

    private static class DTRTImplementationProviderHelper {
        private IConfigurationElement configurationElement;
        private IDTRTImplementation dtrtImplementation;
        private String contributorName;
        private Object version;

        public DTRTImplementationProviderHelper(IConfigurationElement configurationElement) {
            this.configurationElement = configurationElement;
            this.version = configurationElement.getAttribute("version");
        }

        public IDTRTImplementation getDTRTImplementation() {
            if (this.dtrtImplementation == null && this.configurationElement != null && this.configurationElement.isValid() && this.configurationElement.getContributor() != null) {
                Object object = null;
                try {
                    object = this.configurationElement.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    DTRTBundle.log("Unable to create executable extension from " + this.configurationElement, e);
                }
                if (object instanceof IDTRTImplementation) {
                    this.contributorName = this.configurationElement.getContributor().getName();
                    this.dtrtImplementation = (IDTRTImplementation)object;
                }
            }
            if (this.dtrtImplementation == null) {
                this.configurationElement = null;
            }
            return this.dtrtImplementation;
        }

        public boolean matches(JRFVersion jrfVersion) {
            if (this.version instanceof String) {
                try {
                    String stringVersion = (String)this.version;
                    this.version = ImplementationProviderManager.getVersionFactory().isVersionRange(stringVersion) ? ImplementationProviderManager.getVersionFactory().getVersionRange(stringVersion) : ImplementationProviderManager.getVersionFactory().getVersion(stringVersion);
                }
                catch (Exception e) {
                    this.version = null;
                    DTRTBundle.log(e);
                    return false;
                }
            }
            return this.version instanceof IVersionRange && ((IVersionRange)this.version).contains(jrfVersion.getVersion()) || this.version instanceof IVersion && ((IVersion)this.version).compareTo((Object)jrfVersion.getVersion()) == 0;
        }

        public boolean isFromContributor(String name) {
            return name != null && this.contributorName != null && this.contributorName.equals(name);
        }
    }
}

