/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.repositories.core.auth.ICredentialsStore;
import org.eclipse.mylyn.internal.tasks.core.util.KeyringMigrator;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class TaskRepositoryKeyringMigrator
extends KeyringMigrator<TaskRepository> {
    private static final String KEY_USERNAME = "org.eclipse.mylyn.tasklist.repositories.username";
    protected static URL defaultUrl;

    static {
        try {
            defaultUrl = new URL("http://eclipse.org/mylyn");
        }
        catch (MalformedURLException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", e.getMessage(), (Throwable)e));
        }
    }

    public TaskRepositoryKeyringMigrator(String authRealm, String authScheme) {
        super(authRealm, authScheme);
    }

    @Override
    public void migrateCredentials(Collection<TaskRepository> locations) {
        StatusHandler.log((IStatus)new Status(1, "org.eclipse.mylyn.tasks.core", "Migrating task repository credentials from keyring."));
        super.migrateCredentials(locations);
    }

    @Override
    protected void migrateCredentials(TaskRepository location) {
        super.migrateCredentials(location);
        AuthenticationCredentials credentials = location.getCredentials(AuthenticationType.REPOSITORY);
        if (credentials != null) {
            location.setCredentials(AuthenticationType.REPOSITORY, credentials, location.getSavePassword(AuthenticationType.REPOSITORY));
        }
    }

    @Override
    protected Map<String, String> getAuthorizationInfo(String url) throws MalformedURLException {
        try {
            return super.getAuthorizationInfo(url);
        }
        catch (MalformedURLException malformedURLException) {
            return Platform.getAuthorizationInfo((URL)defaultUrl, (String)url, (String)this.authScheme);
        }
    }

    @Override
    protected String getUrl(TaskRepository location) {
        return location.getRepositoryUrl();
    }

    @Override
    protected void putKeyValue(TaskRepository location, String key, String value, ICredentialsStore store) {
        if (KEY_USERNAME.equals(key)) {
            location.setProperty(key, value);
        } else {
            super.putKeyValue(location, key, value, store);
        }
    }
}

