/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.project;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.internal.project.registry.MavenProjectManager;
import org.eclipse.m2e.core.project.IMavenProjectChangedListener;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceStateWriter
implements IMavenProjectChangedListener {
    private static QualifiedName PPROP_EXTENSION = new QualifiedName(WorkspaceStateWriter.class.getName(), "extension");
    private static final Logger log = LoggerFactory.getLogger(WorkspaceStateWriter.class);
    private MavenProjectManager projectManager;

    public WorkspaceStateWriter(MavenProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    @Override
    public void mavenProjectChanged(MavenProjectChangedEvent[] events, IProgressMonitor monitor) {
        try {
            Properties state = new Properties();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IMavenProjectFacade[] iMavenProjectFacadeArray = this.projectManager.getProjects();
            int n = iMavenProjectFacadeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMavenProjectFacade projectFacade = iMavenProjectFacadeArray[n2];
                IProject project = projectFacade.getProject();
                if (!project.isAccessible()) {
                    log.debug("Project registry contains closed project {}", (Object)project);
                } else {
                    try {
                        File pom;
                        ArtifactKey artifact = projectFacade.getArtifactKey();
                        IFile pomFile = projectFacade.getPom();
                        IPath location = pomFile.getLocation();
                        if (location != null && (pom = location.toFile()).canRead()) {
                            String key = String.valueOf(artifact.getGroupId()) + ":" + artifact.getArtifactId() + ":pom:" + artifact.getVersion();
                            state.put(key, pom.getCanonicalPath());
                        }
                        IResource outputLocation = root.findMember(projectFacade.getOutputLocation());
                        if (!"pom".equals(projectFacade.getPackaging()) && outputLocation != null && outputLocation.exists()) {
                            MavenProject mavenProject = projectFacade.getMavenProject();
                            String extension = mavenProject != null ? this.getAndPersistArtifactExtension(project, mavenProject) : project.getPersistentProperty(PPROP_EXTENSION);
                            if (extension == null && mavenProject == null) {
                                extension = this.getAndPersistArtifactExtension(project, projectFacade.getMavenProject(monitor));
                            }
                            if (extension != null) {
                                String key = String.valueOf(artifact.getGroupId()) + ":" + artifact.getArtifactId() + ":" + extension + ":" + artifact.getVersion();
                                state.put(key, outputLocation.getLocation().toFile().getCanonicalPath());
                            } else {
                                log.warn("Could not determine project {} main artifact extension.", (Object)project);
                            }
                        }
                    }
                    catch (CoreException ex) {
                        log.error("Error writing workspace state file", (Throwable)ex);
                    }
                }
                ++n2;
            }
            BufferedOutputStream buf = new BufferedOutputStream(new FileOutputStream(this.projectManager.getWorkspaceStateFile()));
            try {
                state.store(buf, null);
            }
            finally {
                ((OutputStream)buf).close();
            }
        }
        catch (IOException ex) {
            log.error("Error writing workspace state file", (Throwable)ex);
        }
    }

    private String getAndPersistArtifactExtension(IProject project, MavenProject mavenProject) throws CoreException {
        String extension = mavenProject.getArtifact().getArtifactHandler().getExtension();
        project.setPersistentProperty(PPROP_EXTENSION, extension);
        return extension;
    }
}

