/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ICallable;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.internal.M2EUtils;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.builder.BuildDebugHook;
import org.eclipse.m2e.core.internal.builder.DeltaProvider;
import org.eclipse.m2e.core.internal.builder.MavenBuilderImpl;
import org.eclipse.m2e.core.internal.markers.IMavenMarkerManager;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.configurator.AbstractBuildParticipant;
import org.eclipse.m2e.core.project.configurator.ILifecycleMapping;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenBuilder
extends IncrementalProjectBuilder
implements DeltaProvider {
    static Logger log = LoggerFactory.getLogger(MavenBuilder.class);
    final MavenBuilderImpl builder = new MavenBuilderImpl(this);
    final IMaven maven = MavenPlugin.getMaven();
    final IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
    final IProjectConfigurationManager configurationManager = MavenPlugin.getProjectConfigurationManager();
    final IMavenConfiguration mavenConfiguration = MavenPlugin.getMavenConfiguration();
    final IMavenMarkerManager markerManager = MavenPluginActivator.getDefault().getMavenMarkerManager();
    private static final List<BuildDebugHook> debugHooks = new ArrayList<BuildDebugHook>();

    protected IProject[] build(final int kind, final Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        final IProject project = this.getProject();
        log.debug("Building project {}", (Object)project.getName());
        final long start = System.currentTimeMillis();
        this.markerManager.deleteMarkers((IResource)project, kind == 6, "org.eclipse.m2e.core.maven2Problem.build");
        if (!project.hasNature("org.eclipse.m2e.core.maven2Nature")) {
            return null;
        }
        final IFile pomResource = project.getFile("pom.xml");
        if (pomResource == null) {
            log.error("Project {} does not have pom.xml", (Object)project.getName());
            return null;
        }
        return this.maven.execute(new ICallable<IProject[]>(){

            @Override
            public IProject[] call(IMavenExecutionContext context, IProgressMonitor monitor) throws CoreException {
                final IMavenProjectFacade projectFacade = MavenBuilder.this.getProjectFacade(pomResource, project, monitor);
                if (projectFacade == null) {
                    return null;
                }
                return MavenBuilder.this.projectManager.execute(projectFacade, new ICallable<IProject[]>(){

                    @Override
                    public IProject[] call(IMavenExecutionContext context, IProgressMonitor monitor) throws CoreException {
                        try {
                            projectFacade.getMavenProject(monitor);
                        }
                        catch (CoreException ce) {
                            MavenBuilder.this.addErrorMarker(project, (Exception)((Object)ce));
                            monitor.done();
                            return null;
                        }
                        ILifecycleMapping lifecycleMapping = (this).MavenBuilder.this.configurationManager.getLifecycleMapping(projectFacade);
                        if (lifecycleMapping == null) {
                            return null;
                        }
                        Map<MojoExecutionKey, List<AbstractBuildParticipant>> buildParticipantsByMojoExecutionKey = lifecycleMapping.getBuildParticipants(projectFacade, monitor);
                        Set<IProject> dependencies = (this).MavenBuilder.this.builder.build(context.getSession(), projectFacade, kind, args, buildParticipantsByMojoExecutionKey, monitor);
                        log.debug("Built project {} in {} ms", (Object)project.getName(), (Object)(System.currentTimeMillis() - start));
                        if (dependencies.isEmpty()) {
                            return null;
                        }
                        return dependencies.toArray(new IProject[dependencies.size()]);
                    }
                }, monitor);
            }
        }, monitor);
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        final IProject project = this.getProject();
        this.markerManager.deleteMarkers((IResource)project, "org.eclipse.m2e.core.maven2Problem.build");
        if (!project.hasNature("org.eclipse.m2e.core.maven2Nature")) {
            return;
        }
        IFile pomResource = project.getFile("pom.xml");
        if (pomResource == null) {
            return;
        }
        this.maven.execute(new ICallable<Void>(){

            @Override
            public Void call(IMavenExecutionContext context, IProgressMonitor monitor) throws CoreException {
                final IMavenProjectFacade projectFacade = MavenBuilder.this.projectManager.create(MavenBuilder.this.getProject(), monitor);
                if (projectFacade == null) {
                    return null;
                }
                return MavenBuilder.this.projectManager.execute(projectFacade, new ICallable<Void>(){

                    @Override
                    public Void call(IMavenExecutionContext context, IProgressMonitor monitor) throws CoreException {
                        if (projectFacade.getMavenProject(monitor) == null) {
                            return null;
                        }
                        ILifecycleMapping lifecycleMapping = (this).MavenBuilder.this.configurationManager.getLifecycleMapping(projectFacade);
                        if (lifecycleMapping == null) {
                            return null;
                        }
                        Map<MojoExecutionKey, List<AbstractBuildParticipant>> buildParticipantsByMojoExecutionKey = lifecycleMapping.getBuildParticipants(projectFacade, monitor);
                        try {
                            projectFacade.getMavenProject(monitor);
                        }
                        catch (CoreException ce) {
                            MavenBuilder.this.addErrorMarker(project, (Exception)((Object)ce));
                            return null;
                        }
                        (this).MavenBuilder.this.builder.clean(context.getSession(), projectFacade, buildParticipantsByMojoExecutionKey, monitor);
                        return null;
                    }
                }, monitor);
            }
        }, monitor);
    }

    void addErrorMarker(IProject project, Exception e) {
        String msg = e.getMessage();
        String rootCause = M2EUtils.getRootCauseMessage(e);
        if (!e.equals(msg)) {
            msg = String.valueOf(msg) + ": " + rootCause;
        }
        IMavenMarkerManager markerManager = MavenPluginActivator.getDefault().getMavenMarkerManager();
        markerManager.addMarker((IResource)project, "org.eclipse.m2e.core.maven2Problem.build", msg, 1, 2);
    }

    IMavenProjectFacade getProjectFacade(IFile pomResource, IProject project, IProgressMonitor monitor) throws CoreException {
        boolean force = false;
        IResourceDelta delta = this.getDelta(project);
        if (delta != null) {
            force = (delta = delta.findMember(pomResource.getFullPath())) != null && delta.getKind() == 4;
        }
        IMavenProjectFacade projectFacade = this.projectManager.create(this.getProject(), monitor);
        if (force || projectFacade == null || projectFacade.isStale()) {
            this.projectManager.refresh(Collections.singleton(pomResource), monitor);
            projectFacade = this.projectManager.create(project, monitor);
            if (projectFacade == null) {
                return null;
            }
        }
        return projectFacade;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDebugHook(BuildDebugHook hook) {
        List<BuildDebugHook> list = debugHooks;
        synchronized (list) {
            for (BuildDebugHook other : debugHooks) {
                if (other != hook) continue;
                return;
            }
            debugHooks.add(hook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDebugHook(BuildDebugHook hook) {
        List<BuildDebugHook> list = debugHooks;
        synchronized (list) {
            ListIterator<BuildDebugHook> iter = debugHooks.listIterator();
            while (iter.hasNext()) {
                if (iter.next() != hook) continue;
                iter.remove();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<BuildDebugHook> getDebugHooks() {
        List<BuildDebugHook> list = debugHooks;
        synchronized (list) {
            return new ArrayList<BuildDebugHook>(debugHooks);
        }
    }
}

