/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudlogic.javaservice.admin.impl.javacloud.wlst;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.io.OutputStream;
import oracle.cloudlogic.javaservice.admin.impl.javacloud.RestUtils;
import oracle.cloudlogic.javaservice.admin.impl.javacloud.wlst.WLSTLogFetcher;
import oracle.cloudlogic.javaservice.common.api.exception.ServiceException;
import oracle.cloudlogic.javaservice.common.api.exception.UnknownResourceException;
import oracle.cloudlogic.javaservice.common.api.service.ResourceService;
import oracle.cloudlogic.javaservice.common.api.service.resource.wlst.WLSTAccessShellService;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;
import oracle.cloudlogic.javaservice.types.CommandType;
import oracle.cloudlogic.javaservice.types.ObjectFactory;
import oracle.cloudlogic.javaservice.types.UserInstanceType;

public class WLSTAccessShellServiceImpl
implements WLSTAccessShellService {
    protected Client jerseyClient = null;
    protected String baseUrl = null;
    protected ResourceService resourceService;
    private String sessionid = null;
    WLSTLogFetcher logFetcher = null;

    public WLSTAccessShellServiceImpl(Client jerseyClient, String baseUrl, ResourceService resource) {
        this.jerseyClient = jerseyClient;
        this.baseUrl = baseUrl;
        this.resourceService = resource;
    }

    private void sessionInit(String sessionid, OutputStream out) throws Exception {
        this.sessionid = sessionid;
        if (sessionid == null) {
            throw new Exception("No session id found.");
        }
        Logger.getDEFAULT().printlnDebug("Session id:" + sessionid);
        this.logFetcher = new WLSTLogFetcher(this.jerseyClient, this.baseUrl, out, sessionid);
        this.logFetcher.start();
    }

    public boolean initWLSTSession(OutputStream outputStream) throws ServiceException {
        try {
            if (this.logFetcher != null) {
                throw new RuntimeException("Session is active.");
            }
            if (outputStream == null) {
                outputStream = System.out;
            }
            WebResource w = this.jerseyClient.resource(this.baseUrl);
            w = w.path("init");
            Logger.getDEFAULT().printlnDebug("PUT at " + w.getURI().toString());
            ClientResponse r = (ClientResponse)w.accept(new String[]{"application/xml"}).put(ClientResponse.class);
            if (r.getStatus() == 201) {
                this.sessionInit((String)r.getHeaders().getFirst((Object)"X-SHELL-SESSION-ID"), outputStream);
                return true;
            }
            if (r.getStatus() == 202) {
                this.sessionInit((String)r.getHeaders().getFirst((Object)"X-SHELL-SESSION-ID"), outputStream);
                return false;
            }
            throw RestUtils.handleResponseCode(r, "init", "config-shell");
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Exception e) {
            throw new ServiceException("Unexpected exception:" + e.getMessage(), null, (Throwable)e);
        }
    }

    public void goOnlineWLST() throws ServiceException {
        try {
            if (this.logFetcher == null || this.logFetcher.isDone()) {
                throw new RuntimeException("Session is not active");
            }
            WebResource w = this.jerseyClient.resource(this.baseUrl);
            w = w.path("online");
            Logger.getDEFAULT().printlnDebug("PUT at " + w.getURI().toString());
            ClientResponse r = (ClientResponse)w.accept(new String[]{"application/xml"}).put(ClientResponse.class);
            if (r.getStatus() != 201) {
                throw RestUtils.handleResponseCode(r, "online", "config-shell");
            }
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Exception e) {
            throw new ServiceException("Unexpected exception:" + e.getMessage(), null, (Throwable)e);
        }
    }

    public void goOffLineWLST() throws ServiceException {
        try {
            if (this.logFetcher == null || this.logFetcher.isDone()) {
                throw new RuntimeException("Session is not active");
            }
            WebResource w = this.jerseyClient.resource(this.baseUrl);
            w = w.path("offline");
            Logger.getDEFAULT().printlnDebug("PUT at " + w.getURI().toString());
            ClientResponse r = (ClientResponse)w.accept(new String[]{"application/xml"}).put(ClientResponse.class);
            if (r.getStatus() != 201) {
                throw RestUtils.handleResponseCode(r, "offline", "config-shell");
            }
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Exception e) {
            throw new ServiceException("Unexpected exception:" + e.getMessage(), null, (Throwable)e);
        }
    }

    public boolean isRunning() throws ServiceException {
        return this.logFetcher != null && !this.logFetcher.isDone();
    }

    public void endWLSTSession() throws ServiceException {
        try {
            WebResource w = this.jerseyClient.resource(this.baseUrl);
            w = w.path("end");
            Logger.getDEFAULT().printlnDebug("PUT at " + w.getURI().toString());
            ClientResponse r = (ClientResponse)w.accept(new String[]{"application/xml"}).put(ClientResponse.class);
            if (r.getStatus() != 201) {
                throw RestUtils.handleResponseCode(r, "end", "config-shell");
            }
            while (!this.logFetcher.isDone()) {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            this.logFetcher = null;
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Exception e) {
            throw new ServiceException("Unexpected exception:" + e.getMessage(), null, (Throwable)e);
        }
    }

    public void executeWLSTCommand(CommandType cmd) throws ServiceException {
        try {
            if (this.logFetcher == null || this.logFetcher.isDone()) {
                throw new UnknownResourceException("config -shell", "session", "Session is not active");
            }
            WebResource w = this.jerseyClient.resource(this.baseUrl);
            w = w.path("command");
            Logger.getDEFAULT().printlnDebug("POST at " + w.getURI().toString());
            ClientResponse r = (ClientResponse)w.entity((Object)new ObjectFactory().createCommand(cmd), "application/xml").post(ClientResponse.class);
            if (r.getStatus() != 202) {
                throw RestUtils.handleResponseCode(r, "offline", "config-shell");
            }
            this.logFetcher.interrupt();
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Exception e) {
            throw new ServiceException("Unexpected exception:" + e.getMessage(), null, (Throwable)e);
        }
    }

    public boolean isPendingServerRestart() throws ServiceException {
        return this.resourceService.isPendingServerRestart();
    }

    public UserInstanceType describeService() throws ServiceException {
        return this.resourceService.describeService();
    }
}

