/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudlogic.javaservice.admin.impl.javacloud;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.ConnectException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.cloud.paas.api.ApplicationManager;
import oracle.cloud.paas.api.ApplicationManagerConnectionFactory;
import oracle.cloud.paas.api.LibraryManager;
import oracle.cloud.paas.api.LibraryManagerConnectionFactory;
import oracle.cloud.paas.exception.ConnectionException;
import oracle.cloud.paas.exception.ResourceBusyException;
import oracle.cloud.paas.exception.UnknownResourceException;
import oracle.cloud.paas.model.Application;
import oracle.cloud.paas.model.ApplicationState;
import oracle.cloud.paas.model.ApplicationType;
import oracle.cloud.paas.model.Association;
import oracle.cloud.paas.model.Job;
import oracle.cloud.paas.model.JobStatus;
import oracle.cloud.paas.model.Log;
import oracle.cloud.paas.model.ServiceInstance;
import oracle.cloud.paas.model.ServiceState;
import oracle.cloudlogic.javaservice.admin.impl.javacloud.DataSourceJndiServiceImpl;
import oracle.cloudlogic.javaservice.admin.impl.javacloud.FileAccessShellServiceImpl;
import oracle.cloudlogic.javaservice.admin.impl.javacloud.filter.SAMLTokenAuthFilter;
import oracle.cloudlogic.javaservice.admin.impl.javacloud.filter.TenantHeaderFilter;
import oracle.cloudlogic.javaservice.admin.impl.javacloud.wlst.WLSTAccessShellServiceImpl;
import oracle.cloudlogic.javaservice.common.api.BasicService;
import oracle.cloudlogic.javaservice.common.api.ServiceManager;
import oracle.cloudlogic.javaservice.common.api.exception.AuthenticationException;
import oracle.cloudlogic.javaservice.common.api.exception.DuplicateResourceException;
import oracle.cloudlogic.javaservice.common.api.exception.NotAServiceUrlException;
import oracle.cloudlogic.javaservice.common.api.exception.ResourcePermissionException;
import oracle.cloudlogic.javaservice.common.api.exception.ServiceException;
import oracle.cloudlogic.javaservice.common.api.exception.ServiceNotAvailableException;
import oracle.cloudlogic.javaservice.common.api.service.ApplicationService;
import oracle.cloudlogic.javaservice.common.api.service.ResourceManagerService;
import oracle.cloudlogic.javaservice.common.api.service.ResourceService;
import oracle.cloudlogic.javaservice.common.api.service.async.AsyncApplicationService;
import oracle.cloudlogic.javaservice.common.api.service.async.AsyncJobService;
import oracle.cloudlogic.javaservice.common.api.service.resource.CredentialService;
import oracle.cloudlogic.javaservice.common.api.service.resource.DataSourceJndiService;
import oracle.cloudlogic.javaservice.common.api.service.resource.KeyStoreManagerService;
import oracle.cloudlogic.javaservice.common.api.service.resource.SSLService;
import oracle.cloudlogic.javaservice.common.api.service.resource.fileaccess.FileAccessShellService;
import oracle.cloudlogic.javaservice.common.api.service.resource.wlst.WLSTAccessShellService;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;
import oracle.cloudlogic.javaservice.common.spi.SecurityTokenProvider;
import oracle.cloudlogic.javaservice.types.AppStatus;
import oracle.cloudlogic.javaservice.types.AppType;
import oracle.cloudlogic.javaservice.types.AssociationType;
import oracle.cloudlogic.javaservice.types.InstanceSize;
import oracle.cloudlogic.javaservice.types.JobType;
import oracle.cloudlogic.javaservice.types.LogType;
import oracle.cloudlogic.javaservice.types.PathType;
import oracle.cloudlogic.javaservice.types.UserInstanceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServiceManagerJavaCloudBaseImpl
implements ServiceManager,
ResourceManagerService,
ApplicationService,
AsyncApplicationService,
AsyncJobService,
KeyStoreManagerService,
SSLService,
CredentialService,
FileAccessShellService,
DataSourceJndiService,
WLSTAccessShellService {
    ApplicationManager appmanager = null;
    FileAccessShellService fileacecss = null;
    WLSTAccessShellService wlstaccess = null;
    protected String identityDomain = null;
    protected String serviceInstance = null;
    protected LibraryManager libManager = null;
    protected Client jerseyClient = null;
    protected Map<String, Object> properties = null;
    protected String url = null;
    protected String URL_OPSS_KEYSTORE = null;
    protected String URL_SSL = null;
    protected String URL_FILES = null;
    protected String URL_CREDENTIAL_STORE = null;
    protected String URL_CREDENTIAL_STORE_SERVICE_ADMIN = null;
    protected String URL_SYSTEM = null;
    protected String URL_DS_JNDI = null;
    protected String URL_WLST = null;
    DataSourceJndiService dataSourceJndi = null;

    public ApplicationType toNuviaqType(AppType t) {
        return ApplicationType.valueOf((String)t.toString().toUpperCase());
    }

    ServiceManagerJavaCloudBaseImpl(String url, String identityDomain, String serviceInstance, String user, byte[] pwd, Map<String, Object> properties) throws ServiceException {
        try {
            this.appmanager = ApplicationManagerConnectionFactory.createServiceEndpoint((URL)new URL(url), (String)identityDomain, (String)user, (String)(pwd == null ? null : new String(pwd, "UTF-8")));
            this.libManager = LibraryManagerConnectionFactory.createServiceEndpoint((URL)new URL(url), (String)identityDomain, (String)user, (String)(pwd == null ? null : new String(pwd, "UTF-8")));
            this.identityDomain = identityDomain;
            this.serviceInstance = serviceInstance;
            if (url == null) {
                throw new ServiceException("url can not be null");
            }
            while (url.endsWith("/")) {
                url = url.substring(0, url.length() - 1);
            }
            URL u = null;
            try {
                u = new URL(url);
                u = new URL(u.getProtocol(), u.getHost(), u.getPort(), "/paas/java/v13.2/" + identityDomain + "/" + serviceInstance);
                this.url = u.toString();
            }
            catch (Exception e) {
                throw new ServiceException("Invalid url", null, (Throwable)e);
            }
            this.properties = properties;
            this.jerseyClient = Client.create();
            if (pwd == null) {
                SecurityTokenProvider tokenProvider = null;
                if (this.properties != null) {
                    tokenProvider = (SecurityTokenProvider)this.properties.get("PROP_SECURITY_TOKEN_PROVIDER");
                }
                if (tokenProvider == null) {
                    throw new ServiceException("Please set (SecurityTokenProvider.PROP_SECURITY_TOKEN_PROVIDER) PROP_SECURITY_TOKEN_PROVIDER as a property when the password is not set");
                }
                this.jerseyClient.addFilter((ClientFilter)new SAMLTokenAuthFilter(user, tokenProvider));
            } else {
                this.jerseyClient.addFilter((ClientFilter)new HTTPBasicAuthFilter(user, new String(pwd, "UTF-8")));
            }
            this.jerseyClient.addFilter((ClientFilter)new TenantHeaderFilter(identityDomain));
            this.URL_SYSTEM = this.url + "/system/";
            this.URL_CREDENTIAL_STORE = this.url + "/credentialmaps/";
            this.URL_CREDENTIAL_STORE_SERVICE_ADMIN = this.url + "/credentialstore/";
            this.URL_OPSS_KEYSTORE = this.url + "/keystorestripes/";
            this.URL_SSL = this.url + "/wlstruststore/";
            this.URL_FILES = this.url + "/files/";
            this.URL_DS_JNDI = this.url + "/datasources/";
            this.URL_WLST = this.url + "/config-shell/";
            this.fileacecss = new FileAccessShellServiceImpl(this.jerseyClient, this.URL_FILES, (ResourceService)this);
            this.wlstaccess = new WLSTAccessShellServiceImpl(this.jerseyClient, this.URL_WLST, (ResourceService)this);
            this.dataSourceJndi = new DataSourceJndiServiceImpl(this.jerseyClient, this.URL_DS_JNDI, (ResourceService)this);
        }
        catch (Exception e) {
            if (CloudUtil.isCausedBy((Throwable)e, ConnectException.class) || CloudUtil.isCausedBy((Throwable)e, UnknownHostException.class)) {
                Logger.getDEFAULT().printlnTipI18n("NLS_ERROR_CONNECT_EXCEPTION", (Object)"httpproxy");
                Logger.getDEFAULT().printlnTip("The service may be down. It is also possible the host name or the port name is wrong in the url " + url);
            }
            throw new ServiceException(e.getMessage(), "null", (Throwable)e);
        }
    }

    protected void handleException(Exception e, String resource, String type) throws ServiceException {
        if (ServiceException.class.isAssignableFrom(e.getClass())) {
            throw (ServiceException)((Object)e);
        }
        if (oracle.cloud.paas.exception.AuthenticationException.class.isAssignableFrom(e.getClass())) {
            throw new AuthenticationException(e.getMessage());
        }
        if (oracle.cloud.paas.exception.DuplicateResourceException.class.isAssignableFrom(e.getClass())) {
            throw new DuplicateResourceException(resource, type, e.getMessage());
        }
        if (ConnectionException.class.isAssignableFrom(e.getClass())) {
            throw new NotAServiceUrlException(e.getMessage());
        }
        if (ResourceBusyException.class.isAssignableFrom(e.getClass())) {
            throw new oracle.cloudlogic.javaservice.common.api.exception.ResourceBusyException(resource, type, this.from(((ResourceBusyException)e).getActiveJob()), e.getMessage());
        }
        if (UnknownResourceException.class.isAssignableFrom(e.getClass())) {
            throw new oracle.cloudlogic.javaservice.common.api.exception.UnknownResourceException(resource, type, e.getMessage());
        }
        if (oracle.cloud.paas.exception.ResourcePermissionException.class.isAssignableFrom(e.getClass())) {
            throw new ResourcePermissionException(resource, type, e.getMessage());
        }
        throw new ServiceException(e.getMessage(), null, (Throwable)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void throwLastLogAsError(Job job) throws ServiceException {
        ByteArrayOutputStream bo = null;
        try {
            try {
                List logs = this.appmanager.listJobLogs(job.getJobId());
                bo = new ByteArrayOutputStream();
                this.appmanager.fetchJobLog(job.getJobId(), ((Log)logs.get(logs.size() - 1)).getName(), (OutputStream)bo);
                throw new ServiceException(((Log)logs.get(logs.size() - 1)).getName() + " failed.", "null", bo.toByteArray());
            }
            catch (Exception e) {
                this.handleException(e, job.getJobId(), "job");
                if (bo != null) {
                    try {
                        bo.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Throwable throwable) {
            if (bo != null) {
                try {
                    bo.close();
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
            throw throwable;
        }
    }

    private void waitForJob(Job job) throws ServiceException {
        Logger.getDEFAULT().printlnInfo("Job:" + job.getJobId() + " Operation:" + job.getOperation());
        while (true) {
            if (job.getStatus() == JobStatus.FAILED) {
                this.throwLastLogAsError(job);
            }
            if (job.getStatus() == JobStatus.COMPLETE) break;
            if (job.getStatus() == JobStatus.CANCELLED) {
                throw new ServiceException("Deployment cancelled.");
            }
            try {
                Thread.currentThread();
                Thread.sleep(10000L);
            }
            catch (Exception e) {
                throw new ServiceException(e.getMessage(), null, (Throwable)e);
            }
            job = this.appmanager.describeJob(job.getJobId());
        }
    }

    public <T extends BasicService> boolean isServiceImplemented(Class<T> clazz) throws ServiceException {
        return clazz.isAssignableFrom(this.getClass());
    }

    public <T extends BasicService> boolean isServiceAvailable(Class<T> clazz) throws ServiceException {
        return this.isServiceImplemented(clazz);
    }

    public <T extends BasicService> T getService(Class<T> clazz) throws ServiceNotAvailableException {
        if (clazz.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        throw new ServiceNotAvailableException();
    }

    public void close() throws IOException {
    }

    public boolean validateApplication(InputStream in, InputStream plan, AppType type, OutputStream log) throws ServiceException {
        return false;
    }

    public JobType installApplicationAsync(InputStream in, InputStream plan, String name, AppType type, AppStatus desiredStatus) throws ServiceException {
        Job job = null;
        try {
            job = desiredStatus == null ? this.appmanager.deployApplication(this.identityDomain, this.serviceInstance, name, this.toNuviaqType(type), in) : this.appmanager.deployApplication(this.identityDomain, this.serviceInstance, name, this.toNuviaqType(type), in, ApplicationState.valueOf((String)desiredStatus.toString().toUpperCase()));
            return this.from(job);
        }
        catch (Exception e) {
            this.handleException(e, name, "application");
            return null;
        }
    }

    public JobType updateApplicationAsync(InputStream in, InputStream plan, String name, AppStatus applicationState) throws ServiceException {
        Job job = null;
        try {
            job = this.appmanager.redeployApplication(this.identityDomain, this.serviceInstance, name, in);
            return this.from(job);
        }
        catch (Exception e) {
            this.handleException(e, name, "application");
            return null;
        }
    }

    public JobType deleteApplicationAsync(String name) throws ServiceException {
        Job job = null;
        try {
            job = this.appmanager.undeployApplication(this.identityDomain, this.serviceInstance, name);
            return this.from(job);
        }
        catch (Exception e) {
            this.handleException(e, name, "application");
            return null;
        }
    }

    public JobType startApplicationAsync(String name, AppStatus desiredStatus) throws ServiceException {
        Job job = null;
        try {
            job = desiredStatus == null ? this.appmanager.startApplication(this.identityDomain, this.serviceInstance, name) : this.appmanager.startApplication(this.identityDomain, this.serviceInstance, name, ApplicationState.valueOf((String)desiredStatus.toString().toUpperCase()));
            this.waitForJob(job);
        }
        catch (Exception e) {
            this.handleException(e, name, "application");
        }
        return null;
    }

    public JobType stopApplicationAsync(String name) throws ServiceException {
        Job job = null;
        try {
            job = this.appmanager.stopApplication(this.identityDomain, this.serviceInstance, name);
            return this.from(job);
        }
        catch (Exception e) {
            this.handleException(e, name, "application");
            return null;
        }
    }

    public void installApplication(InputStream in, InputStream plan, String name, AppType type, AppStatus desiredStatus) throws ServiceException {
        Job job = null;
        try {
            job = desiredStatus == null ? this.appmanager.deployApplication(this.identityDomain, this.serviceInstance, name, this.toNuviaqType(type), in) : this.appmanager.deployApplication(this.identityDomain, this.serviceInstance, name, this.toNuviaqType(type), in, ApplicationState.valueOf((String)desiredStatus.toString().toUpperCase()));
            this.waitForJob(job);
        }
        catch (Exception e) {
            this.handleException(e, name, "application");
        }
    }

    public void updateApplication(InputStream in, InputStream plan, String name, AppStatus applicationState) throws ServiceException {
        Job job = null;
        try {
            job = this.appmanager.redeployApplication(this.identityDomain, this.serviceInstance, name, in);
            this.waitForJob(job);
        }
        catch (Exception e) {
            this.handleException(e, name, "application");
        }
    }

    public void deleteApplication(String name) throws ServiceException {
        Job job = null;
        try {
            job = this.appmanager.undeployApplication(this.identityDomain, this.serviceInstance, name);
            this.waitForJob(job);
        }
        catch (Exception e) {
            this.handleException(e, name, "application");
        }
    }

    public void startApplication(String name, AppStatus desiredStatus) throws ServiceException {
        Job job = null;
        try {
            job = desiredStatus == null ? this.appmanager.startApplication(this.identityDomain, this.serviceInstance, name) : this.appmanager.startApplication(this.identityDomain, this.serviceInstance, name, ApplicationState.valueOf((String)desiredStatus.toString().toUpperCase()));
            this.waitForJob(job);
        }
        catch (Exception e) {
            this.handleException(e, name, "application");
        }
    }

    public void stopApplication(String name) throws ServiceException {
        Job job = null;
        try {
            job = this.appmanager.stopApplication(this.identityDomain, this.serviceInstance, name);
            this.waitForJob(job);
        }
        catch (Exception e) {
            this.handleException(e, name, "application");
        }
    }

    public List<oracle.cloudlogic.javaservice.types.ApplicationType> listApplications() throws ServiceException {
        return this.fromAppList(this.appmanager.listApplications(this.identityDomain, this.serviceInstance));
    }

    public oracle.cloudlogic.javaservice.types.ApplicationType describeApplication(String appName) throws ServiceException {
        return this.from(this.appmanager.describeApplication(this.identityDomain, this.serviceInstance, appName));
    }

    public UserInstanceType describeService() throws ServiceException {
        return this.from(this.appmanager.describeServiceInstance(this.identityDomain, this.serviceInstance));
    }

    public UserInstanceType from(ServiceInstance service) {
        UserInstanceType u = new UserInstanceType();
        u.setName(service.getInstanceName());
        u.setSize(InstanceSize.fromValue((String)service.getSize().toString().toUpperCase().trim()));
        u.setActive(Boolean.valueOf(ServiceState.ACTIVE == service.getState()));
        u.setState(service.getState().toString());
        u.getAssociation().addAll(this.fromAssociationList(service.getAssociations()));
        return u;
    }

    public JobType from(Job job) {
        JobType j = new JobType();
        j.setAction(job.getOperation());
        j.setEndtime(job.getEndedOn());
        j.setId(job.getJobId());
        j.setUpdatetime(job.getUpdatedOn());
        j.setStarttime(job.getStartedOn());
        j.setStatus(job.getStatus().toString());
        return j;
    }

    public LogType from(Log log) {
        LogType j = new LogType();
        j.setContenttype(log.getContentType());
        j.setName(log.getName());
        j.setUpdatetime(log.getLastModified());
        return j;
    }

    public oracle.cloudlogic.javaservice.types.ApplicationType from(Application app) {
        oracle.cloudlogic.javaservice.types.ApplicationType t = new oracle.cloudlogic.javaservice.types.ApplicationType();
        t.setName(app.getApplicationName());
        t.setStatus(AppStatus.valueOf((String)app.getState().toString().toUpperCase()));
        t.setType(AppType.valueOf((String)app.getType().toString().toUpperCase()));
        t.getUrls().addAll(app.getApplicationUrls());
        return t;
    }

    public AssociationType from(Association a) {
        AssociationType t = new AssociationType();
        t.setName(a.getTargetInstanceName());
        t.setType(a.getTargetServiceType().toString());
        t.setActive(Boolean.valueOf(true));
        t.setState("Active");
        return t;
    }

    public List<oracle.cloudlogic.javaservice.types.ApplicationType> fromAppList(List<Application> apps) {
        ArrayList<oracle.cloudlogic.javaservice.types.ApplicationType> list = new ArrayList<oracle.cloudlogic.javaservice.types.ApplicationType>();
        for (Application app : apps) {
            list.add(this.from(app));
        }
        return list;
    }

    public List<LogType> fromLogList(List<Log> apps) {
        ArrayList<LogType> list = new ArrayList<LogType>();
        for (Log app : apps) {
            list.add(this.from(app));
        }
        return list;
    }

    public List<JobType> fromJobList(List<Job> apps) {
        ArrayList<JobType> list = new ArrayList<JobType>();
        for (Job app : apps) {
            list.add(this.from(app));
        }
        return list;
    }

    public List<AssociationType> fromAssociationList(List<Association> apps) {
        ArrayList<AssociationType> list = new ArrayList<AssociationType>();
        for (Association app : apps) {
            list.add(this.from(app));
        }
        return list;
    }

    public List<JobType> listJobs() throws ServiceException {
        return this.fromJobList(this.appmanager.listJobs(this.identityDomain, this.serviceInstance));
    }

    public List<LogType> listJobLogs(String jobid) throws ServiceException {
        return this.fromLogList(this.appmanager.listJobLogs(jobid));
    }

    public JobType describeJob(String jobid) throws ServiceException {
        return this.from(this.appmanager.describeJob(jobid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getJobLog(String jobid, String logname) throws ServiceException {
        PipedOutputStream out = new PipedOutputStream();
        PipedInputStream ret = null;
        try {
            ret = new PipedInputStream(out);
            this.appmanager.fetchJobLog(jobid, logname, (OutputStream)out);
        }
        catch (Exception e) {
            this.handleException(e, logname, "log");
        }
        finally {
            try {
                out.close();
            }
            catch (IOException io) {}
        }
        return ret;
    }

    public boolean isPendingServerRestart() throws ServiceException {
        return false;
    }

    public <T extends ResourceService> T getResourceService(Class<T> clazz) throws ServiceNotAvailableException {
        if (clazz.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        throw new ServiceNotAvailableException();
    }

    public <T extends ResourceService> boolean isResourceServiceImplemented(Class<T> clazz) throws ServiceException {
        return clazz.isAssignableFrom(this.getClass());
    }

    public <T extends ResourceService> boolean isResourceServiceAvailable(Class<T> clazz) throws ServiceException {
        return this.isResourceServiceImplemented(clazz);
    }

    public String pwd() {
        return this.fileacecss.pwd();
    }

    public void cd(String newDir) throws ServiceException {
        this.fileacecss.cd(newDir);
    }

    public void cd() throws ServiceException {
        this.fileacecss.cd();
    }

    public List<? extends PathType> list() throws ServiceException {
        return this.fileacecss.list();
    }

    public List<? extends PathType> list(String dir) throws ServiceException {
        return this.fileacecss.list(dir);
    }

    public PathType describe(String path) throws ServiceException {
        return this.fileacecss.describe(path);
    }

    public void mkdir(String dir) throws ServiceException {
        this.fileacecss.mkdir(dir);
    }

    public void delete(String dir, boolean recursive) throws ServiceException {
        this.fileacecss.delete(dir, recursive);
    }

    public InputStream read(String path) throws ServiceException {
        return this.fileacecss.read(path);
    }

    public void write(String path, InputStream in, boolean create) throws ServiceException {
        this.fileacecss.write(path, in, create);
    }

    public void rename(String sourcepath, String destination, boolean force) throws ServiceException {
        this.fileacecss.rename(sourcepath, destination, force);
    }

    public void copy(String sourcepath, String destination, boolean force) throws ServiceException {
        this.fileacecss.copy(sourcepath, destination, force);
    }

    public InputStream readAsZip(String path) throws ServiceException {
        return this.fileacecss.readAsZip(path);
    }
}

