/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudlogic.javaservice.admin.impl.javacloud;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Logger;
import oracle.cloudlogic.javaservice.admin.impl.javacloud.RestUtils;
import oracle.cloudlogic.javaservice.common.api.exception.ServiceException;
import oracle.cloudlogic.javaservice.common.api.service.ResourceService;
import oracle.cloudlogic.javaservice.common.api.service.resource.KeyService;
import oracle.cloudlogic.javaservice.types.PrivateKeyListType;
import oracle.cloudlogic.javaservice.types.PrivateKeyType;
import oracle.cloudlogic.javaservice.types.UserInstanceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyServiceImpl
implements KeyService {
    protected Client jerseyClient = null;
    protected String baseUrl = null;
    protected ResourceService resourceService;
    Logger logger = Logger.getLogger(KeyServiceImpl.class.getName());

    public KeyServiceImpl(Client jerseyClient, String baseUrl, ResourceService resource) {
        this.jerseyClient = jerseyClient;
        this.baseUrl = baseUrl;
        this.resourceService = resource;
    }

    public List<PrivateKeyType> listPrivateKeys() throws ServiceException {
        WebResource w = this.jerseyClient.resource(this.baseUrl);
        ClientResponse r = (ClientResponse)w.accept(new String[]{"application/xml"}).get(ClientResponse.class);
        if (r.getStatus() != 200) {
            throw RestUtils.handleResponseCode(r, "", this.baseUrl);
        }
        return ((PrivateKeyListType)r.getEntity(new GenericType(PrivateKeyListType.class))).getPrivatekeytype();
    }

    public PrivateKeyType describePrivateKey(String alias) throws ServiceException {
        WebResource w = this.jerseyClient.resource(this.baseUrl + alias);
        ClientResponse r = (ClientResponse)w.accept(new String[]{"application/xml"}).get(ClientResponse.class);
        if (r.getStatus() != 200) {
            throw RestUtils.handleResponseCode(r, "", "private-key");
        }
        return (PrivateKeyType)r.getEntity(new GenericType(PrivateKeyListType.class));
    }

    public void addPrivateKey(String create_alias, InputStream keystore, String original_alias, byte[] storepass, byte[] keypass) throws ServiceException {
        throw new ServiceException("Unsupported operation.");
    }

    public void deletePrivateKey(String alias) throws ServiceException {
        WebResource w = this.jerseyClient.resource(this.baseUrl + alias);
        ClientResponse r = (ClientResponse)w.accept(new String[]{"application/xml"}).delete(ClientResponse.class);
        if (r.getStatus() != 202) {
            throw RestUtils.handleResponseCode(r, "", "private-key");
        }
    }

    public void resetKeyStore() throws ServiceException {
        throw new ServiceException("Unimplemented..");
    }

    public boolean isPendingServerRestart() throws ServiceException {
        return this.resourceService.isPendingServerRestart();
    }

    public UserInstanceType describeService() throws ServiceException {
        return this.resourceService.describeService();
    }
}

