/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudlogic.javaservice.admin.impl.javacloud;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.FormDataBodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MediaType;
import oracle.cloud.paas.javaservice.types.Files;
import oracle.cloudlogic.javaservice.admin.impl.javacloud.RestUtils;
import oracle.cloudlogic.javaservice.common.api.exception.DuplicateResourceException;
import oracle.cloudlogic.javaservice.common.api.exception.ResourcePermissionException;
import oracle.cloudlogic.javaservice.common.api.exception.ServiceException;
import oracle.cloudlogic.javaservice.common.api.exception.UnknownResourceException;
import oracle.cloudlogic.javaservice.common.api.service.ResourceService;
import oracle.cloudlogic.javaservice.common.api.service.resource.fileaccess.FileAccessShellService;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;
import oracle.cloudlogic.javaservice.types.FilePathType;
import oracle.cloudlogic.javaservice.types.FolderPathType;
import oracle.cloudlogic.javaservice.types.PathType;
import oracle.cloudlogic.javaservice.types.UserInstanceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileAccessShellServiceImpl
implements FileAccessShellService {
    protected Client jerseyClient = null;
    protected String baseUrl = null;
    protected ResourceService resourceService;
    private String pwd;
    private String lastPath = this.pwd = "/";

    public FileAccessShellServiceImpl(Client jerseyClient, String baseUrl, ResourceService resource) {
        this.jerseyClient = jerseyClient;
        this.baseUrl = baseUrl;
        this.resourceService = resource;
    }

    public boolean isPendingServerRestart() throws ServiceException {
        return this.resourceService.isPendingServerRestart();
    }

    public UserInstanceType describeService() throws ServiceException {
        return this.resourceService.describeService();
    }

    public String pwd() {
        if (!this.pwd.endsWith("/")) {
            return this.pwd + "/";
        }
        return this.pwd;
    }

    private MediaType getContentType(String path) throws ServiceException {
        if (path == null || path.trim().equals("")) {
            path = this.pwd();
        }
        WebResource w = this.jerseyClient.resource(this.baseUrl);
        w = w.path(path);
        Logger.getDEFAULT().printlnDebug("Head at " + w.getURI().toASCIIString());
        ClientResponse r = w.head();
        if (r.getStatus() == 204) {
            return r.getType();
        }
        if (r.getStatus() == 404) {
            return null;
        }
        try {
            throw RestUtils.handleResponseCode(r, path, "path");
        }
        catch (UnknownResourceException un) {
            return null;
        }
        catch (ServiceException se) {
            throw se;
        }
    }

    private boolean isDirByType(String type) {
        return "application/vnd.opc.directory".equals(type);
    }

    private boolean isDirByType(MediaType type) {
        if (type == null) {
            return false;
        }
        return this.isDirByType(type.toString());
    }

    private boolean exists(String path) throws ServiceException {
        return this.getContentType(path) != null;
    }

    private boolean isDirByPath(String path) throws ServiceException {
        if (path.endsWith("/")) {
            return true;
        }
        MediaType type = this.getContentType(path);
        if (type == null) {
            return false;
        }
        return this.isDirByType(type);
    }

    public void cd(String newDir) throws ServiceException {
        try {
            String path = this.toAbsPath(newDir);
            if (!this.isDirByPath(path)) {
                throw new ResourcePermissionException(newDir, "path", "Path \"" + path + "\" is not a directory");
            }
            this.lastPath = this.pwd;
            this.pwd = path;
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Exception e) {
            throw new ServiceException("Unexpected exception:" + e.getMessage(), null, (Throwable)e);
        }
    }

    public void cd() throws ServiceException {
        this.cd(this.lastPath.toString());
    }

    public List<? extends PathType> list() throws ServiceException {
        return this.list(this.pwd.toString());
    }

    public List<? extends PathType> list(String dir) throws ServiceException {
        try {
            PathType file = this.describe(dir);
            if (FilePathType.class.isAssignableFrom(file.getClass())) {
                ArrayList<PathType> list = new ArrayList<PathType>();
                list.add(file);
                return list;
            }
            String path = this.toAbsPath(dir);
            WebResource w = this.jerseyClient.resource(this.baseUrl);
            w = w.path(path);
            Logger.getDEFAULT().printlnDebug("Getting at " + w.getURI().toString());
            ClientResponse r = (ClientResponse)w.accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get(ClientResponse.class);
            if (r.getStatus() == 200) {
                Files files = (Files)r.getEntity(Files.class);
                ArrayList<Object> list = new ArrayList<Object>();
                for (Files.File f : files.getFile()) {
                    if (this.isDirByType(f.getType())) {
                        FolderPathType folder = new FolderPathType();
                        folder.setPath(f.getPath());
                        list.add(folder);
                        continue;
                    }
                    FilePathType filePath = new FilePathType();
                    filePath.setPath(f.getPath());
                    filePath.setMimeType(f.getType());
                    filePath.setModifiedOn(f.getModifiedOn().toGregorianCalendar().getTime());
                    filePath.setInteger(f.getInteger());
                    list.add(filePath);
                }
                return list;
            }
            throw RestUtils.handleResponseCode(r, dir, "path");
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Exception e) {
            throw new ServiceException("Unexpected exception:" + e.getMessage(), null, (Throwable)e);
        }
    }

    private String toAbsPath(String path) throws Exception {
        return this.toAbsPath(this.pwd(), path);
    }

    private String toAbsFromDir(String dir, String path) throws Exception {
        if (dir != null) {
            if (!dir.endsWith("/")) {
                dir = dir + "/";
            }
            return this.toAbsPath(dir, path);
        }
        return this.toAbsPath(null, path);
    }

    public static String encodeURIcomponent(String s) {
        StringBuilder o = new StringBuilder();
        for (char ch : s.toCharArray()) {
            if (FileAccessShellServiceImpl.isUnsafe(ch)) {
                o.append('%');
                o.append(FileAccessShellServiceImpl.toHex(ch / 16));
                o.append(FileAccessShellServiceImpl.toHex(ch % 16));
                continue;
            }
            o.append(ch);
        }
        return o.toString();
    }

    private static char toHex(int ch) {
        return (char)(ch < 10 ? 48 + ch : 65 + ch - 10);
    }

    private static boolean isUnsafe(char ch) {
        if (ch > '\u0080' || ch < '\u0000') {
            return true;
        }
        return (" " + new String(FileAccessShellService.not_allowed_chars)).indexOf(ch) >= 0;
    }

    private String toAbsPath(String pwd, String path) throws Exception {
        if (pwd == null) {
            pwd = this.pwd;
        }
        if (path == null) {
            return pwd.toString();
        }
        URI ret = null;
        try {
            ret = new URI(FileAccessShellServiceImpl.encodeURIcomponent(pwd)).resolve(FileAccessShellServiceImpl.encodeURIcomponent(path)).normalize();
        }
        catch (Exception sn) {
            throw new ResourcePermissionException(path, "path", "Invalid path specified: '" + path + "'");
        }
        if (ret.toString().contains("..")) {
            ret = new URI("/" + new File(path).getName());
        }
        String decode = URLDecoder.decode(ret.toString());
        Logger.getDEFAULT().printlnDebug("Absolute canonical Path:'" + decode + "' for given '" + path + "' base " + pwd);
        return decode;
    }

    public PathType describe(String path) throws ServiceException {
        try {
            path = this.toAbsPath(path);
            MediaType type = this.getContentType(path);
            if (type == null) {
                throw new UnknownResourceException(path, "path");
            }
            if (this.isDirByType(type)) {
                FolderPathType folder = new FolderPathType();
                folder.setPath(path);
                return folder;
            }
            if (this.isDirByPath(path)) {
                throw new ServiceException("Contract mismatch;Directory detection failed.");
            }
            String name = new File(path).getName();
            List<? extends PathType> list = this.list(path + "/..");
            for (PathType pathType : list) {
                if (!new File(pathType.getPath()).getName().equals(name)) continue;
                return pathType;
            }
            throw new UnknownResourceException(path, "path");
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceException("Unexpected exception:" + e.getMessage(), null, (Throwable)e);
        }
    }

    public void mkdir(String dir) throws ServiceException {
        try {
            dir = this.toAbsPath(dir);
            if (this.exists(dir)) {
                throw new DuplicateResourceException(dir, "path");
            }
            WebResource w = this.jerseyClient.resource(this.baseUrl);
            w = w.path(dir);
            Logger.getDEFAULT().printlnDebug("Creating at " + w.getURI().toString());
            ClientResponse r = (ClientResponse)w.post(ClientResponse.class);
            if (r.getStatus() != 201) {
                throw RestUtils.handleResponseCode(r, dir, "path");
            }
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceException("Unexpected exception", null, (Throwable)e);
        }
    }

    public void delete(String dir, boolean recursive) throws ServiceException {
        try {
            dir = this.toAbsPath(dir);
            if (!this.exists(dir)) {
                throw new UnknownResourceException(dir, "path");
            }
            WebResource w = this.jerseyClient.resource(this.baseUrl);
            w = w.path(dir);
            if (recursive) {
                w = w.queryParam("recursive", "true");
            }
            Logger.getDEFAULT().printlnDebug("Deleting at " + w.getURI().toString());
            ClientResponse r = (ClientResponse)w.delete(ClientResponse.class);
            if (r.getStatus() != 204) {
                throw RestUtils.handleResponseCode(r, dir, "path");
            }
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Exception e) {
            throw new ServiceException("Unexpected exception:" + e.getMessage(), null, (Throwable)e);
        }
    }

    public InputStream read(String path) throws ServiceException {
        try {
            path = this.toAbsPath(path);
            MediaType type = this.getContentType(path);
            if (type == null) {
                throw new UnknownResourceException(path, "path");
            }
            if (this.isDirByType(type)) {
                throw new ResourcePermissionException(path, "path", path + " is not a file");
            }
            WebResource w = this.jerseyClient.resource(this.baseUrl);
            w = w.path(path);
            Logger.getDEFAULT().printlnDebug("Getting at " + w.getURI().toString());
            ClientResponse r = (ClientResponse)w.get(ClientResponse.class);
            if (r.getStatus() != 200) {
                throw RestUtils.handleResponseCode(r, path, "path");
            }
            return r.getEntityInputStream();
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Exception e) {
            throw new ServiceException("Unexpected exception:" + e.getMessage(), null, (Throwable)e);
        }
    }

    public InputStream readAsZip(String path) throws ServiceException {
        try {
            path = this.toAbsPath(path);
            MediaType type = this.getContentType(path);
            if (type == null) {
                throw new UnknownResourceException(path, "path");
            }
            if (!this.isDirByType(type)) {
                throw new ResourcePermissionException(path, "path", "Not a dir");
            }
            WebResource w = this.jerseyClient.resource(this.baseUrl);
            w = w.path(path);
            w = w.queryParam("zip", "true");
            Logger.getDEFAULT().printlnDebug("Getting at " + w.getURI().toString());
            ClientResponse r = (ClientResponse)w.get(ClientResponse.class);
            if (r.getStatus() != 200) {
                throw RestUtils.handleResponseCode(r, path, "path");
            }
            return r.getEntityInputStream();
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Exception e) {
            throw new ServiceException("Unexpected exception:" + e.getMessage(), null, (Throwable)e);
        }
    }

    public void write(String path, InputStream in, boolean force) throws ServiceException {
        try {
            path = this.toAbsPath(path);
            MediaType type = this.getContentType(path);
            if (type != null) {
                if (this.isDirByType(type)) {
                    throw new ResourcePermissionException(path, "path", "Not a file");
                }
                if (!force) {
                    // empty if block
                }
            }
            WebResource w = this.jerseyClient.resource(this.baseUrl);
            w = w.path(path);
            FormDataMultiPart formDataMultiPart = new FormDataMultiPart();
            FormDataBodyPart bodyPart = new FormDataBodyPart("file", (Object)in, MediaType.APPLICATION_OCTET_STREAM_TYPE);
            formDataMultiPart.bodyPart((BodyPart)bodyPart);
            w = w.queryParam("recursive", String.valueOf(force));
            w = w.queryParam("file", new File(path).getName());
            Logger.getDEFAULT().printlnDebug("Posting:" + w.toString());
            ClientResponse r = (ClientResponse)w.type("multipart/form-data").post(ClientResponse.class, (Object)formDataMultiPart);
            if (r.getStatus() != 201) {
                throw RestUtils.handleResponseCode(r, path, "file");
            }
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Exception e) {
            throw new ServiceException("Unexpected exception:" + e.getMessage(), null, (Throwable)e);
        }
    }

    public void rename(String sourcepath, String destination, boolean force) throws ServiceException {
        try {
            sourcepath = this.toAbsPath(sourcepath);
            destination = this.toAbsPath(destination);
            MediaType sourcetype = this.getContentType(sourcepath);
            if (sourcetype == null) {
                throw new UnknownResourceException(sourcepath, "path");
            }
            MediaType targettype = this.getContentType(destination);
            if (targettype != null && this.isDirByType(targettype)) {
                destination = this.toAbsFromDir(destination, new File(sourcepath).getName());
            }
            WebResource w = this.jerseyClient.resource(this.baseUrl);
            w = w.path(sourcepath);
            w = w.queryParam("dest", destination);
            w = w.queryParam("force", String.valueOf(force));
            Logger.getDEFAULT().printlnDebug("Putting:" + w.toString());
            ClientResponse r = (ClientResponse)w.put(ClientResponse.class);
            if (r.getStatus() != 201) {
                throw RestUtils.handleResponseCode(r, sourcepath, "file");
            }
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Exception e) {
            throw new ServiceException("Unexpected exception:" + e.getMessage(), null, (Throwable)e);
        }
    }

    public void copy(String sourcepath, String destination, boolean recursive) throws ServiceException {
        try {
            sourcepath = this.toAbsPath(sourcepath);
            destination = this.toAbsPath(destination);
            MediaType sourcetype = this.getContentType(sourcepath);
            if (sourcetype == null) {
                throw new UnknownResourceException(sourcepath, "path");
            }
            MediaType destType = this.getContentType(destination);
            if (!this.isDirByType(sourcetype) && destType != null && this.isDirByType(destType)) {
                destination = this.toAbsFromDir(destination, new File(sourcepath).getName());
            }
            WebResource w = this.jerseyClient.resource(this.baseUrl);
            w = w.path(destination);
            FormDataMultiPart formDataMultiPart = new FormDataMultiPart();
            formDataMultiPart.bodyPart((BodyPart)new FormDataBodyPart("source", sourcepath));
            formDataMultiPart.bodyPart((BodyPart)new FormDataBodyPart("recursive", String.valueOf(recursive)));
            Logger.getDEFAULT().printlnDebug("Copying:" + w.toString() + ":force:" + recursive);
            ClientResponse r = (ClientResponse)w.type("multipart/form-data").post(ClientResponse.class, (Object)formDataMultiPart);
            if (r.getStatus() != 201) {
                throw RestUtils.handleResponseCode(r, sourcepath, "file");
            }
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Exception e) {
            throw new ServiceException("Unexpected exception:" + e.getMessage(), null, (Throwable)e);
        }
    }
}

