/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudlogic.javaservice.admin.impl.javacloud;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import oracle.cloudlogic.javaservice.admin.impl.javacloud.RestUtils;
import oracle.cloudlogic.javaservice.common.api.exception.ServiceException;
import oracle.cloudlogic.javaservice.common.api.service.ResourceService;
import oracle.cloudlogic.javaservice.common.api.service.resource.DataSourceJndiService;
import oracle.cloudlogic.javaservice.types.DataSourceJndiType;
import oracle.cloudlogic.javaservice.types.JndiNamesType;
import oracle.cloudlogic.javaservice.types.UserInstanceType;

public class DataSourceJndiServiceImpl
implements DataSourceJndiService {
    protected Client jerseyClient = null;
    protected String baseUrl = null;
    protected ResourceService resourceService;
    protected String regex = "[a-zA-Z0-9.:/_-]*";
    protected String dsRegex = "[a-zA-Z0-9.:/_-]*";

    public DataSourceJndiServiceImpl(Client jerseyClient, String baseUrl, ResourceService resourceService) {
        this.jerseyClient = jerseyClient;
        this.baseUrl = baseUrl;
        this.resourceService = resourceService;
    }

    public JndiNamesType listJndiNames(String dsName) throws ServiceException {
        if (dsName == null) {
            throw new IllegalArgumentException("Unexpected null for DataSource name.");
        }
        this.isDSNameValid(dsName);
        WebResource w = null;
        String restURL = this.baseUrl + dsName + "/jndinames";
        w = this.jerseyClient.resource(restURL);
        ClientResponse r = (ClientResponse)w.accept(new String[]{"application/xml"}).get(ClientResponse.class);
        if (r.getStatus() == 200 || r.getStatus() == 202) {
            return ((DataSourceJndiType)r.getEntity(new GenericType(DataSourceJndiType.class))).getJndinames();
        }
        throw RestUtils.handleResponseCode(r, "listJndiNames", "DataSourceJndiNames");
    }

    public void addJndiName(String dsName, String alias) throws ServiceException {
        if (dsName == null || alias == null) {
            throw new IllegalArgumentException("Unexpected null for DataSource name or JNDI alias.");
        }
        this.isDSNameValid(dsName);
        WebResource w = null;
        try {
            if (!alias.matches(this.regex)) {
                throw new ServiceException("Unsupported Special Character found in JNDI name : " + alias + "\nSupported Charaters in JNDI name : [a-z],[A-Z],[0-9],\":\",\".\",\"/\",\"-\",\"_\" ");
            }
            String restURL = this.baseUrl + dsName + "/jndinames/" + URLEncoder.encode(alias, "UTF-8");
            w = this.jerseyClient.resource(restURL);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new ServiceException(e.getMessage());
        }
        ClientResponse r = (ClientResponse)w.accept(new String[]{"application/xml"}).put(ClientResponse.class);
        if (r.getStatus() != 200 && r.getStatus() != 202) {
            throw RestUtils.handleResponseCode(r, "addJndiName", "DataSourceJndiNames");
        }
    }

    public void deleteJndiName(String dsName, String alias) throws ServiceException {
        if (dsName == null || alias == null) {
            throw new IllegalArgumentException("Unexpected null for DataSource name or JNDI alias.");
        }
        this.isDSNameValid(dsName);
        WebResource w = null;
        try {
            if (!alias.matches(this.regex)) {
                throw new ServiceException("Unsupported Special Character found in JNDI name : " + alias + "\nSupported Charaters in JNDI name : [a-z],[A-Z],[0-9],\":\",\".\",\"/\",\"-\",\"_\" ");
            }
            String restURL = this.baseUrl + dsName + "/jndinames/" + URLEncoder.encode(alias, "UTF-8");
            w = this.jerseyClient.resource(restURL);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new ServiceException(e.getMessage());
        }
        ClientResponse r = (ClientResponse)w.accept(new String[]{"application/xml"}).delete(ClientResponse.class);
        if (r.getStatus() != 200 && r.getStatus() != 202) {
            throw RestUtils.handleResponseCode(r, "deleteJndiName", "DataSourceJndiNames");
        }
    }

    public boolean isPendingServerRestart() throws ServiceException {
        return this.resourceService.isPendingServerRestart();
    }

    public UserInstanceType describeService() throws ServiceException {
        return this.resourceService.describeService();
    }

    private void isDSNameValid(String dsName) throws ServiceException {
        if (!dsName.matches(this.dsRegex)) {
            throw new ServiceException("Unsupported Special Character found in DataSource name : " + dsName + "\nSupported Charaters in DataSource name : [a-z],[A-Z],[0-9]");
        }
    }
}

