/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudlogic.javaservice.admin.impl.javacloud;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MediaType;
import oracle.cloud.paas.javaservice.types.KeyStoreEntryList;
import oracle.cloudlogic.javaservice.admin.impl.javacloud.RestUtils;
import oracle.cloudlogic.javaservice.common.api.exception.ServiceException;
import oracle.cloudlogic.javaservice.common.api.service.ResourceService;
import oracle.cloudlogic.javaservice.common.api.service.resource.CertificateService;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;
import oracle.cloudlogic.javaservice.types.Certificate;
import oracle.cloudlogic.javaservice.types.CertificateDescription;
import oracle.cloudlogic.javaservice.types.UserInstanceType;
import oracle.cloudlogic.javaservice.utils.pem.PemFileObject;
import oracle.cloudlogic.javaservice.utils.pem.PemFileReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificateServiceImpl
implements CertificateService {
    protected Client jerseyClient = null;
    protected String baseUrl = null;
    protected ResourceService resourceService;

    public CertificateServiceImpl(Client jerseyClient, String baseUrl, ResourceService resource) {
        this.jerseyClient = jerseyClient;
        this.baseUrl = baseUrl;
        this.resourceService = resource;
    }

    public void resetCertificateStore() throws ServiceException {
        Logger.getDEFAULT().printlnDebug("putting at " + this.baseUrl);
        WebResource w = this.jerseyClient.resource(this.baseUrl);
        ClientResponse r = (ClientResponse)w.type("application/x-www-form-urlencoded").put(ClientResponse.class);
        if (r.getStatus() == 204) {
            return;
        }
        throw RestUtils.handleResponseCode(r, "", "certificates");
    }

    public List<CertificateDescription> listCertificates() throws ServiceException {
        Logger.getDEFAULT().printlnDebug("Getting at " + this.baseUrl);
        WebResource w = this.jerseyClient.resource(this.baseUrl);
        ClientResponse r = (ClientResponse)w.type("application/x-www-form-urlencoded").get(ClientResponse.class);
        if (r.getStatus() == 200) {
            KeyStoreEntryList ret = RestUtils.readObject(r, KeyStoreEntryList.class);
            ArrayList<CertificateDescription> list = new ArrayList<CertificateDescription>();
            for (KeyStoreEntryList.Certificate item : ret.getCertificate()) {
                CertificateDescription pair = new CertificateDescription();
                pair.setAlias(item.getAlias());
                pair.setDn(item.getDn());
                if (item.getExpiryDate() == null) {
                    throw new ServiceException("Un-expected null value for certificate expiry date. The cert alias is:" + item.getAlias());
                }
                pair.setExpiry(item.getExpiryDate().toGregorianCalendar().getTime());
                list.add(pair);
            }
            return list;
        }
        throw RestUtils.handleResponseCode(r, "", "certificates");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Certificate describeCertificate(String alias) throws ServiceException {
        if (alias == null || alias.trim().equals("")) {
            throw new IllegalArgumentException("Unexpected null alias");
        }
        WebResource w = this.jerseyClient.resource(this.baseUrl + "certificates/" + alias).queryParam("operation", "exportCertificate");
        Logger.getDEFAULT().printlnDebug("Getting:" + w.toString());
        ClientResponse r = (ClientResponse)w.get(ClientResponse.class);
        if (r.getStatus() == 200) {
            PemFileReader reader = new PemFileReader((Reader)new InputStreamReader(r.getEntityInputStream()));
            PemFileObject obj = null;
            try {
                obj = reader.readPemObject();
            }
            catch (IOException io) {
                throw new ServiceException("Unable to read content with type:" + r.getType(), null, (Throwable)io);
            }
            if (obj == null) {
                throw new ServiceException("Unable to read PEM file");
            }
            if (!obj.isCertificate()) {
                throw new ServiceException("Unexpected PEM type:" + obj.getType());
            }
            Certificate cert = new Certificate();
            cert.setDescription(new CertificateDescription());
            cert.getDescription().setAlias(alias);
            cert.setContents(obj.getContent());
            ByteArrayInputStream inStream = null;
            try {
                inStream = new ByteArrayInputStream(cert.getContents());
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                X509Certificate decoded = (X509Certificate)cf.generateCertificate(inStream);
                cert.getDescription().setDn(((Object)decoded.getSubjectDN()).toString());
            }
            catch (Exception e) {
                Logger.getDEFAULT().printlnThrowable((Throwable)e);
            }
            finally {
                if (inStream != null) {
                    try {
                        ((InputStream)inStream).close();
                    }
                    catch (IOException io) {}
                }
            }
            return cert;
        }
        throw RestUtils.handleResponseCode(r, alias, "certificate");
    }

    public void addCertificate(InputStream certificate, String alias) throws ServiceException {
        if (alias == null || alias.trim().equals("") || certificate == null) {
            throw new IllegalArgumentException("Unexpected null for alias or certificate stream.");
        }
        PemFileObject pem = new PemFileObject(PemFileObject.FILE_TYPE.CERTIFICATE.toString(), CloudUtil.readAllFrom((InputStream)certificate, (boolean)false));
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        formData.add((Object)"alias", (Object)alias);
        formData.add((Object)"certificate", (Object)new String(pem.toByteArray()));
        WebResource w = this.jerseyClient.resource(this.baseUrl);
        Logger.getDEFAULT().printlnDebug("Posting:" + w.toString());
        ClientResponse r = (ClientResponse)w.type(MediaType.APPLICATION_FORM_URLENCODED_TYPE).post(ClientResponse.class, (Object)formData);
        if (r.getStatus() != 201) {
            throw RestUtils.handleResponseCode(r, alias, "certificate");
        }
    }

    public void deleteCertificate(String alias) throws ServiceException {
        if (alias == null || alias.trim().equals("")) {
            throw new IllegalArgumentException("Unexpected null for alias.");
        }
        WebResource w = this.jerseyClient.resource(this.baseUrl + "certificates/" + alias);
        Logger.getDEFAULT().printlnDebug("Deleting at " + w.getURI().toString());
        ClientResponse r = (ClientResponse)w.delete(ClientResponse.class);
        if (r.getStatus() != 204) {
            throw RestUtils.handleResponseCode(r, alias, "certificate");
        }
    }

    public boolean isPendingServerRestart() throws ServiceException {
        return this.resourceService.isPendingServerRestart();
    }

    public UserInstanceType describeService() throws ServiceException {
        return this.resourceService.describeService();
    }
}

