/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.tools;

import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.swt.SWT;

public class SapphireNodeDragEditPartsTracker
extends DragEditPartsTracker {
    protected static final String LAST_EDIT_PART = "LAST_EDIT_PART";

    public SapphireNodeDragEditPartsTracker(EditPart sourceEditPart) {
        super(sourceEditPart);
    }

    protected void performSelection() {
        if (this.hasSelectionOccurred()) {
            return;
        }
        this.setFlag(64, true);
        EditPartViewer viewer = this.getCurrentViewer();
        List selectedObjects = viewer.getSelectedEditParts();
        if (this.getCurrentInput().isModKeyDown(SWT.MOD1)) {
            EditPart deselectPart = this.getDeselectPart(selectedObjects, this.getSourceEditPart());
            if (deselectPart != null) {
                viewer.deselect(deselectPart);
            } else {
                viewer.appendSelection(this.getSourceEditPart());
                this.removeChildrenDuplicates(this.getSourceEditPart());
            }
            viewer.setProperty(LAST_EDIT_PART, (Object)this.getSourceEditPart());
        } else if (this.getCurrentInput().isShiftKeyDown()) {
            viewer.appendSelection(this.getSourceEditPart());
            viewer.setProperty(LAST_EDIT_PART, (Object)this.getSourceEditPart());
        } else {
            viewer.select(this.getSourceEditPart());
            viewer.setProperty(LAST_EDIT_PART, (Object)this.getSourceEditPart());
        }
    }

    protected EditPart getDeselectPart(List<EditPart> selectedObjects, EditPart sourceEditPart) {
        EditPart parent = sourceEditPart;
        while (parent != null) {
            if (selectedObjects.contains(parent)) {
                return parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    protected void removeChildrenDuplicates(EditPart sourceEditPart) {
        EditPartViewer viewer = this.getCurrentViewer();
        List selectedParts = viewer.getSelectedEditParts();
        for (Object child : sourceEditPart.getChildren()) {
            EditPart childPart = (EditPart)child;
            if (selectedParts.contains(child)) {
                viewer.deselect(childPart);
            }
            this.removeChildrenDuplicates(childPart);
        }
    }
}

